/*
 * Decompiled with CFR 0.152.
 */
package org.projog.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projog.test.ProjogTestRunnerConfig;
import org.projog.test.ProjogTestUtils;
import org.projog.test.ScriptRunner;

public final class ProjogTestRunner {
    private final ProjogTestRunnerConfig runnerConfig;

    public static TestResults runTests(File testResources) {
        return ProjogTestRunner.runTests(testResources, new ProjogTestRunnerConfig(){});
    }

    public static TestResults runTests(File testResources, ProjogTestRunnerConfig runnerConfig) {
        List<File> scripts = ProjogTestRunner.getScriptsToRun(testResources);
        return new ProjogTestRunner(runnerConfig).checkScripts(scripts);
    }

    private ProjogTestRunner(ProjogTestRunnerConfig runnerConfig) {
        this.runnerConfig = runnerConfig;
    }

    private static List<File> getScriptsToRun(File f) {
        if (!f.exists()) {
            throw new RuntimeException(f.getPath() + " not found");
        }
        ArrayList<File> scripts = new ArrayList<File>();
        if (f.isDirectory()) {
            ProjogTestRunner.findAllScriptsInDirectory(f, scripts);
        } else {
            scripts.add(f);
        }
        Collections.sort(scripts);
        return scripts;
    }

    private static void findAllScriptsInDirectory(File dir, List<File> scripts) {
        File[] files;
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                ProjogTestRunner.findAllScriptsInDirectory(f, scripts);
                continue;
            }
            if (!ProjogTestUtils.isPrologScript(f)) continue;
            scripts.add(f);
        }
    }

    private TestResults checkScripts(List<File> scripts) {
        long start = System.currentTimeMillis();
        Stream stream = this.runnerConfig.isParallel() ? scripts.parallelStream() : scripts.stream();
        List results = stream.map(f -> new ScriptRunner(this.runnerConfig, (File)f).checkScript()).sorted().collect(Collectors.toList());
        long duration = System.currentTimeMillis() - start;
        return new TestResults(results, duration);
    }

    public static class TestResults {
        private final StringBuilder summaries = new StringBuilder();
        private final StringBuilder errorMessages = new StringBuilder();
        private final int scriptsCount;
        private int queryCount;
        private int errorCount;
        private long duration;

        private TestResults(List<ScriptRunner.ScriptResults> results, long duration) {
            this.scriptsCount = results.size();
            this.duration = duration;
            for (ScriptRunner.ScriptResults r : results) {
                this.queryCount += r.getQueryCount();
                this.errorCount += r.getErrorCount();
                String s = r.getFile() + "\nCompleted " + r.getQueryCount() + " queries with " + r.getErrorCount() + " failures in: " + r.getDuration() + "ms\n";
                this.summaries.append(s);
                for (String error : r.getErrorMessages()) {
                    this.errorMessages.append(r.getFile() + " " + error + "\n");
                }
            }
        }

        public int getScriptsCount() {
            return this.scriptsCount;
        }

        public int getQueryCount() {
            return this.queryCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public boolean hasFailures() {
            return this.errorCount != 0;
        }

        public String getErrorMessages() {
            return this.errorMessages.toString();
        }

        public void assertSuccess() {
            if (this.hasFailures()) {
                throw new RuntimeException(this.errorCount + " test failures:\n" + this.errorMessages);
            }
        }

        public String getSummary() {
            StringBuilder sb = new StringBuilder();
            sb.append("Completed " + this.queryCount + " queries from " + this.scriptsCount + " files with " + this.errorCount + " failures in: " + this.duration + "ms\n\n");
            sb.append((CharSequence)this.summaries);
            if (this.hasFailures()) {
                sb.append("\n ***** Failed: " + this.errorCount + " tests!!! *****\n\n");
                sb.append((CharSequence)this.errorMessages);
            }
            return sb.toString();
        }
    }
}

