/*
 * Decompiled with CFR 0.152.
 */
package org.projog.test;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;

final class ProjogTestUtils {
    private static final String LINE_BREAK = "\n";
    static final String PROLOG_FILE_EXTENSION = ".pl";
    static final String TEXT_FILE_EXTENSION = ".txt";

    private ProjogTestUtils() {
    }

    public static boolean isPrologScript(File f) {
        String name = f.getName();
        int dotPos = name.lastIndexOf(46);
        if (dotPos > 0) {
            String extension = name.substring(dotPos).toLowerCase();
            return PROLOG_FILE_EXTENSION.equals(extension) || ".p".equals(extension) || ".pro".equals(extension) || ".prolog".equals(extension);
        }
        return false;
    }

    static String readText(File f) {
        return ProjogTestUtils.concatLines(ProjogTestUtils.readAllLines(f));
    }

    static String concatLines(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line);
            sb.append(LINE_BREAK);
        }
        return sb.toString();
    }

    private static List<String> readAllLines(File f) {
        try {
            return Files.readAllLines(f.toPath(), Charset.defaultCharset());
        }
        catch (Exception e) {
            throw new RuntimeException("could not read text file: " + f, e);
        }
    }

    static String toUnixLineEndings(String expected) {
        return expected.replace("\r\n", LINE_BREAK);
    }
}

