/*
 * Decompiled with CFR 0.152.
 */
package org.projog.test;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.projog.api.Projog;
import org.projog.api.QueryResult;
import org.projog.api.QueryStatement;
import org.projog.core.ProjogException;
import org.projog.core.event.ProjogListener;
import org.projog.core.event.SpyPoints;
import org.projog.core.term.Atom;
import org.projog.core.term.Term;
import org.projog.test.ProjogTestAnswer;
import org.projog.test.ProjogTestParser;
import org.projog.test.ProjogTestQuery;
import org.projog.test.ProjogTestRunnerConfig;
import org.projog.test.ProjogTestUtils;

final class ScriptRunner
implements ProjogListener {
    private static final boolean DEBUG = false;
    private final File redirectedOutputFile = new File(this.getClass().getName() + "_" + this.hashCode() + ".tmp");
    private final Map<Object, Integer> spypointSourceIds = new HashMap<Object, Integer>();
    private final File f;
    private final ProjogTestRunnerConfig config;
    private final Projog projog;
    private final ScriptResults testResults;

    ScriptRunner(ProjogTestRunnerConfig config, File f) {
        this.config = config;
        this.projog = config.createProjog();
        this.projog.addListener((ProjogListener)this);
        this.testResults = new ScriptResults(f);
        this.f = f;
    }

    ScriptResults checkScript() {
        long start = System.currentTimeMillis();
        try {
            this.consultFile(this.f);
            List<ProjogTestQuery> queries = ProjogTestParser.getQueries(this.f);
            this.checkQueries(queries);
        }
        catch (Exception e) {
            this.debug(e);
            StringBuilder msg = new StringBuilder(e.getMessage());
            Throwable cause = e;
            while ((cause = cause.getCause()) != null) {
                if (cause.getMessage() == null) continue;
                msg.append(' ').append(cause.getMessage());
            }
            this.testResults.addError("Error checking script: " + msg);
        }
        this.testResults.duration = System.currentTimeMillis() - start;
        return this.testResults;
    }

    private void consultFile(File script) {
        ScriptRunner.println("Checking script: " + script.getPath());
        this.projog.consultFile(script);
    }

    private void checkQueries(List<ProjogTestQuery> queries) {
        for (ProjogTestQuery query : queries) {
            try {
                this.checkQuery(query);
            }
            catch (Exception e) {
                this.debug(e);
                this.testResults.addError("Query: " + query.getPrologQuery() + " Error: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQuery(ProjogTestQuery query) {
        ScriptRunner.debug("QUERY: " + query.getPrologQuery());
        this.testResults.queryCount++;
        Iterator<ProjogTestAnswer> expectedAnswers = null;
        Term redirectedOutputFileHandle = null;
        try {
            redirectedOutputFileHandle = this.redirectOutput();
            QueryResult result = this.config.executeQuery(this.projog, query.getPrologQuery() + ".");
            expectedAnswers = query.getAnswers().iterator();
            boolean isExhausted = result.isExhausted();
            this.spypointSourceIds.clear();
            while (result.next()) {
                if (isExhausted) {
                    throw new RuntimeException("isExhausted() was true when there were still more answers available");
                }
                ScriptRunner.debug("ANSWERS:");
                if (!expectedAnswers.hasNext()) {
                    if (query.doesQuitBeforeFindingAllAnswers()) {
                        return;
                    }
                    throw new RuntimeException("More answers than expected");
                }
                ProjogTestAnswer correctAnswer = expectedAnswers.next();
                this.checkOutput(correctAnswer);
                this.checkAnswer(result, correctAnswer);
                isExhausted = result.isExhausted();
                this.closeOutput(redirectedOutputFileHandle);
                redirectedOutputFileHandle = this.redirectOutput();
                this.spypointSourceIds.clear();
            }
            if (expectedAnswers.hasNext()) {
                throw new RuntimeException("Less answers than expected");
            }
            if (query.doesQuitBeforeFindingAllAnswers()) {
                throw new RuntimeException("Found all answers before quit");
            }
            if (isExhausted && query.isContinuesUntilFails()) {
                throw new RuntimeException("Did not have to fail before determining there were no more answers");
            }
            if (!isExhausted && query.doesNotContinueUntilFails() && !this.config.doIgnoreFailedRetries()) {
                throw new RuntimeException("Had to fail to determine there were no more answers");
            }
            if (query.isContinuesUntilFails()) {
                this.checkOutput(query.getExpectedOutput());
            }
            if (query.getExpectedExceptionMessage() != null) {
                throw new RuntimeException("Query did not produce the expected error: " + query.getExpectedExceptionMessage());
            }
        }
        catch (ProjogException pe) {
            this.debug((Exception)((Object)pe));
            String actual = pe.getMessage();
            String expected = query.getExpectedExceptionMessage();
            if (!actual.equals(expected)) {
                throw new RuntimeException("Expected: >" + expected + "< but got: >" + actual + "<", pe);
            }
            if (expectedAnswers != null && expectedAnswers.hasNext()) {
                throw new RuntimeException("Less answers than expected", pe);
            }
        }
        finally {
            this.closeOutput(redirectedOutputFileHandle);
        }
    }

    private Term redirectOutput() {
        this.redirectedOutputFile.delete();
        QueryStatement openStmt = this.projog.createStatement("open('" + this.redirectedOutputFile.getName() + "',write,Z).");
        QueryResult openResult = openStmt.executeQuery();
        if (!openResult.next()) {
            throw new IllegalStateException();
        }
        Term redirectedOutputFileHandle = openResult.getTerm("Z");
        QueryStatement setOutputStmt = this.projog.createStatement("set_output(Z).");
        setOutputStmt.setTerm("Z", redirectedOutputFileHandle);
        QueryResult setOutputResult = setOutputStmt.executeQuery();
        if (!setOutputResult.next()) {
            throw new IllegalStateException();
        }
        return redirectedOutputFileHandle;
    }

    private void checkOutput(ProjogTestAnswer answer) {
        this.checkOutput(answer.getExpectedOutput());
    }

    private void checkOutput(String expected) {
        byte[] redirectedOutputFileContents = ScriptRunner.readAllBytes(this.redirectedOutputFile);
        String actual = new String(redirectedOutputFileContents);
        if (!ScriptRunner.equalExcludingLineTerminators(expected, actual)) {
            throw new RuntimeException("Expected: >\n" + expected + "\n< but got: >\n" + actual + "\n<");
        }
    }

    public static byte[] readAllBytes(File f) {
        try {
            return Files.readAllBytes(f.toPath());
        }
        catch (Exception e) {
            throw new RuntimeException("could not read file: " + f, e);
        }
    }

    private static boolean equalExcludingLineTerminators(String expected, String actual) {
        return ProjogTestUtils.toUnixLineEndings(expected).equals(ProjogTestUtils.toUnixLineEndings(actual));
    }

    private void closeOutput(Term redirectedOutputFileHandle) {
        QueryStatement closeStmt = this.projog.createStatement("close(Z).");
        closeStmt.setTerm("Z", redirectedOutputFileHandle);
        QueryResult closeResult = closeStmt.executeQuery();
        if (!closeResult.next()) {
            throw new IllegalStateException();
        }
        this.redirectedOutputFile.delete();
    }

    private void checkAnswer(QueryResult result, ProjogTestAnswer correctAnswer) {
        Set variableIds = result.getVariableIds();
        if (variableIds.size() != correctAnswer.getAssignmentsCount()) {
            throw new RuntimeException("Different number of variables than expected. Actual: " + variableIds + " Expected: " + correctAnswer.getAssignments());
        }
        for (String variableId : variableIds) {
            Term variable = result.getTerm(variableId);
            String actualTerm = this.projog.formatTerm(variable);
            String expectedTerm = correctAnswer.getAssignedValue(variableId);
            if (expectedTerm == null) {
                throw new RuntimeException(variableId + " (" + variable + ") was not expected to be assigned to anything but was to: " + actualTerm + " " + correctAnswer.getAssignments());
            }
            if ("UNINSTANTIATED VARIABLE".equals(expectedTerm)) {
                if (variable.getType().isVariable()) continue;
                throw new RuntimeException(variableId + " (" + variable + ") assigned to: " + actualTerm + " of type: " + variable.getType() + " but expected: " + expectedTerm + " " + correctAnswer.getAssignments());
            }
            if (actualTerm.equals(expectedTerm)) continue;
            throw new RuntimeException(variableId + " (" + variable + ") assigned to: " + actualTerm + " not: " + expectedTerm + " " + correctAnswer.getAssignments());
        }
    }

    public void onCall(SpyPoints.SpyPointEvent event) {
        this.update("CALL", event);
    }

    public void onRedo(SpyPoints.SpyPointEvent event) {
        this.update("REDO", event);
    }

    public void onExit(SpyPoints.SpyPointExitEvent event) {
        this.update("EXIT", (SpyPoints.SpyPointEvent)event);
    }

    public void onFail(SpyPoints.SpyPointEvent event) {
        this.update("FAIL", event);
    }

    public void onWarn(String message) {
        ScriptRunner.println(message);
    }

    public void onInfo(String message) {
        ScriptRunner.println(message);
    }

    private void update(String level, SpyPoints.SpyPointEvent event) {
        String message = this.generateLogMessageForEvent(level, event);
        this.writeLogMessage(message);
    }

    private String generateLogMessageForEvent(String level, SpyPoints.SpyPointEvent event) {
        String actualSourceId = Integer.toString(event.getSourceId());
        Integer i = this.spypointSourceIds.get(actualSourceId);
        if (i == null) {
            i = this.spypointSourceIds.size() + 1;
            this.spypointSourceIds.put(actualSourceId, i);
        }
        return "[" + i + "] " + level + " " + event.toString();
    }

    private void writeLogMessage(String message) {
        QueryStatement openStmt = this.projog.createStatement("write(Message), nl.");
        openStmt.setTerm("Message", (Term)new Atom(message));
        QueryResult openResult = openStmt.executeQuery();
        if (!openResult.next()) {
            throw new IllegalStateException();
        }
    }

    private static void debug(String s) {
    }

    private void debug(Exception e) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    public static class ScriptResults
    implements Comparable<ScriptResults> {
        private final File f;
        private final List<String> errorMessages = new ArrayList<String>();
        private int queryCount;
        private int errorCount;
        private long duration;

        private ScriptResults(File f) {
            this.f = f;
        }

        File getFile() {
            return this.f;
        }

        private void addError(String errorDescription) {
            this.errorMessages.add(errorDescription);
        }

        int getQueryCount() {
            return this.queryCount;
        }

        int getErrorCount() {
            return this.errorMessages.size();
        }

        boolean hasFailures() {
            return this.errorCount != 0;
        }

        List<String> getErrorMessages() {
            return Collections.unmodifiableList(this.errorMessages);
        }

        long getDuration() {
            return this.duration;
        }

        @Override
        public int compareTo(ScriptResults o) {
            return this.f.compareTo(o.f);
        }
    }
}

