/*
 * Decompiled with CFR 0.152.
 */
package org.projog.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class UpdateLegacyTests {
    public static void main(String[] args) throws IOException {
        UpdateLegacyTests.x("../projog/src/main/java");
        UpdateLegacyTests.x("../projog/src/test/prolog");
    }

    public static void x(String root) throws IOException {
        Files.walkFileTree(new File(root).toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                boolean isJava = path.getFileName().toString().endsWith(".java");
                boolean isProlog = path.getFileName().toString().endsWith(".pl");
                if (isJava || isProlog) {
                    System.out.println(path.getFileName());
                    List<String> input = Files.readAllLines(path);
                    ArrayList<String> output = new ArrayList<String>();
                    boolean inTest = isProlog;
                    boolean inAnswer = false;
                    for (String line : input) {
                        if (inTest) {
                            String[] answer;
                            if ("*/".equals(line.trim())) {
                                if (!isJava) {
                                    throw new RuntimeException(line);
                                }
                                output.add("*/");
                                inTest = false;
                                continue;
                            }
                            if (line.trim().startsWith("%QUERY")) {
                                output.add("%?-" + line.trim().substring(line.trim().indexOf(32)));
                                continue;
                            }
                            if (line.trim().startsWith("%FALSE")) {
                                output.add("%FAIL" + line.trim().substring(line.trim().indexOf(32)));
                                continue;
                            }
                            if (line.trim().equals("%ANSWER/")) {
                                output.add("%YES");
                                continue;
                            }
                            if (line.trim().equals("%ANSWER")) {
                                inAnswer = !inAnswer;
                                continue;
                            }
                            if (line.trim().startsWith("%ANSWER")) {
                                answer = UpdateLegacyTests.split(line);
                                output.add("% " + answer[0].trim() + "=" + answer[1].trim());
                                continue;
                            }
                            if (inAnswer && line.trim().startsWith("%")) {
                                answer = UpdateLegacyTests.split(line);
                                output.add("% " + answer[0].trim() + "=" + answer[1].trim());
                                continue;
                            }
                            if (line.startsWith(" ")) {
                                line = line.substring(1);
                            }
                            output.add(line);
                            continue;
                        }
                        if ("/* TEST".equals(line.trim())) {
                            if (!isJava) {
                                throw new RuntimeException(line);
                            }
                            output.add("/* TEST");
                            inTest = true;
                            continue;
                        }
                        output.add(line);
                    }
                    if (!input.equals(output)) {
                        // empty if block
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        System.out.println("FINISHED");
    }

    private static String[] split(String s) {
        String x = s.trim().substring(s.trim().indexOf(32));
        int p = x.indexOf(61);
        if (p == -1) {
            throw new RuntimeException(s);
        }
        return new String[]{x.substring(0, p).trim(), x.substring(p + 1).trim()};
    }
}

