/*
 * Decompiled with CFR 0.152.
 */
package prompto.reader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import prompto.error.ReadWriteError;
import prompto.intrinsic.PromptoDict;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoList;

public abstract class CSVReader {
    public static PromptoList<PromptoDocument<String, Object>> read(String data, PromptoDict<String, String> columns, Character separator, Character encloser) throws IOException {
        try (StringReader reader = data == null ? null : new StringReader(data);){
            PromptoList<PromptoDocument<String, Object>> promptoList = CSVReader.read(reader, columns, separator, encloser);
            return promptoList;
        }
    }

    public static PromptoList<PromptoDocument<String, Object>> read(Reader buffered, PromptoDict<String, String> columns, Character separator, Character encloser) {
        PromptoList list = new PromptoList(false);
        CSVIterable iter = CSVReader.iterator(buffered, columns, separator, encloser);
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static CSVIterable iterator(String data, PromptoDict<String, String> columns, Character separator, Character encloser) throws IOException {
        StringReader reader = data == null ? null : new StringReader(data);
        return CSVReader.iterator(reader, columns, separator, encloser);
    }

    public static CSVIterable iterator(final Reader _reader, final PromptoDict<String, String> columns, Character separator, Character encloser) {
        final char sep = separator == null ? (char)',' : (char)separator.charValue();
        final char quote = encloser == null ? (char)'\"' : (char)encloser.charValue();
        return new CSVIterable(){
            Reader reader;
            ArrayList<String> headers;
            Integer peekedChar;
            int nextChar;
            {
                this.reader = _reader;
                this.headers = null;
                this.peekedChar = null;
                this.nextChar = 0;
            }

            @Override
            public Iterator<PromptoDocument<String, Object>> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                if (this.nextChar == 0) {
                    this.fetchChar(true);
                }
                if (this.headers == null) {
                    this.parseHeaders((PromptoDict<String, String>)columns);
                }
                return this.nextChar > 0;
            }

            private void fetchChar() {
                this.fetchChar(false);
            }

            private void fetchChar(boolean eatNewLine) {
                if (this.reader == null) {
                    this.nextChar = -1;
                } else if (this.peekedChar != null) {
                    int c = this.peekedChar;
                    this.peekedChar = null;
                    this.nextChar = c;
                } else {
                    try {
                        int c = this.reader.read();
                        if (c == 13) {
                            this.fetchChar(eatNewLine);
                        } else if (eatNewLine && c == 10) {
                            this.fetchChar(eatNewLine);
                        } else {
                            this.nextChar = c;
                        }
                    }
                    catch (IOException e) {
                        throw new ReadWriteError(e.getMessage());
                    }
                }
            }

            private int peekChar() {
                if (this.peekedChar == null) {
                    int oldChar = this.nextChar;
                    this.fetchChar();
                    this.peekedChar = this.nextChar;
                    this.nextChar = oldChar;
                }
                return this.peekedChar;
            }

            private void parseHeaders(PromptoDict<String, String> columns2) {
                this.headers = this.parseLine();
                if (columns2 != null) {
                    for (int i = 0; i < this.headers.size(); ++i) {
                        String header = this.headers.get(i);
                        String value = (String)columns2.get((Object)header);
                        if (value == null) continue;
                        this.headers.set(i, value.toString());
                    }
                }
            }

            private ArrayList<String> parseLine() {
                ArrayList<String> list = new ArrayList<String>();
                while (this.parseValue(list)) {
                }
                if (this.nextChar == 10) {
                    this.fetchChar();
                }
                return list;
            }

            private boolean parseValue(ArrayList<String> list) {
                if (this.nextChar == sep) {
                    this.parseEmptyValue(list);
                } else if (this.nextChar == quote) {
                    this.parseQuotedValue(list);
                } else {
                    this.parseUnquotedValue(list);
                }
                return this.nextChar != -1 && this.nextChar != 10;
            }

            private void parseEmptyValue(ArrayList<String> list) {
                list.add(null);
                this.fetchChar();
            }

            private void parseQuotedValue(ArrayList<String> list) {
                this.fetchChar();
                this.parseValue(quote, list);
                while (this.nextChar != sep && this.nextChar != -1 && this.nextChar != 10) {
                    this.fetchChar();
                }
                if (this.nextChar == sep) {
                    this.fetchChar();
                }
            }

            private void parseUnquotedValue(ArrayList<String> list) {
                this.parseValue(sep, list);
            }

            private void parseValue(char endChar, ArrayList<String> list) {
                StringBuilder sb = new StringBuilder();
                boolean exit = false;
                while (!(exit = this.nextChar == -1 ? this.handleEOF(sb, endChar, list) : (this.nextChar == 10 ? this.handleNewLine(sb, endChar, list) : (this.nextChar == endChar ? this.handleEndChar(sb, endChar, list) : (this.nextChar == 92 ? this.handleEscape(sb, endChar, list) : this.handleOtherChar(sb, endChar, list)))))) {
                }
                if (sb.length() > 0) {
                    list.add(sb.toString());
                }
            }

            private boolean handleOtherChar(StringBuilder sb, char endChar, ArrayList<String> list) {
                sb.append((char)this.nextChar);
                this.fetchChar();
                return false;
            }

            private boolean handleEscape(StringBuilder sb, char endChar, ArrayList<String> list) {
                if (this.peekChar() != -1) {
                    sb.append((char)this.peekChar());
                    this.fetchChar();
                }
                this.fetchChar();
                return false;
            }

            private boolean handleEOF(StringBuilder sb, char endChar, ArrayList<String> list) {
                return true;
            }

            private boolean handleEndChar(StringBuilder sb, char endChar, ArrayList<String> list) {
                if (endChar == '\"' && this.peekChar() == endChar) {
                    sb.append((char)this.nextChar);
                    this.fetchChar();
                    this.fetchChar();
                    return false;
                }
                this.fetchChar();
                return true;
            }

            private boolean handleNewLine(StringBuilder sb, char endChar, ArrayList<String> list) {
                if (endChar == '\"') {
                    sb.append((char)this.nextChar);
                    this.fetchChar();
                    return false;
                }
                return true;
            }

            @Override
            public PromptoDocument<String, Object> next() {
                if (!this.hasNext()) {
                    return null;
                }
                ArrayList<String> values = this.parseLine();
                PromptoDocument doc = new PromptoDocument();
                for (int i = 0; i < this.headers.size(); ++i) {
                    if (i < values.size()) {
                        doc.put((Object)this.headers.get(i), (Object)values.get(i));
                        continue;
                    }
                    doc.put((Object)this.headers.get(i), null);
                }
                return doc;
            }
        };
    }

    static interface CSVIterable
    extends Iterable<PromptoDocument<String, Object>>,
    Iterator<PromptoDocument<String, Object>> {
    }
}

