/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.interpreter.util.TriFunction;

public final class Fields {
    private Fields() {
    }

    public static Field<Object> applyWithSingleParam(UnaryOperator<Object> fun, int[] fields, Object a) {
        return Fields.apply((T t, Object[] p) -> fun.apply(p[0]), false, fields, null, a);
    }

    public static Field<Object> apply(BinaryOperator<Object> fun, int[] fields, Object a, Object b) {
        return Fields.apply((T t, Object[] p) -> fun.apply(p[0], p[1]), false, fields, null, a, b);
    }

    public static <R> Field<R> apply(TriFunction<Object, Object, Object, R> fun, int[] fields, Object a, Object b, Object c) {
        return Fields.apply((T t, Object[] p) -> fun.apply(p[0], p[1], p[2]), false, fields, null, a, b, c);
    }

    public static <R> Field<R> apply(Function<Object[], R> fun, int[] fieldIndexes, Object ... args) {
        return Fields.apply(fun, false, fieldIndexes, null, args);
    }

    public static <R> Field<R> apply(Function<Object[], R> fun, boolean fieldTarget, int[] fieldIndexes, Object target, Object ... args) {
        return Fields.apply((T t, Object[] p) -> fun.apply((Object[])p), fieldTarget, fieldIndexes, target, args);
    }

    public static <T, R> Field<R> apply(BiFunction<T, Object[], R> fun, boolean fieldTarget, int[] fieldIndices, T target, Object ... args) {
        if (!fieldTarget && fieldIndices.length == 0) {
            throw new IllegalArgumentException("To use this field application at least one of the parameters must be a field.");
        }
        Field refField = (Field)(fieldTarget ? target : args[fieldIndices[0]]);
        return refField.map(id -> fun.apply(Fields.targetFor(fieldTarget, target, id), Fields.argumentsFor(args, fieldIndices, id)));
    }

    private static <T> T targetFor(boolean fieldTarget, T target, DeviceUID id) {
        return fieldTarget ? ((Field)target).get(id) : target;
    }

    private static Object[] argumentsFor(Object[] args, int[] fieldIndices, DeviceUID id) {
        Object[] actualArgs = Arrays.copyOf(args, args.length);
        for (int i : fieldIndices) {
            Object arg = ((Field)actualArgs[i]).get(id);
            if (arg == null) {
                throw new IllegalStateException("Field " + actualArgs[i] + " is not aligned with " + args[fieldIndices[0]] + " (missing " + id + ")");
            }
            actualArgs[i] = arg;
        }
        return actualArgs;
    }
}

