/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.util;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.Fields;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.TriFunction;
import org.protelis.lang.interpreter.util.WithBytecode;

public enum Op3 implements WithBytecode
{
    MUX(Bytecode.TERNARY_MUX, "mux", Op3::mux);

    private static final Map<String, Op3> MAP;
    private final Bytecode bytecode;
    private final TernaryOperation fun;
    private final String opName;

    private Op3(Bytecode bytecode, String name, TernaryOperation function) {
        this.fun = function;
        this.opName = name;
        this.bytecode = bytecode;
    }

    @Override
    public Bytecode getBytecode() {
        return this.bytecode;
    }

    public Object run(Object a, Object b, Object c) {
        Object[] args = new Object[]{a, b, c};
        Optional<Object> idx = Optional.empty();
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Field)) continue;
            if (!idx.isPresent()) {
                idx = Optional.of(new TIntArrayList(3));
            }
            ((TIntList)idx.get()).add(i);
        }
        if (idx.isPresent()) {
            return Fields.apply(this.fun, ((TIntList)idx.get()).toArray(), a, b, c);
        }
        return this.fun.apply(a, b, c);
    }

    public String toString() {
        return this.opName;
    }

    public static Op3 getOp(String name) {
        Op3 op = MAP.get(name);
        if (op == null) {
            op = Arrays.stream(Op3.values()).filter(o -> o.opName.equals(name)).findFirst().get();
            MAP.put(name, op);
        }
        return op;
    }

    private static Object mux(Object a, Object b, Object c) {
        if (a instanceof Boolean) {
            if (((Boolean)a).booleanValue()) {
                return b;
            }
            return c;
        }
        if (a != null) {
            return b;
        }
        return c;
    }

    static {
        MAP = new ConcurrentHashMap<String, Op3>();
    }

    private static interface TernaryOperation
    extends TriFunction<Object, Object, Object, Object>,
    Serializable {
    }
}

