/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.datatype.Tuple;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.Constant;
import org.protelis.lang.interpreter.impl.FunctionCall;
import org.protelis.lang.interpreter.util.JavaInteroperabilityUtils;
import org.protelis.vm.ExecutionContext;

public final class ArrayTupleImpl
implements Tuple {
    private static final Comparator<Object> COMPARE_TO = (a, b) -> {
        if (a instanceof Comparable && b instanceof Comparable) {
            try {
                return ((Comparable)a).compareTo(b);
            }
            catch (RuntimeException e) {
                return ArrayTupleImpl.compareLexicographically(a, b);
            }
        }
        return ArrayTupleImpl.compareLexicographically(a, b);
    };
    private static final long serialVersionUID = 5453783531251313649L;
    private final Object[] arrayContents;
    private int hash;
    private String string;

    public ArrayTupleImpl(Object ... base) {
        this(base, true);
    }

    public ArrayTupleImpl(Object value, int length) {
        this.arrayContents = new Object[length];
        for (int i = 0; i < length; ++i) {
            this.arrayContents[i] = value;
        }
    }

    private ArrayTupleImpl(Object[] base, boolean copy) {
        this.arrayContents = copy ? Arrays.copyOf(base, base.length) : base;
    }

    @Override
    public Tuple append(Object element) {
        Object[] copy = Arrays.copyOf(this.arrayContents, this.arrayContents.length + 1);
        copy[this.arrayContents.length] = element;
        return new ArrayTupleImpl(copy, false);
    }

    @Override
    public int compareTo(Tuple o) {
        int res = 0;
        int otherSize = o.size();
        for (int i = 0; res == 0 && i < this.arrayContents.length && i < otherSize; ++i) {
            Object o1 = this.arrayContents[i];
            Object o2 = o.get(i);
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                try {
                    res = ((Comparable)o1).compareTo(o2);
                }
                catch (ClassCastException ex) {
                    res = o1.toString().compareTo(o2.toString());
                }
                continue;
            }
            return o1.toString().compareTo(o2.toString());
        }
        if (res == 0 && this.arrayContents.length != otherSize) {
            if (this.arrayContents.length > otherSize) {
                return 1;
            }
            return -1;
        }
        return res;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexof(element) >= 0;
    }

    @Override
    public boolean containsAll(Iterable<?> element) {
        for (Object obj : element) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        Tuple t;
        if (o instanceof ArrayTupleImpl) {
            return Arrays.equals(this.arrayContents, ((ArrayTupleImpl)o).arrayContents);
        }
        if (o instanceof Tuple && (t = (Tuple)o).size() == this.arrayContents.length) {
            for (int i = 0; i < this.arrayContents.length; ++i) {
                if (this.arrayContents[i].equals(t.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Tuple filter(ExecutionContext ctx, FunctionDefinition fun) {
        Objects.requireNonNull(fun);
        if (fun.getParameterCount() == 1 || fun.invokerShouldInitializeIt()) {
            ArrayList<Object> result = new ArrayList<Object>(this.arrayContents.length);
            for (int i = 0; i < this.arrayContents.length; ++i) {
                FunctionCall fc = new FunctionCall(JavaInteroperabilityUtils.METADATA, fun, ArrayTupleImpl.elementAsArguments(this.arrayContents[i]));
                Object outcome = ctx.runInNewStackFrame(i, fc::eval);
                if (outcome instanceof Boolean) {
                    if (!((Boolean)outcome).booleanValue()) continue;
                    result.add(this.arrayContents[i]);
                    continue;
                }
                throw new IllegalArgumentException("Illegal filtering result: '" + outcome + ": " + outcome.getClass().getName() + "' (must be a boolean).");
            }
            return result.size() == this.arrayContents.length ? this : new ArrayTupleImpl(result.toArray(), false);
        }
        throw new IllegalArgumentException("Filtering function must take one parameter.");
    }

    @Override
    public Tuple filter(Predicate<Object> fun) {
        Objects.requireNonNull(fun);
        return new ArrayTupleImpl(Arrays.stream(this.arrayContents).filter(fun).toArray(), false);
    }

    @Override
    public Tuple flatMap(Function<Object, Tuple> fun) {
        Stream flatMapped = Arrays.stream(this.arrayContents).flatMap((? super T e) -> Arrays.stream(((Tuple)fun.apply(e)).toArray()));
        Object[] mappedArray = flatMapped.toArray();
        return new ArrayTupleImpl(mappedArray, false);
    }

    @Override
    public Object fold(ExecutionContext ctx, Object defVal, FunctionDefinition fun) {
        Objects.requireNonNull(fun);
        if (fun.getParameterCount() == 2) {
            Object result = defVal;
            for (int i = 0; i < this.arrayContents.length; ++i) {
                result = this.runBinaryFunctionWithElement(ctx, fun, result, i);
            }
            return result;
        }
        throw new IllegalArgumentException("Reducing function must take two parameters.");
    }

    @Override
    public Object fold(Object initial, BinaryOperator<Object> fun) {
        return Arrays.stream(this.arrayContents).reduce(Objects.requireNonNull(initial), Objects.requireNonNull(fun));
    }

    public Object get(double i) {
        return this.get((int)i);
    }

    public Object get(Double i) {
        return this.get(i.intValue());
    }

    @Override
    public Object get(int i) {
        return this.arrayContents[i];
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Hashing.murmur3_32_fixed().newHasher().putObject((Object)this.arrayContents, (Funnel & Serializable)(array, dest) -> {
                for (Object it : array) {
                    dest.putInt(it.hashCode());
                }
            }).hash().asInt();
        }
        return this.hash;
    }

    @Override
    public Object head() {
        return this.get(0);
    }

    @Override
    public int indexof(Object element) {
        for (int i = 0; i < this.arrayContents.length; ++i) {
            if (!this.arrayContents[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Tuple insert(int i, Object element) {
        return new ArrayTupleImpl(ArrayUtils.insert((int)i, (Object[])this.arrayContents, (Object[])new Object[]{element}), false);
    }

    @Override
    public Tuple intersection(Tuple t) {
        LinkedHashSet l1 = Sets.newLinkedHashSet((Iterable)this);
        LinkedHashSet l2 = Sets.newLinkedHashSet((Iterable)t);
        return new ArrayTupleImpl(Sets.intersection((Set)l1, (Set)l2).toArray(), false);
    }

    @Override
    public boolean isEmpty() {
        return this.arrayContents.length == 0;
    }

    @Override
    @Nonnull
    public Iterator<Object> iterator() {
        return Iterators.forArray((Object[])this.arrayContents);
    }

    @Override
    public Tuple map(ExecutionContext ctx, FunctionDefinition fun) {
        if (fun.getParameterCount() == 1 || fun.invokerShouldInitializeIt()) {
            Object[] result = new Object[this.arrayContents.length];
            for (int i = 0; i < result.length; ++i) {
                FunctionCall fc = new FunctionCall(JavaInteroperabilityUtils.METADATA, fun, ArrayTupleImpl.elementAsArguments(this.arrayContents[i]));
                result[i] = ctx.runInNewStackFrame(i, fc::eval);
            }
            return new ArrayTupleImpl(result, false);
        }
        throw new IllegalArgumentException("Mapping function must take one parameter.");
    }

    @Override
    public Tuple map(Function<Object, Object> fun) {
        Objects.requireNonNull(fun);
        return DatatypeFactory.createTuple(Arrays.stream(this.arrayContents).map(fun).toArray());
    }

    @Override
    public Object max(Object def) {
        return Arrays.stream(this.arrayContents).max(COMPARE_TO).orElse(def);
    }

    @Override
    public Tuple mergeAfter(Tuple tuple) {
        if (tuple instanceof ArrayTupleImpl) {
            return new ArrayTupleImpl(ArrayUtils.addAll((Object[])this.arrayContents, (Object[])((ArrayTupleImpl)tuple).arrayContents), false);
        }
        Object[] copy = new Object[this.arrayContents.length + tuple.size()];
        System.arraycopy(this.arrayContents, 0, copy, 0, this.arrayContents.length);
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = tuple.get(i - this.arrayContents.length);
        }
        return new ArrayTupleImpl(copy, false);
    }

    @Override
    public Object min(Object def) {
        return Arrays.stream(this.arrayContents).min(COMPARE_TO).orElse(def);
    }

    @Override
    public Tuple prepend(Object element) {
        return this.insert(0, element);
    }

    @Override
    public Object reduce(ExecutionContext ctx, Object defVal, FunctionDefinition fun) {
        Objects.requireNonNull(fun);
        if (fun.getParameterCount() == 2) {
            if (this.arrayContents.length == 0) {
                return defVal;
            }
            Object result = this.arrayContents[0];
            for (int i = 1; i < this.arrayContents.length; ++i) {
                result = this.runBinaryFunctionWithElement(ctx, fun, result, i);
            }
            return result;
        }
        throw new IllegalArgumentException("Reducing function must take two parameters.");
    }

    private Object runBinaryFunctionWithElement(ExecutionContext ctx, FunctionDefinition fun, Object param, int elementPosition) {
        ImmutableList arguments = ImmutableList.of(new Constant<Object>(JavaInteroperabilityUtils.METADATA, param), new Constant<Object>(JavaInteroperabilityUtils.METADATA, this.arrayContents[elementPosition]));
        FunctionCall call = new FunctionCall(JavaInteroperabilityUtils.METADATA, fun, (List<ProtelisAST<?>>)arguments);
        return ctx.runInNewStackFrame(elementPosition, call::eval);
    }

    @Override
    public Object reduce(Object defVal, BinaryOperator<Object> fun) {
        return Arrays.stream(this.arrayContents).reduce(Objects.requireNonNull(fun)).orElse(Objects.requireNonNull(defVal));
    }

    @Override
    public Tuple set(int i, Object element) {
        Object[] copy = Arrays.copyOf(this.arrayContents, this.arrayContents.length);
        copy[i] = element;
        return new ArrayTupleImpl(copy, false);
    }

    @Override
    public int size() {
        return this.arrayContents.length;
    }

    @Override
    public Tuple sort() {
        Object[] newArray = Arrays.copyOf(this.arrayContents, this.arrayContents.length);
        Arrays.sort(newArray, COMPARE_TO);
        return DatatypeFactory.createTuple(newArray);
    }

    @Override
    public Tuple subtract(Tuple t) {
        LinkedHashSet l = Sets.newLinkedHashSet((Iterable)this);
        for (Object o : t) {
            l.remove(o);
        }
        return DatatypeFactory.createTuple(l.toArray());
    }

    @Override
    public ArrayTupleImpl subTuple(int i, int j) {
        return new ArrayTupleImpl(ArrayUtils.subarray((Object[])this.arrayContents, (int)i, (int)j), false);
    }

    @Override
    public ArrayTupleImpl subTupleEnd(int i) {
        return this.subTuple(i, this.arrayContents.length);
    }

    @Override
    public ArrayTupleImpl subTupleStart(int i) {
        return this.subTuple(0, i);
    }

    @Override
    public Tuple tail() {
        return this.subTupleEnd(1);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.arrayContents.clone();
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (Object o : this.arrayContents) {
                boolean notNumber = !(o instanceof Number) && !(o instanceof Tuple);
                boolean isString = o instanceof String;
                if (isString) {
                    sb.append('\"');
                } else if (notNumber) {
                    sb.append('\'');
                }
                sb.append(o.toString());
                if (isString) {
                    sb.append('\"');
                } else if (notNumber) {
                    sb.append('\'');
                }
                sb.append(", ");
            }
            if (this.arrayContents.length > 0) {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(']');
            this.string = sb.toString();
        }
        return this.string;
    }

    @Override
    public ArrayTupleImpl union(Tuple t) {
        return new ArrayTupleImpl(Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)this, (Iterable)t)).toArray(), false);
    }

    @Override
    public Tuple unwrap(int i) {
        return DatatypeFactory.createTuple(Arrays.stream(this.arrayContents).map((? super T o) -> {
            if (o instanceof Tuple) {
                return ((Tuple)o).get(i);
            }
            return o;
        }).toArray());
    }

    @Override
    public Tuple zip(Tuple other) {
        Object[] result = new Object[Math.min(this.size(), other.size())];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ArrayTupleImpl(new Object[]{this.get(i), other.get(i)}, false);
        }
        return new ArrayTupleImpl(result, false);
    }

    private static int compareLexicographically(Object a, Object b) {
        return a.toString().compareTo(b.toString());
    }

    private static List<ProtelisAST<?>> elementAsArguments(Object element) {
        return ImmutableList.of(new Constant<Object>(JavaInteroperabilityUtils.METADATA, element));
    }
}

