/*
 * Decompiled with CFR 0.152.
 */
package org.protelis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.datatype.Option;
import org.protelis.lang.datatype.Tuple;
import org.protelis.lang.interpreter.util.JavaInteroperabilityUtils;
import org.protelis.vm.ExecutionContext;

public final class Builtins {
    private static final String UNCHECKED = "unchecked";
    public static final ImmutableList<Integer> MINIMUM_PARSER_VERSION = ImmutableList.of((Object)10, (Object)0, (Object)0);
    public static final ImmutableList<Integer> MAXIMUM_PARSER_VERSION = ImmutableList.of((Object)10, (Object)0, (Object)1);

    private Builtins() {
    }

    public static boolean all(Field<Boolean> target) {
        return target.foldValuesIncludingLocal(Boolean::logicalAnd);
    }

    public static boolean allButSelf(Field<Boolean> target) {
        return target.foldValuesExcludingLocal(true, Boolean::logicalAnd);
    }

    public static boolean any(Field<Boolean> target) {
        return target.foldValuesIncludingLocal(Boolean::logicalOr);
    }

    public static boolean anyButSelf(Field<Boolean> target) {
        return target.foldValuesExcludingLocal(false, Boolean::logicalOr);
    }

    private static <X, Y, R> R byReflection(String name, X a, Y b) {
        try {
            return (R)a.getClass().getMethod(name, b.getClass()).invoke(a, b);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to perform operation a." + name + "(b) where a=" + a + " and b=" + b + ", a of type " + a.getClass() + ", b of type " + b.getClass(), e);
        }
    }

    private static <I, O> Function<I, O> conversionFunction(Class<I> in, Class<O> out) {
        block3: {
            block2: {
                if (in.equals(out)) break block2;
                if (!out.isAssignableFrom(in)) break block3;
            }
            return out::cast;
        }
        throw new IllegalStateException("Impossible conversion between " + in + " and " + out);
    }

    private static <I, O> O convert(Class<O> out, I in) {
        return Builtins.conversionFunction(in.getClass(), out).apply(in);
    }

    public static <T> Map<DeviceUID, T> fieldToMap(Field<T> field) {
        return field.toMap();
    }

    public static <T> T foldHood(@Nonnull ExecutionContext context, @Nonnull T base, @Nonnull Field<T> target, @Nonnull FunctionDefinition reductionFunction) {
        Class<T> expectedType;
        Class<T> fieldType;
        Class<T> defaultType = Objects.requireNonNull(base).getClass();
        if (defaultType.isAssignableFrom(fieldType = Objects.requireNonNull(target).getExpectedType())) {
            expectedType = defaultType;
        } else if (fieldType.isAssignableFrom(defaultType)) {
            expectedType = fieldType;
        } else {
            throw new IllegalArgumentException("Default type " + defaultType.getName() + " and field expected type " + fieldType.getName() + " do not seem to be compatible");
        }
        return target.foldValuesExcludingLocal(base, Builtins.reductionFunction(context, expectedType, target, reductionFunction));
    }

    public static <T> T foldHoodPlusSelf(@Nonnull ExecutionContext context, @Nonnull Field<T> target, @Nonnull FunctionDefinition reductionFunction) {
        return target.foldValuesIncludingLocal(Builtins.reductionFunction(context, target.getExpectedType(), target, reductionFunction));
    }

    public static <T extends Comparable<T>> T foldMax(Field<T> target) {
        return (T)((Comparable)target.foldValuesIncludingLocal(Builtins::max));
    }

    public static <T extends Comparable<T>> T foldMax(T base, Field<T> target) {
        return (T)((Comparable)target.foldValuesExcludingLocal(base, Builtins::max));
    }

    public static double foldMean(Field<? extends Number> target) {
        return Builtins.foldSum(target).doubleValue() / (double)(target.size() + 1);
    }

    public static <T extends Comparable<T>> T foldMin(Field<T> target) {
        return (T)((Comparable)target.foldValuesIncludingLocal(Builtins::min));
    }

    public static <T extends Comparable<T>> T foldMin(T base, Field<T> target) {
        return (T)((Comparable)target.foldValuesExcludingLocal(base, Builtins::min));
    }

    public static <T> T foldSum(Field<T> target) {
        return target.foldValuesIncludingLocal(Builtins::sum);
    }

    public static <T> T foldSum(T base, Field<T> target) {
        return target.foldValuesExcludingLocal(base, Builtins::sum);
    }

    public static <T> T foldUnion(Field<T> target) {
        return target.foldValuesIncludingLocal(Builtins::union);
    }

    public static <T> T foldUnion(T base, Field<T> target) {
        return target.foldValuesExcludingLocal(base, Builtins::union);
    }

    public static <T> T local(Field<T> target) {
        return target.getLocalValue();
    }

    private static <T extends Comparable<T>> T max(T a, T b) {
        return Builtins.selectComparable(a, b, c -> c > 0);
    }

    public static <T> Option<T> maybe(@Nullable T object) {
        return Option.of(object);
    }

    public static <T extends Comparable<T>> T min(T a, T b) {
        return Builtins.selectComparable(a, b, c -> c < 0);
    }

    private static <T extends Comparable<T>> T selectComparable(T a, T b, IntPredicate selector) {
        if (a.getClass() == b.getClass() || a.getClass().isAssignableFrom(b.getClass())) {
            return selector.test(a.compareTo(b)) ? a : b;
        }
        if (b.getClass().isAssignableFrom(a.getClass())) {
            return selector.test(b.compareTo(a)) ? b : a;
        }
        if (a instanceof Number && b instanceof Number) {
            return selector.test(Double.compare(((Number)((Object)a)).doubleValue(), ((Number)((Object)b)).doubleValue())) ? a : b;
        }
        throw new IllegalArgumentException("Tried to compare '" + a + ": " + a.getClass().getSimpleName() + "' with " + b + ": " + b.getClass().getSimpleName() + "', but such comparison of types was not possible.");
    }

    public static boolean none(Field<Boolean> target) {
        return !Builtins.any(target);
    }

    public static boolean noneButSelf(Field<Boolean> target) {
        return !Builtins.anyButSelf(target);
    }

    public static <T> Option<T> reduceHood(@Nonnull ExecutionContext context, @Nonnull Field<T> target, @Nonnull FunctionDefinition reductionFunction) {
        return target.reduceValues(Builtins.reductionFunction(context, target.getExpectedType(), target, reductionFunction));
    }

    public static <T> Option<T> optionally(@Nullable T object) {
        return Option.fromNullable(object);
    }

    public static <T extends Comparable<T>> Option<T> reduceMax(Field<T> target) {
        return target.reduceValues(Builtins::max);
    }

    public static Option<Double> reduceMean(Field<? extends Number> target) {
        return Builtins.reduceSum(target).map(it -> it.doubleValue() / (double)target.size());
    }

    public static <T extends Comparable<T>> Option<T> reduceMin(Field<T> target) {
        return target.reduceValues(Builtins::min);
    }

    public static <T> Option<T> reduceSum(Field<T> target) {
        return target.reduceValues(Builtins::sum);
    }

    public static <T> Option<T> reduceUnion(Field<T> target) {
        return target.reduceValues(Builtins::union);
    }

    @Nonnull
    private static <T> BinaryOperator<T> reductionFunction(@Nonnull ExecutionContext context, @Nonnull Class<? extends T> expectedType, @Nonnull Field<T> target, @Nonnull FunctionDefinition reductionFunction) {
        return (a, b) -> {
            Object reductionResult = JavaInteroperabilityUtils.runProtelisFunctionWithJavaArguments(context, reductionFunction, ImmutableList.of((Object)a, (Object)b));
            if (expectedType.isAssignableFrom(reductionResult.getClass())) {
                return expectedType.cast(reductionResult);
            }
            throw new IllegalStateException("Reduction operation over target field " + target + " with type " + target.getExpectedType() + " failed because the provided reduction function reduced " + a + " of type " + a.getClass().getName() + " and " + b + " of type " + b.getClass().getName() + " into " + reductionResult + " of type " + reductionResult.getClass().getName() + " which does not conform to expected type " + expectedType.getName());
        };
    }

    private static <X, Y, R> R run(Class<X> xClass, Object x, Class<Y> yClass, Object y, BiFunction<X, Y, R> fun) {
        return fun.apply(Builtins.convert(xClass, x), Builtins.convert(yClass, y));
    }

    private static <X, R> R run(Class<X> inClass, Object x, Object y, BiFunction<X, X, R> fun) {
        return Builtins.run(inClass, x, inClass, y, fun);
    }

    private static <X> X runBi(Class<X> inClass, Object x, Object y, BinaryOperator<X> fun) {
        return (X)Builtins.run(inClass, x, y, fun);
    }

    private static <T> T sum(T a, T b) {
        if (a instanceof CharSequence || b instanceof CharSequence) {
            return (T)(a.toString() + b.toString());
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            return (T)Builtins.runBi(BigDecimal.class, a, b, BigDecimal::add);
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            return (T)Builtins.runBi(BigInteger.class, a, b, BigInteger::add);
        }
        if (a instanceof Double || b instanceof Double) {
            return (T)Builtins.runBi(Double.class, a, b, Double::sum);
        }
        if (a instanceof Float || b instanceof Float) {
            return (T)Builtins.runBi(Float.class, a, b, Float::sum);
        }
        if (a instanceof Long || b instanceof Long) {
            return (T)Builtins.runBi(Long.class, a, b, Long::sum);
        }
        if (a instanceof Integer || b instanceof Integer || a instanceof Byte || b instanceof Byte || a instanceof Short || b instanceof Short) {
            return (T)Builtins.runBi(Integer.class, a, b, Integer::sum);
        }
        if (a instanceof Boolean && b instanceof Boolean) {
            return (T)Builtins.runBi(Boolean.class, a, b, Boolean::logicalAnd);
        }
        if (a instanceof Tuple && b instanceof Tuple) {
            return (T)Builtins.runBi(Tuple.class, a, b, Tuple::mergeAfter);
        }
        return (T)Builtins.byReflection("plus", a, b);
    }

    private static <T> T union(T a, T b) {
        if (a instanceof Tuple && b instanceof Tuple) {
            return (T)Builtins.runBi(Tuple.class, a, b, Tuple::union);
        }
        if (a instanceof Set && b instanceof Set) {
            return (T)Builtins.runBi(Set.class, a, b, Sets::union);
        }
        if (b instanceof Tuple) {
            return (T)Builtins.runBi(Tuple.class, DatatypeFactory.createTuple(a), b, Tuple::union);
        }
        if (a instanceof Tuple) {
            return (T)Builtins.runBi(Tuple.class, a, DatatypeFactory.createTuple(b), Tuple::union);
        }
        return (T)Builtins.byReflection("union", a, b);
    }
}

