/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang;

import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.inject.Injector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.StringInputStream;
import org.protelis.lang.ProtelisLoadingUtilities;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.datatype.JVMEntity;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AlignedMap;
import org.protelis.lang.interpreter.impl.All;
import org.protelis.lang.interpreter.impl.AssignmentOp;
import org.protelis.lang.interpreter.impl.BinaryOp;
import org.protelis.lang.interpreter.impl.ConditionalSideEffect;
import org.protelis.lang.interpreter.impl.Constant;
import org.protelis.lang.interpreter.impl.CreateTuple;
import org.protelis.lang.interpreter.impl.Env;
import org.protelis.lang.interpreter.impl.Eval;
import org.protelis.lang.interpreter.impl.FunctionCall;
import org.protelis.lang.interpreter.impl.GenericHoodCall;
import org.protelis.lang.interpreter.impl.HoodCall;
import org.protelis.lang.interpreter.impl.If;
import org.protelis.lang.interpreter.impl.Invoke;
import org.protelis.lang.interpreter.impl.JvmConstant;
import org.protelis.lang.interpreter.impl.NBRCall;
import org.protelis.lang.interpreter.impl.Self;
import org.protelis.lang.interpreter.impl.ShareCall;
import org.protelis.lang.interpreter.impl.TernaryOp;
import org.protelis.lang.interpreter.impl.UnaryOp;
import org.protelis.lang.interpreter.impl.Variable;
import org.protelis.lang.interpreter.util.HashingFunnel;
import org.protelis.lang.interpreter.util.HoodOp;
import org.protelis.lang.interpreter.util.Java8CompatibleFunnel;
import org.protelis.lang.interpreter.util.Reference;
import org.protelis.lang.loading.Metadata;
import org.protelis.parser.ProtelisStandaloneSetup;
import org.protelis.parser.protelis.Assignment;
import org.protelis.parser.protelis.Block;
import org.protelis.parser.protelis.BooleanVal;
import org.protelis.parser.protelis.Builtin;
import org.protelis.parser.protelis.BuiltinHoodOp;
import org.protelis.parser.protelis.Declaration;
import org.protelis.parser.protelis.DoubleVal;
import org.protelis.parser.protelis.Expression;
import org.protelis.parser.protelis.ExpressionList;
import org.protelis.parser.protelis.FunctionDef;
import org.protelis.parser.protelis.GenericHood;
import org.protelis.parser.protelis.IfWithoutElse;
import org.protelis.parser.protelis.InvocationArguments;
import org.protelis.parser.protelis.It;
import org.protelis.parser.protelis.Lambda;
import org.protelis.parser.protelis.LongLambda;
import org.protelis.parser.protelis.MethodCall;
import org.protelis.parser.protelis.Mux;
import org.protelis.parser.protelis.NBR;
import org.protelis.parser.protelis.OldLongLambda;
import org.protelis.parser.protelis.OldShortLambda;
import org.protelis.parser.protelis.ProtelisModule;
import org.protelis.parser.protelis.Rep;
import org.protelis.parser.protelis.RepInitialize;
import org.protelis.parser.protelis.Scalar;
import org.protelis.parser.protelis.Share;
import org.protelis.parser.protelis.ShareInitialize;
import org.protelis.parser.protelis.Statement;
import org.protelis.parser.protelis.StringVal;
import org.protelis.parser.protelis.TupleVal;
import org.protelis.parser.protelis.VarDef;
import org.protelis.parser.protelis.VarDefList;
import org.protelis.parser.protelis.VarUse;
import org.protelis.parser.protelis.Yield;
import org.protelis.vm.ProtelisProgram;
import org.protelis.vm.impl.SimpleProgramImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtelisLoader {
    private static final String HOOD_END = "Hood";
    private static final ThreadLocal<Cache<String, Resource>> LOADED_RESOURCES = ThreadLocal.withInitial(() -> CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build());
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtelisLoader.class);
    private static final String OPEN_J9_EMF_WORKED_AROUND = "Working around OpenJ9 + Eclipse EMF bug.See: https://bugs.eclipse.org/bugs/show_bug.cgi?id=549084and https://github.com/eclipse/openj9/issues/6370";
    private static final String PROTELIS_FILE_EXTENSION = "pt";
    private static final Pattern REGEX_PROTELIS_IMPORT = Pattern.compile("^\\s*import\\s+((?:\\w+:)*\\w+)\\s+", 8);
    private static final Pattern REGEX_PROTELIS_MODULE = Pattern.compile("(?:\\w+:)*\\w+");
    private static final LoadingCache<Resource, ProtelisProgram> FLYWEIGHT = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Resource, ProtelisProgram>(){

        @Nonnull
        public ProtelisProgram load(@Nonnull Resource resource) {
            Objects.requireNonNull(resource);
            if (!resource.getErrors().isEmpty()) {
                String moduleName = Optional.ofNullable(resource.getContents()).map(it -> (EObject)it.get(0)).map(it -> (ProtelisModule)it).map(ProtelisModule::getName).orElse("without declared module");
                StringBuilder sb = new StringBuilder("Program " + moduleName + " from resource " + resource.getURI() + " cannot be created because of the following errors:\n");
                boolean first = true;
                for (Resource.Diagnostic d : Lists.reverse(ProtelisLoader.recursivelyCollectErrors(resource))) {
                    if (first) {
                        sb.append("MOST LIKELY CAUSE ==> ");
                        first = false;
                    }
                    sb.append("Error");
                    if (d.getLocation() != null) {
                        String place = (String)Iterables.get((Iterable)Splitter.on((char)'#').split((CharSequence)d.getLocation()), (int)0);
                        sb.append(" in ");
                        sb.append(place);
                    }
                    try {
                        int line = d.getLine();
                        sb.append(", line ");
                        sb.append(line);
                    }
                    catch (UnsupportedOperationException line) {
                        // empty catch block
                    }
                    try {
                        int column = d.getColumn();
                        sb.append(", column ");
                        sb.append(column);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                    sb.append(": ");
                    sb.append(d.getMessage());
                    sb.append('\n');
                }
                throw new IllegalArgumentException(sb.toString());
            }
            ProtelisModule root = (ProtelisModule)resource.getContents().get(0);
            Objects.requireNonNull(Objects.requireNonNull(root).getProgram(), "The provided resource does not contain any main program, and can not be executed.");
            Diagnostician.INSTANCE.validate((EObject)root).getChildren().forEach(it -> LOGGER.warn("severity {}: {}", (Object)it.getSeverity(), (Object)it.getMessage()));
            return new SimpleProgramImpl(root, Dispatch.block(root.getProgram()));
        }
    });
    private static final ThreadLocal<XtextResourceSet> XTEXT = ThreadLocal.withInitial(() -> {
        Injector guiceInjector = new ProtelisStandaloneSetup().createInjectorAndDoEMFRegistration();
        XtextResourceSet xtext = (XtextResourceSet)guiceInjector.getInstance(XtextResourceSet.class);
        xtext.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        return xtext;
    });

    private ProtelisLoader() {
    }

    private static void loadResourcesRecursively(XtextResourceSet target, String programURI) throws IOException {
        ProtelisLoader.loadResourcesRecursively(target, programURI, new LinkedHashSet<String>());
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="False positive")
    private static void loadResourcesRecursively(XtextResourceSet target, String programURI, Set<String> alreadyInQueue) throws IOException {
        ResolvedResource resource = new ResolvedResource(programURI);
        if (LOADED_RESOURCES.get().getIfPresent((Object)programURI) == null && !alreadyInQueue.contains(programURI)) {
            alreadyInQueue.add(programURI);
            URI uri = ProtelisLoader.workAroundOpenJ9EMFBug(() -> URI.createURI((String)resource.realURI));
            if (resource.exists()) {
                try (InputStream is = resource.openStream();){
                    ProtelisLoader.loadStringResources(target, is, alreadyInQueue);
                }
                LOADED_RESOURCES.get().put((Object)programURI, (Object)ProtelisLoader.workAroundOpenJ9EMFBug(() -> target.getResource(uri, true)));
            } else {
                throw new IllegalStateException("expected resource " + resource + " was not found");
            }
        }
    }

    private static void loadStringResources(XtextResourceSet target, InputStream is, Set<String> alreadyInQueue) throws IOException {
        String ss = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        Matcher matcher = REGEX_PROTELIS_IMPORT.matcher(ss);
        while (matcher.find()) {
            int start = matcher.start(1);
            int end = matcher.end(1);
            String imp = ss.substring(start, end);
            String classpathResource = "classpath:/" + imp.replace(":", "/") + ".pt";
            ProtelisLoader.loadResourcesRecursively(target, classpathResource, alreadyInQueue);
        }
    }

    private static void loadStringResources(XtextResourceSet target, InputStream is) throws IOException {
        ProtelisLoader.loadStringResources(target, is, new LinkedHashSet<String>());
    }

    private static Metadata metadataFor(EObject origin) {
        ICompositeNode grammarElement = NodeModelUtils.getNode((EObject)origin);
        final int startLine = grammarElement.getStartLine();
        final int endLine = grammarElement.getEndLine();
        return new Metadata(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getEndLine() {
                return endLine;
            }

            @Override
            public int getStartLine() {
                return startLine;
            }
        };
    }

    public static ProtelisProgram parse(@Nonnull Resource resource) {
        try {
            return (ProtelisProgram)FLYWEIGHT.get((Object)resource);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ProtelisProgram parse(String program) {
        if (Objects.requireNonNull(program, "null is not a valid Protelis program, not a valid Protelis module").isEmpty()) {
            throw new IllegalArgumentException("The empty string is not a valid program, nor a valid module name");
        }
        try {
            String programURI;
            Optional<ProtelisProgram> programResource;
            if (REGEX_PROTELIS_MODULE.matcher(program).matches() && (programResource = ProtelisLoader.resourceFromURIString(programURI = "classpath:/" + program.replace(':', '/') + ".pt").map(ProtelisLoader::parse)).isPresent()) {
                return programResource.get();
            }
            return ProtelisLoader.resourceFromURIString(program).map(ProtelisLoader::parse).orElseGet(() -> ProtelisLoader.parseAnonymousModule(program));
        }
        catch (IOException e) {
            throw new IllegalStateException(program + " looks like an URI, but its resolution failed (see cause)", e);
        }
    }

    public static ProtelisProgram parseAnonymousModule(String program) {
        return ProtelisLoader.parse(ProtelisLoader.resourceFromString(program));
    }

    public static ProtelisProgram parseURI(String programURI) throws IOException {
        return ProtelisLoader.parse(ProtelisLoader.resourceFromURIString(programURI).orElseThrow(IllegalArgumentException::new));
    }

    private static List<Resource.Diagnostic> recursivelyCollectErrors(Resource resource) {
        return resource.getResourceSet().getResources().stream().map(Resource::getErrors).filter(err -> !err.isEmpty()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource resourceFromString(String program) {
        String programId = "dummy:/protelis-generated-program-" + Hashing.sha512().hashString((CharSequence)program, StandardCharsets.UTF_8) + ".pt";
        URI uri = ProtelisLoader.workAroundOpenJ9EMFBug(() -> URI.createURI((String)programId));
        ThreadLocal<XtextResourceSet> threadLocal = XTEXT;
        synchronized (threadLocal) {
            Resource r = XTEXT.get().getResource(uri, false);
            if (r == null) {
                StringInputStream in;
                try {
                    in = new StringInputStream(program);
                    try {
                        ProtelisLoader.loadStringResources(XTEXT.get(), (InputStream)in);
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Couldn't get resource associated with anonymous program: " + e.getMessage(), e);
                }
                r = XTEXT.get().createResource(uri);
                try {
                    in = new StringInputStream(program);
                    try {
                        r.load((InputStream)in, XTEXT.get().getLoadOptions());
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("I/O error while reading in RAM: this must be tough.", e);
                }
            }
            return r;
        }
    }

    private static Optional<Resource> resourceFromURIString(String programURI) throws IOException {
        ResolvedResource resource = new ResolvedResource(programURI);
        if (resource.exists()) {
            ProtelisLoader.loadResourcesRecursively(XTEXT.get(), programURI);
            URI uri = ProtelisLoader.workAroundOpenJ9EMFBug(() -> URI.createURI((String)resource.realURI));
            return Optional.of(XTEXT.get().getResource(uri, true));
        }
        return Optional.empty();
    }

    private static <R> R workAroundOpenJ9EMFBug(Supplier<R> fun) {
        try {
            return fun.get();
        }
        catch (AssertionError e) {
            LOGGER.warn(OPEN_J9_EMF_WORKED_AROUND, (Throwable)((Object)e));
            return fun.get();
        }
    }

    private static final class ResolvedResource {
        private static final String CLASSPATH_PROTOCOL = "classpath:";
        private final String classpathURL;
        private final String realURI;

        private ResolvedResource(String programURI) {
            this.realURI = (programURI.startsWith("/") ? CLASSPATH_PROTOCOL : "") + programURI;
            this.classpathURL = this.realURI.startsWith(CLASSPATH_PROTOCOL) ? this.realURI.substring(CLASSPATH_PROTOCOL.length() + 1) : this.realURI;
        }

        private boolean exists() {
            return Thread.currentThread().getContextClassLoader().getResource(this.classpathURL) != null;
        }

        private InputStream openStream() {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(this.classpathURL);
        }

        public String toString() {
            return "From classpath: " + this.classpathURL + ", complete URI: " + this.realURI;
        }
    }

    private static final class Dispatch {
        private static final Cache<EObject, FunctionDefinition> VIRTUAL_METHOD_TABLE = CacheBuilder.newBuilder().weakKeys().build();
        private static final HashingFunnel FUNNEL = new Java8CompatibleFunnel();

        private Dispatch() {
        }

        private static ProtelisAST<?> alignedMap(@Nonnull org.protelis.parser.protelis.AlignedMap alMap) {
            return new AlignedMap(FUNNEL, ProtelisLoader.metadataFor((EObject)alMap), Dispatch.expression(alMap.getArg()), Dispatch.expression(alMap.getCond()), Dispatch.expression(alMap.getOp()), Dispatch.expression(alMap.getDefault()));
        }

        private static AssignmentOp assignment(Assignment assignment) {
            return new AssignmentOp(ProtelisLoader.metadataFor((EObject)assignment), ProtelisLoadingUtilities.referenceFor(assignment.getRefVar()), Dispatch.expression(assignment.getRight()));
        }

        private static ProtelisAST<?> block(@Nonnull Block block) {
            EList statements = block.getStatements();
            if (statements.size() == 1) {
                return Dispatch.statement((Statement)statements.get(0));
            }
            return new All(ProtelisLoader.metadataFor((EObject)block), statements.stream().map(Dispatch::statement).collect(Collectors.toList()));
        }

        private static <T> ProtelisAST<T> blockUnsafe(@Nonnull Block block) {
            return Dispatch.block(block);
        }

        private static ProtelisAST<?> builtin(@Nonnull Builtin expression) {
            if (expression instanceof org.protelis.parser.protelis.AlignedMap) {
                return Dispatch.alignedMap((org.protelis.parser.protelis.AlignedMap)expression);
            }
            Metadata meta = ProtelisLoader.metadataFor((EObject)expression);
            if (expression instanceof org.protelis.parser.protelis.Env) {
                return new Env(meta);
            }
            if (expression instanceof org.protelis.parser.protelis.Eval) {
                return new Eval(meta, (ProtelisAST<?>)Dispatch.expression(((org.protelis.parser.protelis.Eval)expression).getArg()));
            }
            if (expression instanceof BuiltinHoodOp) {
                BuiltinHoodOp hood = (BuiltinHoodOp)expression;
                return new HoodCall(meta, Dispatch.expression(hood.getArg()), HoodOp.get(hood.getName().replace(ProtelisLoader.HOOD_END, "")), hood.isInclusive());
            }
            if (expression instanceof GenericHood) {
                GenericHood hood = (GenericHood)expression;
                boolean inclusive = hood.getName().length() > 4;
                ProtelisAST nullResult = Dispatch.expression(hood.getDefault());
                ProtelisAST<Field<Object>> field = Dispatch.expression(hood.getArg());
                VarUse ref = hood.getReference();
                if (ref == null) {
                    return new GenericHoodCall(meta, inclusive, Dispatch.lambda(hood.getOp()), nullResult, field);
                }
                if (ref.getReference() instanceof JvmOperation) {
                    return new GenericHoodCall(meta, inclusive, (JvmOperation)ref.getReference(), nullResult, field);
                }
                return new GenericHoodCall(meta, inclusive, Dispatch.variableUnsafe(ref), nullResult, field);
            }
            if (expression instanceof It) {
                return new Variable(meta, ProtelisLoadingUtilities.IT);
            }
            if (expression instanceof Mux) {
                Mux mux = (Mux)expression;
                return new TernaryOp(meta, mux.getName(), Dispatch.expression(mux.getCond()), Dispatch.block(mux.getThen()), Dispatch.block(mux.getElse()));
            }
            if (expression instanceof org.protelis.parser.protelis.Self) {
                return new Self(meta);
            }
            throw new IllegalStateException("Unknown builtin of type " + expression.getClass().getSimpleName());
        }

        private static AssignmentOp declaration(Declaration declaration) {
            VarDef name = declaration.getName();
            return new AssignmentOp(ProtelisLoader.metadataFor((EObject)declaration), ProtelisLoadingUtilities.referenceFor(name), Dispatch.expression(declaration.getRight()));
        }

        private static <T> ProtelisAST<T> expression(Expression expression) {
            return Dispatch.expressionRaw(expression);
        }

        private static List<ProtelisAST<?>> expressionList(@Nullable ExpressionList list) {
            return (List)Optional.ofNullable(list).map(ExpressionList::getArgs).orElseGet(Collections::emptyList).stream().map(Dispatch::expression).collect(ImmutableList.toImmutableList());
        }

        private static ProtelisAST<?> expressionRaw(Expression expression) {
            if (expression instanceof Builtin) {
                return Dispatch.builtin((Builtin)expression);
            }
            if (expression instanceof org.protelis.parser.protelis.If) {
                return Dispatch.ifOp((org.protelis.parser.protelis.If)expression);
            }
            if (expression instanceof Lambda) {
                return Dispatch.lambda((Lambda)expression);
            }
            if (expression instanceof NBR) {
                return Dispatch.nbr((NBR)expression);
            }
            if (expression instanceof Rep) {
                return Dispatch.rep((Rep)expression);
            }
            if (expression instanceof Scalar) {
                return Dispatch.scalar((Scalar)expression);
            }
            if (expression instanceof Share) {
                return Dispatch.share((Share)expression);
            }
            if (expression instanceof VarUse) {
                return Dispatch.variable((VarUse)expression);
            }
            EList elements = expression.getElements();
            Metadata meta = ProtelisLoader.metadataFor((EObject)expression);
            switch (elements.size()) {
                case 1: {
                    return new UnaryOp(meta, expression.getName(), Dispatch.expression((Expression)elements.get(0)));
                }
                case 2: {
                    ProtelisAST first = Dispatch.expression((Expression)expression.getElements().get(0));
                    EObject second = (EObject)expression.getElements().get(1);
                    if (expression.getName() == null && second instanceof InvocationArguments) {
                        Object constant;
                        InvocationArguments invokeArgs = (InvocationArguments)second;
                        if (first instanceof Constant && (constant = ((Constant)first).getConstantValue()) instanceof FunctionDefinition) {
                            return new FunctionCall(meta, (FunctionDefinition)constant, Dispatch.invocationArguments(invokeArgs));
                        }
                        return new Invoke(meta, "apply", first, Dispatch.invocationArguments(invokeArgs));
                    }
                    if (".".equals(expression.getName()) && second instanceof MethodCall) {
                        MethodCall method = (MethodCall)second;
                        return new Invoke(meta, method.getName(), first, Dispatch.invocationArguments(method.getArguments()));
                    }
                    if (expression.getName() == null) break;
                    return new BinaryOp(meta, expression.getName(), first, Dispatch.expression((Expression)second));
                }
            }
            throw new IllegalStateException("Unknown AST node " + expression);
        }

        private static ProtelisAST<?> ifOp(org.protelis.parser.protelis.If ifOp) {
            return new If(ProtelisLoader.metadataFor((EObject)ifOp), Dispatch.expression(ifOp.getCond()), Dispatch.blockUnsafe(ifOp.getThen()), Dispatch.block(ifOp.getElse()));
        }

        private static ConditionalSideEffect ifWithoutElse(IfWithoutElse ifOp) {
            Metadata meta = ProtelisLoader.metadataFor((EObject)ifOp);
            List<ProtelisAST<?>> then = ifOp.getThen().stream().map(Dispatch::statement).collect(Collectors.toList());
            ProtelisAST<Object> thenBranch = then.size() == 1 ? (ProtelisAST)then.get(0) : new All(meta, then);
            return new ConditionalSideEffect(meta, Dispatch.expression(ifOp.getCond()), (ProtelisAST<?>)thenBranch);
        }

        private static List<ProtelisAST<?>> invocationArguments(@Nonnull InvocationArguments args) {
            return (List)ProtelisLoadingUtilities.argumentsToExpressionStream(args).map(Dispatch::expression).collect(ImmutableList.toImmutableList());
        }

        private static Constant<FunctionDefinition> lambda(@Nonnull Lambda expression) {
            EList arguments = expression instanceof LongLambda ? ((LongLambda)expression).getArgs().getArgs() : (expression instanceof OldLongLambda ? Optional.ofNullable(((OldLongLambda)expression).getArgs()).map(VarDefList::getArgs).orElseGet(Collections::emptyList) : (expression instanceof OldShortLambda ? Collections.singletonList(((OldShortLambda)expression).getSingleArg()) : Collections.emptyList()));
            FunctionDefinition lambda = new FunctionDefinition(expression, ProtelisLoadingUtilities.referenceListFor(arguments), Dispatch.block(expression.getBody()));
            return new Constant<FunctionDefinition>(ProtelisLoader.metadataFor((EObject)expression), lambda);
        }

        private static <T> NBRCall<T> nbr(NBR nbr) {
            return new NBRCall<T>(ProtelisLoader.metadataFor((EObject)nbr), Dispatch.expression(nbr.getArg()));
        }

        private static ShareCall<?, ?> rep(Rep rep) {
            Metadata meta = ProtelisLoader.metadataFor((EObject)rep);
            RepInitialize init = rep.getInit();
            Optional<Reference> local = Optional.of(ProtelisLoadingUtilities.referenceFor(init.getX()));
            Optional yield = Optional.ofNullable(rep.getYields()).map(Yield::getBody).map(Dispatch::blockUnsafe);
            return new ShareCall(meta, local, Optional.empty(), Dispatch.expression(init.getW()), Dispatch.block(rep.getBody()), yield);
        }

        private static ProtelisAST<?> scalar(@Nonnull Scalar expression) {
            Metadata meta = ProtelisLoader.metadataFor((EObject)expression);
            if (expression instanceof BooleanVal) {
                return new Constant<Boolean>(meta, ((BooleanVal)expression).isVal());
            }
            if (expression instanceof DoubleVal) {
                return new Constant<Double>(meta, ((DoubleVal)expression).getVal());
            }
            if (expression instanceof StringVal) {
                return new Constant<String>(meta, ((StringVal)expression).getVal());
            }
            if (expression instanceof TupleVal) {
                return new CreateTuple(meta, Dispatch.expressionList(((TupleVal)expression).getArgs()));
            }
            throw new IllegalStateException("Unknown scalar of type " + expression.getClass().getSimpleName());
        }

        private static ShareCall<?, ?> share(Share share) {
            ShareInitialize init = share.getInit();
            Optional<Reference> local = Optional.ofNullable(init.getLocal()).map(ProtelisLoadingUtilities::referenceFor);
            Optional<Reference> field = Optional.ofNullable(init.getField()).map(ProtelisLoadingUtilities::referenceFor);
            Optional yield = Optional.ofNullable(share.getYields()).map(Yield::getBody).map(Dispatch::blockUnsafe);
            return new ShareCall(ProtelisLoader.metadataFor((EObject)share), local, field, Dispatch.expression(init.getW()), Dispatch.block(share.getBody()), yield);
        }

        private static ProtelisAST<?> statement(@Nonnull Statement statement) {
            if (statement instanceof Expression) {
                return Dispatch.expression((Expression)statement);
            }
            if (statement instanceof Declaration) {
                return Dispatch.declaration((Declaration)statement);
            }
            if (statement instanceof Assignment) {
                return Dispatch.assignment((Assignment)statement);
            }
            if (statement instanceof IfWithoutElse) {
                return Dispatch.ifWithoutElse((IfWithoutElse)statement);
            }
            throw new IllegalStateException("Unknown statement of type " + statement.getClass().getSimpleName());
        }

        private static ProtelisAST<?> variable(@Nonnull VarUse expression) {
            Metadata meta = ProtelisLoader.metadataFor((EObject)expression);
            EObject ref = expression.getReference();
            if (ref instanceof JvmFeature) {
                return new JvmConstant(meta, new JVMEntity((JvmFeature)ref));
            }
            if (ref instanceof FunctionDef) {
                FunctionDef functionDefinition = (FunctionDef)ref;
                try {
                    FunctionDefinition target = (FunctionDefinition)VIRTUAL_METHOD_TABLE.get((Object)functionDefinition, () -> new FunctionDefinition(functionDefinition, () -> Dispatch.functionBody(functionDefinition)));
                    return new Constant<FunctionDefinition>(meta, target);
                }
                catch (ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }
            return new Variable(meta, ProtelisLoadingUtilities.referenceFor(ref));
        }

        private static <T> ProtelisAST<T> variableUnsafe(VarUse expression) {
            return Dispatch.variable(expression);
        }

        private static ProtelisAST<?> functionBody(FunctionDef fun) {
            if (fun.getSingleExpression() == null) {
                return Dispatch.block(fun.getBody());
            }
            return Dispatch.expression(fun.getSingleExpression());
        }
    }
}

