/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.util.ProtelisRuntimeException;
import org.protelis.lang.interpreter.util.WithBytecode;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public abstract class AbstractProtelisAST<T>
implements ProtelisAST<T>,
WithBytecode {
    private static final long serialVersionUID = 1L;
    private final List<ProtelisAST<?>> branches;
    private final Metadata metadata;

    protected AbstractProtelisAST(Metadata metadata, ProtelisAST<?> ... branch) {
        this(metadata, branch.length == 0 ? Collections.emptyList() : Arrays.asList(branch));
    }

    protected AbstractProtelisAST(Metadata metadata, List<ProtelisAST<?>> branch) {
        this.metadata = Objects.requireNonNull(metadata);
        Objects.requireNonNull(branch);
        this.branches = branch;
    }

    protected final String branchesToString() {
        return this.branchesToString(", ", "(", ")");
    }

    protected final String branchesToString(CharSequence separator, CharSequence prefix, CharSequence postfix) {
        StringBuilder sb = new StringBuilder(prefix);
        this.forEachWithIndex((i, branch) -> {
            sb.append(AbstractProtelisAST.stringFor(branch));
            if (i < this.branches.size() - 1) {
                sb.append(separator);
            }
        });
        return sb.append(postfix).toString();
    }

    @Override
    public final T eval(ExecutionContext context) {
        try {
            Object result = context.runInNewStackFrame(this.getBytecode().getCode(), this::evaluate);
            if (this.isNullable() || result != null) {
                return (T)result;
            }
            throw new ProtelisRuntimeException(new IllegalStateException("Evaluation returned null, but null values are not allowed but when interacting with Java methods."), this);
        }
        catch (ProtelisRuntimeException e) {
            e.fillInStackFrame(this);
            throw e;
        }
        catch (Exception e) {
            throw new ProtelisRuntimeException(e, this);
        }
    }

    protected abstract T evaluate(ExecutionContext var1);

    protected final void forEach(Consumer<? super ProtelisAST<?>> action) {
        for (ProtelisAST<?> subProgram : this.branches) {
            action.accept(subProgram);
        }
    }

    protected boolean isNullable() {
        return false;
    }

    protected final void forEachWithIndex(BiConsumer<Integer, ? super ProtelisAST<?>> action) {
        for (int i = 0; i < this.getBranchesNumber(); ++i) {
            action.accept(i, this.getBranch(i));
        }
    }

    @Override
    public final ProtelisAST<?> getBranch(int i) {
        return this.branches.get(i);
    }

    @Override
    public final List<ProtelisAST<?>> getBranches() {
        return Collections.unmodifiableList(this.branches);
    }

    protected final int getBranchesNumber() {
        return this.branches.size();
    }

    @Override
    public final Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return this.getName() + this.branchesToString();
    }

    protected static final String stringFor(ProtelisAST<?> tree) {
        return Objects.requireNonNull(tree, "Impossible to convert a null ProtelisAST to a String").getName();
    }
}

