/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Either;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.datatype.Tuple;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractProtelisAST;
import org.protelis.lang.interpreter.impl.Constant;
import org.protelis.lang.interpreter.impl.FunctionCall;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.HashingFunnel;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class AlignedMap
extends AbstractProtelisAST<Tuple> {
    private static final long serialVersionUID = 2L;
    private final HashingFunnel hasher;
    private final ProtelisAST<?> defaultValue;
    private final ProtelisAST<Field<?>> fieldGenerator;
    private final ProtelisAST<FunctionDefinition> filter;
    private final ProtelisAST<FunctionDefinition> execute;

    public AlignedMap(HashingFunnel hasher, Metadata metadata, ProtelisAST<Field<?>> argument, ProtelisAST<FunctionDefinition> filter, ProtelisAST<FunctionDefinition> operation, ProtelisAST<?> defaultValue) {
        super(metadata, argument, filter, operation, defaultValue);
        this.hasher = hasher;
        this.fieldGenerator = argument;
        this.filter = filter;
        this.execute = operation;
        this.defaultValue = defaultValue;
    }

    @Override
    public Tuple evaluate(ExecutionContext context) {
        Field origin = context.runInNewStackFrame(Bytecode.ALIGNED_MAP_GENERATOR.getCode(), this.fieldGenerator::eval);
        LinkedHashMap<Object, Map> keyToField = new LinkedHashMap<Object, Map>();
        for (Map.Entry pair : origin.iterable()) {
            DeviceUID device = pair.getKey();
            Object originalTupleObject = pair.getValue();
            if (originalTupleObject instanceof Tuple) {
                Tuple originalTuple = (Tuple)originalTupleObject;
                for (Object keyToValueObject : originalTuple) {
                    if (keyToValueObject instanceof Tuple) {
                        Tuple keyToValue = (Tuple)keyToValueObject;
                        if (keyToValue.size() == 2) {
                            Object key = keyToValue.get(0);
                            Iterator value = keyToValue.get(1);
                            Map targetField = keyToField.computeIfAbsent(key, k -> new LinkedHashMap());
                            targetField.put(device, value);
                            continue;
                        }
                        throw new IllegalStateException("The tuple must have length 2, " + keyToValue + " has length " + keyToValue.size());
                    }
                    throw new IllegalStateException("Expected " + Tuple.class + ", got " + keyToValueObject.getClass());
                }
                continue;
            }
            throw new IllegalStateException("Expected " + Tuple.class + ", got " + originalTupleObject.getClass() + ": " + originalTupleObject);
        }
        ArrayList<Tuple> resultList = new ArrayList<Tuple>(keyToField.size());
        Object defaultValue = context.runInNewStackFrame(Bytecode.ALIGNED_MAP_DEFAULT.getCode(), this.defaultValue::eval);
        for (Map.Entry keyFieldPair : keyToField.entrySet()) {
            Object key = keyFieldPair.getKey();
            Map preField = (Map)keyFieldPair.getValue();
            DeviceUID localDeviceUID = context.getDeviceUID();
            Object localValue = Optional.ofNullable(preField.remove(localDeviceUID)).orElse(defaultValue);
            Field.Builder<Object> builder = DatatypeFactory.createFieldBuilder();
            for (Map.Entry entry : preField.entrySet()) {
                builder.add((DeviceUID)entry.getKey(), entry.getValue());
            }
            Field<Object> reifiedField = builder.build(localDeviceUID, localValue);
            ExecutionContext restricted = context.restrictDomain(reifiedField);
            ArrayList args = new ArrayList(2);
            args.add(new Constant(this.getMetadata(), key));
            args.add(new Constant<Field<Object>>(this.getMetadata(), reifiedField));
            Either hashed = (Either)this.hasher.apply(key);
            if (hashed.isLeft()) {
                restricted.newCallStackFrame((Integer)hashed.getLeft());
            } else {
                restricted.newCallStackFrame((byte[])hashed.getRight());
            }
            Object condition = this.callFunctionInSubContext(Bytecode.ALIGNED_MAP_FILTER.getCode(), restricted, this.filter, args);
            if (condition instanceof Boolean) {
                if (((Boolean)condition).booleanValue()) {
                    resultList.add(DatatypeFactory.createTuple(key, this.callFunctionInSubContext(Bytecode.ALIGNED_MAP_EXECUTE.getCode(), restricted, this.execute, args)));
                }
            } else {
                throw new IllegalStateException("Filter must return a Boolean, got " + condition.getClass());
            }
            restricted.returnFromCallFrame();
        }
        return DatatypeFactory.createTuple(resultList);
    }

    private Object callFunctionInSubContext(int code, ExecutionContext context, ProtelisAST<FunctionDefinition> def, List<ProtelisAST<?>> parameters) {
        return context.runInNewStackFrame(code, ctx -> {
            FunctionDefinition function = (FunctionDefinition)def.eval((ExecutionContext)ctx);
            return new FunctionCall(this.getMetadata(), function, parameters).eval((ExecutionContext)ctx);
        });
    }

    @Override
    public Bytecode getBytecode() {
        return Bytecode.ALIGNED_MAP;
    }

    @Override
    public String getName() {
        return "alignedMap";
    }

    @Override
    public String toString() {
        return this.getName() + this.branchesToString();
    }
}

