/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import javax.annotation.Nonnull;
import org.protelis.lang.datatype.Unit;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractProtelisAST;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class ConditionalSideEffect
extends AbstractProtelisAST<Unit> {
    private static final long serialVersionUID = 1L;

    public ConditionalSideEffect(@Nonnull Metadata metadata, @Nonnull ProtelisAST<Boolean> cond, @Nonnull ProtelisAST<?> then) {
        super(metadata, cond, then);
    }

    @Override
    public Unit evaluate(ExecutionContext context) {
        if (this.condition().eval(context).booleanValue()) {
            context.runInNewStackFrame(Bytecode.IF_THEN.getCode(), this.then()::eval);
        }
        return Unit.UNIT;
    }

    @Override
    public Bytecode getBytecode() {
        return Bytecode.IF;
    }

    @Override
    public String toString() {
        return "if (" + ConditionalSideEffect.stringFor(this.condition()) + ") { " + ConditionalSideEffect.stringFor(this.then()) + "}";
    }

    private ProtelisAST<Boolean> condition() {
        return this.getBranch(0);
    }

    private ProtelisAST<?> then() {
        return this.getBranch(1);
    }
}

