/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.protelis.lang.ProtelisLoader;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractPersistedTree;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;
import org.protelis.vm.ProtelisProgram;

public final class Eval
extends AbstractPersistedTree<Pair<String, ProtelisProgram>, Object> {
    private static final long serialVersionUID = 8811510896686579514L;

    public Eval(Metadata metadata, ProtelisAST<?> arg) {
        super(metadata, arg);
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        Pair<String, ProtelisProgram> previous;
        String currentProgram = this.programText().eval(context).toString();
        Pair<String, ProtelisProgram> actualState = currentProgram.equals((previous = this.loadState(context, () -> this.createState(currentProgram))).getKey()) ? previous : this.createState(currentProgram);
        this.saveState(context, actualState);
        return context.runInNewStackFrame(Bytecode.EVAL_DYNAMIC_CODE.getCode(), ctx -> ((ProtelisProgram)actualState.getRight()).compute((ExecutionContext)ctx));
    }

    private Pair<String, ProtelisProgram> createState(String program) {
        try {
            return new ImmutablePair((Object)program, (Object)ProtelisLoader.parseAnonymousModule(program));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("The following program can't be parsed:\n" + program, e);
        }
    }

    @Override
    public Bytecode getBytecode() {
        return Bytecode.EVAL;
    }

    private ProtelisAST<?> programText() {
        return this.getBranch(0);
    }

    @Override
    public String toString() {
        return "eval(" + Eval.stringFor(this.getBranch(0)) + ")";
    }
}

