/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import javax.annotation.Nonnull;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractProtelisAST;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class If<T>
extends AbstractProtelisAST<T> {
    private static final long serialVersionUID = -4830593657731078743L;
    private final ProtelisAST<Boolean> conditionExpression;
    private final ProtelisAST<T> elseExpression;
    private final ProtelisAST<T> thenExpression;

    public If(@Nonnull Metadata metadata, @Nonnull ProtelisAST<Boolean> cond, @Nonnull ProtelisAST<T> then, @Nonnull ProtelisAST<T> otherwise) {
        super(metadata, new ProtelisAST[0]);
        this.conditionExpression = cond;
        this.thenExpression = then;
        this.elseExpression = otherwise;
    }

    @Override
    public T evaluate(ExecutionContext context) {
        return (T)If.ensureNotAField(this.conditionExpression.eval(context).booleanValue() ? context.runInNewStackFrame(Bytecode.IF_THEN.getCode(), this.thenExpression::eval) : context.runInNewStackFrame(Bytecode.IF_ELSE.getCode(), this.elseExpression::eval));
    }

    private static <T> T ensureNotAField(T in) {
        if (in instanceof Field) {
            throw new IllegalStateException("if statements cannot return a Field, consider using mux: " + in);
        }
        return in;
    }

    @Override
    public Bytecode getBytecode() {
        return Bytecode.IF;
    }

    public ProtelisAST<Boolean> getConditionExpression() {
        return this.conditionExpression;
    }

    public ProtelisAST<T> getElseExpression() {
        return this.elseExpression;
    }

    public ProtelisAST<T> getThenExpression() {
        return this.thenExpression;
    }

    @Override
    public String toString() {
        return this.getName() + " (" + If.stringFor(this.conditionExpression) + ") { " + If.stringFor(this.thenExpression) + " } else { " + If.stringFor(this.thenExpression) + "}";
    }

    @Override
    protected boolean isNullable() {
        return this.elseExpression == null;
    }
}

