/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.List;
import java.util.Objects;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.datatype.JVMEntity;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractProtelisAST;
import org.protelis.lang.interpreter.impl.FunctionCall;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.ReflectionUtils;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class Invoke
extends AbstractProtelisAST<Object> {
    public static final String APPLY = "apply";
    private static final long serialVersionUID = 1L;
    private final boolean isApply;
    private final ProtelisAST<?> leftExpression;
    private final String methodName;

    private Invoke(Metadata metadata, boolean isApply, String name, ProtelisAST<?> target, List<ProtelisAST<?>> args) {
        super(metadata, args);
        Objects.requireNonNull(target);
        this.isApply = isApply;
        this.methodName = isApply ? APPLY : name;
        this.leftExpression = target;
    }

    public Invoke(Metadata metadata, String name, ProtelisAST<?> target, List<ProtelisAST<?>> args) {
        this(metadata, APPLY.equals(name), name, target, args);
    }

    public Invoke(ProtelisAST<?> target, List<ProtelisAST<?>> args) {
        this(target.getMetadata(), true, null, target, args);
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        Object target = context.runInNewStackFrame(Bytecode.DOT_OPERATOR_TARGET.getCode(), this.leftExpression::eval);
        if (this.isApply && target instanceof FunctionDefinition) {
            FunctionDefinition fd = (FunctionDefinition)target;
            return this.makeFunctionCall(fd).eval(context);
        }
        Object[] args = new Object[this.getBranchesNumber()];
        context.newCallStackFrame(Bytecode.DOT_OPERATOR_ARGUMENTS.getCode());
        for (int i = 0; i < this.getBranchesNumber(); ++i) {
            args[i] = context.runInNewStackFrame(i, this.getBranch(i)::eval);
        }
        context.returnFromCallFrame();
        if (this.isApply && target instanceof JVMEntity) {
            JVMEntity jvmEntity = (JVMEntity)target;
            return ReflectionUtils.invokeFieldable(context, jvmEntity.getType(), jvmEntity.getMemberName(), null, args);
        }
        return ReflectionUtils.invokeFieldable(context, target.getClass(), this.methodName, target, args);
    }

    private FunctionCall makeFunctionCall(FunctionDefinition functionDefinition) {
        return new FunctionCall(this.getMetadata(), functionDefinition, this.getBranches());
    }

    @Override
    public Bytecode getBytecode() {
        return Bytecode.DOT_OPERATOR;
    }

    public ProtelisAST<?> getLeftExpression() {
        return this.leftExpression;
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public String toString() {
        return Invoke.stringFor(this.leftExpression) + "." + this.methodName + this.branchesToString();
    }

    @Override
    protected boolean isNullable() {
        return true;
    }
}

