/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.protelis.lang.datatype.DeviceUID;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.impl.FieldMapImpl;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractPersistedTree;
import org.protelis.lang.interpreter.impl.AbstractProtelisAST;
import org.protelis.lang.interpreter.impl.All;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.Reference;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class ShareCall<S, T>
extends AbstractPersistedTree<S, T> {
    private static final long serialVersionUID = 1L;
    private final com.google.common.base.Optional<Reference> fieldName;
    private final com.google.common.base.Optional<Reference> localName;
    private final com.google.common.base.Optional<AbstractProtelisAST<T>> yield;
    private final ProtelisAST<S> init;
    private final ProtelisAST<S> body;

    public ShareCall(@Nonnull Metadata metadata, @Nonnull Optional<Reference> localName, @Nonnull Optional<Reference> fieldName, @Nonnull ProtelisAST<S> init, @Nonnull ProtelisAST<S> body, @Nonnull Optional<ProtelisAST<T>> yield) {
        this(metadata, ShareCall.toGuava(localName), ShareCall.toGuava(fieldName), init, body, ShareCall.toGuava(yield));
    }

    public ShareCall(@Nonnull Metadata metadata, @Nonnull com.google.common.base.Optional<Reference> localName, @Nonnull com.google.common.base.Optional<Reference> fieldName, @Nonnull ProtelisAST<S> init, @Nonnull ProtelisAST<S> body, @Nonnull com.google.common.base.Optional<ProtelisAST<T>> yield) {
        super(metadata, init, body);
        if (!localName.isPresent() && !fieldName.isPresent()) {
            throw new IllegalArgumentException("Share cannot get initialized without at least a variable bind.");
        }
        this.localName = localName;
        this.fieldName = fieldName;
        this.init = init;
        this.body = body;
        this.yield = yield.transform(it -> {
            if (it instanceof AbstractProtelisAST) {
                return (AbstractProtelisAST)it;
            }
            throw new IllegalStateException("class type " + it.getClass().getName() + " unkown and unsupported");
        });
    }

    private Field<S> alignField(DeviceUID localDevice, Field<S> init, Field<S> local, Field<S> nbr) {
        FieldMapImpl.Builder<S> builder = new FieldMapImpl.Builder<S>();
        for (Map.Entry<DeviceUID, S> entry : nbr.iterable()) {
            DeviceUID otherDevice = entry.getKey();
            if (localDevice.equals(otherDevice)) continue;
            S value = local.containsKey(otherDevice) ? local.get(otherDevice) : init.get(otherDevice);
            builder.add(otherDevice, value);
        }
        return builder.build(localDevice, local.get(localDevice));
    }

    private Optional<Field<S>> asFieldOrEmpty(S value, boolean condition) {
        return Optional.of(value).filter(it -> condition && it instanceof Field).map(it -> (Field)it);
    }

    @Override
    public T evaluate(ExecutionContext context) {
        com.google.common.base.Optional<T> yieldResult;
        Object initValue = context.runInNewStackFrame(Bytecode.SHARE_INIT.getCode(), this.init::eval);
        Object localValue = this.ensureType(this.loadState(context, () -> initValue));
        boolean localIsField = localValue instanceof Field;
        if (localIsField && !(initValue instanceof Field)) {
            throw new IllegalStateException("The local value " + localValue + " is a field, but the default one " + initValue + " is not: " + initValue.getClass().getSimpleName() + ". Types must be consistent");
        }
        BodyResult bodyResult = new BodyResult();
        DeviceUID myId = context.getDeviceUID();
        Optional<Field<S>> localAsField = this.asFieldOrEmpty(localValue, localIsField);
        Optional<Field<Object>> initAsField = this.asFieldOrEmpty(initValue, localIsField);
        assert (!localIsField || localAsField.isPresent() && initAsField.isPresent());
        Field<Object> nbr = this.fieldName.isPresent() ? (localIsField ? context.buildFieldDeferred(field -> this.extractValueFromField((Field)initAsField.get(), (Field)field, myId), localAsField.get(), () -> bodyResult.getResult()) : context.buildFieldDeferred(Function.identity(), localValue, () -> bodyResult.getResult())) : null;
        ShareCall.ifPresent(this.localName, localIsField ? it -> context.putVariable((Reference)it, this.alignField(myId, (Field)initAsField.get(), (Field)localAsField.get(), nbr)) : it -> context.putVariable((Reference)it, localValue));
        ShareCall.ifPresent(this.fieldName, it -> context.putVariable((Reference)it, nbr));
        context.newCallStackFrame(Bytecode.SHARE_BODY.getCode());
        if (this.body instanceof All) {
            All multilineBody = (All)this.body;
            multilineBody.forEachWithIndex((i, b) -> {
                context.newCallStackFrame((int)i);
                bodyResult.result = b.eval(context);
            });
            yieldResult = this.evaluateYield(context);
            multilineBody.forEach(it -> context.returnFromCallFrame());
        } else {
            bodyResult.result = this.body.eval(context);
            yieldResult = this.evaluateYield(context);
        }
        context.returnFromCallFrame();
        this.saveState(context, this.ensureType(bodyResult.result));
        return (T)yieldResult.or(bodyResult.result);
    }

    private S ensureType(Object o) {
        return (S)Objects.requireNonNull(o, "Share is not allowed to return, store, or get initialized to null values.");
    }

    private com.google.common.base.Optional<T> evaluateYield(ExecutionContext context) {
        return this.yield.transform(it -> context.runInNewStackFrame(Bytecode.SHARE_YIELD.getCode(), it::eval));
    }

    private S extractValueFromField(Field<S> init, Field<S> other, DeviceUID id) {
        return other.containsKey(id) ? other.get(id) : init.get(other.getLocalDevice());
    }

    @Override
    public Bytecode getBytecode() {
        return this.fieldName.isPresent() ? Bytecode.SHARE : Bytecode.REP;
    }

    @Override
    public String getName() {
        return this.fieldName.isPresent() ? "share" : "rep";
    }

    public com.google.common.base.Optional<AbstractProtelisAST<T>> getYieldExpression() {
        return this.yield;
    }

    @Override
    public String toString() {
        com.google.common.base.Optional field = this.fieldName.transform(Reference::toString);
        return this.getName() + " (" + (String)this.localName.transform(Reference::toString).transform(it -> it + (String)field.transform(f -> ", ").or((Object)"")).or((Object)"") + (String)field.or((Object)"") + " <- " + ShareCall.stringFor(this.init) + ") { " + ShareCall.stringFor(this.body) + " }" + (String)this.yield.transform(it -> " yield { " + ShareCall.stringFor(it) + "}").or((Object)"");
    }

    private static <T> void ifPresent(com.google.common.base.Optional<T> var, Consumer<T> todo) {
        if (var.isPresent()) {
            todo.accept(var.get());
        }
    }

    private static <T> com.google.common.base.Optional<T> toGuava(Optional<T> origin) {
        return com.google.common.base.Optional.fromNullable(origin.orElse(null));
    }

    private static final class BodyResult<S> {
        private S result;

        private BodyResult() {
        }

        private S getResult() {
            return this.result;
        }
    }
}

