/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.JVMEntity;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractProtelisAST;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.Reference;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class Variable
extends AbstractProtelisAST<Object> {
    private static final long serialVersionUID = 1L;
    private final Reference name;

    public Variable(Metadata metadata, Reference ref) {
        super(metadata, new ProtelisAST[0]);
        this.name = ref;
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        Field val = context.getVariable(this.name);
        if (val == null) {
            throw new IllegalStateException("Variable " + this.name + " cannot be resolved");
        }
        if (val instanceof JVMEntity) {
            val = ((JVMEntity)((Object)val)).getValue();
        } else if (val instanceof Field) {
            Field unrestricted = val;
            Field<Byte> restricted = context.buildField(it -> it, (byte)0);
            val = unrestricted.projectOn(restricted);
        }
        return val;
    }

    @Override
    public Bytecode getBytecode() {
        return Bytecode.VARIABLE_ACCESS;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

