/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.protelis.lang.datatype.FunctionDefinition;
import org.protelis.lang.datatype.JVMEntity;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.Constant;
import org.protelis.lang.interpreter.impl.FunctionCall;
import org.protelis.lang.interpreter.impl.Invoke;
import org.protelis.lang.interpreter.impl.JvmConstant;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class JavaInteroperabilityUtils {
    public static final Metadata METADATA = new Metadata(){
        private static final long serialVersionUID = 1L;

        @Override
        public int getStartLine() {
            return -1;
        }

        @Override
        public int getEndLine() {
            return -1;
        }
    };

    private JavaInteroperabilityUtils() {
    }

    public static Object runStaticMethodWithProtelisArguments(ExecutionContext context, Method method, ProtelisAST<?> ... arguments) {
        Objects.requireNonNull(method);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method " + method + " cannot be invoked statically.");
        }
        return new Invoke(new JvmConstant(METADATA, new JVMEntity(method)), Arrays.asList(arguments)).eval(context);
    }

    public static Object runMethodWithProtelisArguments(ExecutionContext context, ProtelisAST<?> receiver, String method, ProtelisAST<?> ... arguments) {
        return new Invoke(METADATA, method, receiver, Arrays.asList(arguments)).eval(context);
    }

    private static List<ProtelisAST<?>> toAnnotatedTree(Object[] a) {
        return Arrays.stream(a).map(it -> new Constant<Object>(METADATA, it)).collect(Collectors.toList());
    }

    @Nonnull
    public static Object runProtelisFunction(ExecutionContext context, ProtelisAST<FunctionDefinition> function, List<ProtelisAST<?>> arguments) {
        return new Invoke(function, arguments).eval(context);
    }

    public static Object runProtelisFunctionWithJavaArguments(ExecutionContext context, ProtelisAST<FunctionDefinition> function, Object ... arguments) {
        return JavaInteroperabilityUtils.runProtelisFunction(context, function, JavaInteroperabilityUtils.toAnnotatedTree(arguments));
    }

    @Nonnull
    public static Object runProtelisFunctionWithJavaArguments(@Nonnull ExecutionContext context, @Nonnull FunctionDefinition function, @Nonnull List<?> arguments) {
        List<ProtelisAST<?>> actualArguments = arguments.stream().map(it -> new Constant<Object>(METADATA, it)).collect(Collectors.toList());
        return JavaInteroperabilityUtils.runProtelisFunction(context, new Constant<FunctionDefinition>(METADATA, function), actualArguments);
    }

    public static BinaryOperator<Object> toBinaryOperator(ExecutionContext context, FunctionDefinition binaryOperator) {
        if (binaryOperator.getParameterCount() == 2) {
            AtomicInteger counter = new AtomicInteger();
            return (first, second) -> {
                ImmutableList arguments = ImmutableList.of(new Constant<Object>(METADATA, first), new Constant<Object>(METADATA, second));
                FunctionCall call = new FunctionCall(METADATA, binaryOperator, (List<ProtelisAST<?>>)arguments);
                return context.runInNewStackFrame(counter.getAndIncrement(), call::eval);
            };
        }
        throw new IllegalArgumentException("Reducing function must take two parameters.");
    }

    public static <R> Function<Object, R> toFunction(ExecutionContext context, FunctionDefinition function) {
        if (function.getParameterCount() <= 1) {
            AtomicInteger counter = new AtomicInteger();
            return argument -> {
                ImmutableList arguments = ImmutableList.of(new Constant<Object>(METADATA, argument));
                FunctionCall call = new FunctionCall(METADATA, function, (List<ProtelisAST<?>>)arguments);
                return context.runInNewStackFrame(counter.getAndIncrement(), call::eval);
            };
        }
        throw new IllegalArgumentException("Reducing function must take two parameters.");
    }
}

