/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.IntStream;
import org.apache.commons.math3.util.FastMath;
import org.protelis.lang.datatype.DatatypeFactory;
import org.protelis.lang.datatype.Field;
import org.protelis.lang.datatype.Fields;
import org.protelis.lang.datatype.Tuple;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.OpUtils;
import org.protelis.lang.interpreter.util.WithBytecode;

public enum Op2 implements WithBytecode
{
    AND(Bytecode.BINARY_AND, "&&", Op2::and),
    DIFFERS(Bytecode.BINARY_DIFFERS, "!=", (a, b) -> !Op2.areEquals(a, b)),
    DIVIDE(Bytecode.BINARY_DIVIDE, "/", Op2::divide),
    EQUALS(Bytecode.BINARY_EQUALS, "==", Op2::areEquals),
    GREATER(Bytecode.BINARY_GREATER, ">", Op2::greater),
    GREATER_EQUAL(Bytecode.BINARY_GREATER_EQUAL, ">=", Op2::greaterEquals),
    MAX(Bytecode.BINARY_MAX, "max", Op2::max),
    MIN(Bytecode.BINARY_MIN, "min", Op2::min),
    MINUS(Bytecode.BINARY_MINUS, "-", Op2::minus),
    MODULUS(Bytecode.BINARY_MODULUS, "%", Op2::modulus),
    OR(Bytecode.BINARY_OR, "||", Op2::or),
    PLUS(Bytecode.BINARY_PLUS, "+", Op2::plus),
    POWER(Bytecode.BINARY_POWER, "^", Op2::pow),
    SMALLER(Bytecode.BINARY_SMALLER, "<", Op2::smaller),
    SMALLER_EQUAL(Bytecode.BINARY_SMALLER_EQUAL, "<=", Op2::smallerEquals),
    TIMES(Bytecode.BINARY_TIMES, "*", Op2::times);

    private static final String UNCHECKED = "unchecked";
    private static final int[] BOTH;
    private static final int[] LEFT;
    private static final int[] RIGHT;
    private static final int[] NONE;
    private static final Map<String, Op2> MAP;
    private final BinaryOperation fun;
    private final String opName;
    private final Bytecode bytecode;

    private Op2(Bytecode bytecode, String name, BinaryOperation function) {
        this.bytecode = bytecode;
        this.fun = function;
        this.opName = name;
    }

    public BinaryOperator<Object> getFunction() {
        return this.fun;
    }

    public Object run(Object a, Object b) {
        int[] fields;
        boolean afield = a instanceof Field;
        boolean bfield = b instanceof Field;
        int[] nArray = afield && bfield ? BOTH : (afield ? LEFT : (fields = bfield ? RIGHT : NONE));
        if (fields.length > 0) {
            return Fields.apply(this.fun, fields, a, b);
        }
        return this.fun.apply(a, b);
    }

    public String toString() {
        return this.opName;
    }

    public static Op2 getOp(String name) {
        Op2 op = MAP.get(name);
        if (op == null) {
            op = Arrays.stream(Op2.values()).filter(o -> o.opName.equals(name)).findFirst().get();
            MAP.put(name, op);
        }
        return op;
    }

    private static Object and(Object a, Object b) {
        return Op2.logical("&&", a, b, (v1, v2) -> v1 != false && v2 != false);
    }

    private static Object divide(Object a, Object b) {
        return Op2.arithmetic("/", a, b, (v1, v2) -> v1 / v2);
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    private static boolean areEquals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() == ((Number)b).doubleValue();
        }
        return a.equals(b);
    }

    private static boolean greater(Object a, Object b) {
        return Op2.comparison(">", a, b, (v1, v2) -> v1 > v2);
    }

    private static boolean greaterEquals(Object a, Object b) {
        return Op2.comparison(">=", a, b, (v1, v2) -> v1 >= v2);
    }

    private static <T> boolean comparison(String op, T a, T b, BiFunction<Double, Double, Boolean> f) {
        if (a instanceof Number && b instanceof Number) {
            return f.apply(((Number)a).doubleValue(), ((Number)b).doubleValue());
        }
        try {
            if (a instanceof Comparable && b instanceof Comparable) {
                return f.apply(Double.valueOf(((Comparable)a).compareTo(b)), 0.0);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return f.apply(Double.valueOf(a.toString().compareTo(b.toString())), 0.0);
    }

    private static <T> boolean logical(String op, T a, T b, BiFunction<Boolean, Boolean, Boolean> f) {
        if (a instanceof Boolean && b instanceof Boolean) {
            return f.apply((Boolean)a, (Boolean)b);
        }
        return (Boolean)OpUtils.unsupported(op, a, b);
    }

    private static <T> T selection(String op, T a, T b, BinaryOperator<T> selector) {
        int v;
        boolean aNum = a instanceof Number;
        boolean bNum = b instanceof Number;
        if (aNum && bNum) {
            double bd;
            double ad = ((Number)a).doubleValue();
            if (ad > (bd = ((Number)b).doubleValue())) {
                return (T)selector.apply(a, b);
            }
            return (T)selector.apply(b, a);
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            try {
                int v2 = ((Comparable)a).compareTo(b);
                if (v2 > 0) {
                    return (T)selector.apply(a, b);
                }
                return (T)selector.apply(b, a);
            }
            catch (RuntimeException v2) {
                // empty catch block
            }
        }
        if ((v = a.toString().compareTo(b.toString())) > 0) {
            return (T)selector.apply(a, b);
        }
        return (T)selector.apply(b, a);
    }

    private static Object min(Object a, Object b) {
        return Op2.selection("min", a, b, (v1, v2) -> v2);
    }

    private static Object max(Object a, Object b) {
        return Op2.selection("max", a, b, (v1, v2) -> v1);
    }

    private static Object minus(Object a, Object b) {
        return Op2.arithmetic("-", a, b, (v1, v2) -> v1 - v2);
    }

    private static Object modulus(Object a, Object b) {
        return Op2.arithmetic("%", a, b, (v1, v2) -> v1 % v2);
    }

    private static Object or(Object a, Object b) {
        return Op2.logical("||", a, b, (v1, v2) -> v1 != false || v2 != false);
    }

    private static Object plus(Object a, Object b) {
        if (a instanceof CharSequence || b instanceof CharSequence) {
            return a.toString() + b.toString();
        }
        try {
            return Op2.arithmetic("+", a, b, (v1, v2) -> v1 + v2);
        }
        catch (UnsupportedOperationException e) {
            return a.toString() + b.toString();
        }
    }

    private static Object pow(Object a, Object b) {
        return Op2.arithmetic("^", a, b, (v1, v2) -> FastMath.pow((double)v1, (double)v2));
    }

    private static <I, O> O arithmetic(String op, I a, I b, BiFunction<Double, Double, O> f) {
        if (a instanceof Double && b instanceof Double) {
            return f.apply((Double)a, (Double)b);
        }
        boolean aNum = a instanceof Number;
        boolean bNum = b instanceof Number;
        if (aNum && bNum) {
            return f.apply(((Number)a).doubleValue(), ((Number)b).doubleValue());
        }
        boolean aTup = a instanceof Tuple;
        boolean bTup = b instanceof Tuple;
        if (aNum && bTup || aTup && bNum) {
            return (O)Op2.tupleArithmetic(op, aNum, aNum ? a : b, (Tuple)(aTup ? a : b), f);
        }
        if (a instanceof Tuple && b instanceof Tuple) {
            Tuple ta = (Tuple)a;
            Tuple tb = (Tuple)b;
            if (ta.size() == tb.size()) {
                return (O)DatatypeFactory.createTuple(IntStream.range(0, ta.size()).mapToObj(i -> Op2.arithmetic(op, ta.get(i), tb.get(i), f)).toArray());
            }
        }
        return (O)OpUtils.unsupported(op, a, b);
    }

    private static <I, O> Tuple tupleArithmetic(String op, boolean numFirst, I num, Tuple t, BiFunction<Double, Double, O> f) {
        return DatatypeFactory.createTuple(IntStream.range(0, t.size()).mapToObj(i -> numFirst ? Op2.arithmetic(op, num, t.get(i), f) : Op2.arithmetic(op, t.get(i), num, f)).toArray());
    }

    private static boolean smaller(Object a, Object b) {
        return Op2.comparison("<", a, b, (v1, v2) -> v1 < v2);
    }

    private static boolean smallerEquals(Object a, Object b) {
        return Op2.comparison("<=", a, b, (v1, v2) -> v1 <= v2);
    }

    private static Object times(Object a, Object b) {
        return Op2.arithmetic("*", a, b, (v1, v2) -> v1 * v2);
    }

    @Override
    public Bytecode getBytecode() {
        return this.bytecode;
    }

    static {
        BOTH = new int[]{0, 1};
        LEFT = new int[]{0};
        RIGHT = new int[]{1};
        NONE = new int[0];
        MAP = new ConcurrentHashMap<String, Op2>();
    }

    private static interface BinaryOperation
    extends BinaryOperator<Object>,
    Serializable {
    }
}

