/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.util;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.protelis.parser.protelis.FunctionDef;
import org.protelis.parser.protelis.ProtelisModule;
import org.protelis.parser.protelis.VarDef;

public final class Reference
implements Serializable {
    private static final long serialVersionUID = 8294777860793746504L;
    private final Serializable uid;
    private String strRep;

    public Reference(Object obj) {
        if (obj instanceof String) {
            this.strRep = obj.toString();
            this.uid = this.strRep;
        } else if (obj instanceof VarDef) {
            VarDef var = (VarDef)obj;
            ITextRegionWithLineInformation node = NodeModelUtils.getNode((EObject)var).getTextRegionWithLineInformation();
            EObject container = var.eContainer();
            while (container.eContainer() != null && !(container instanceof ProtelisModule)) {
                container = container.eContainer();
            }
            String module = Optional.ofNullable(((ProtelisModule)container).getName()).orElse("$");
            this.uid = new Handler<Object, ImmutableList>(obj, ImmutableList.of((Object)node.getLineNumber(), (Object)node.getEndLineNumber(), (Object)node.getOffset(), (Object)node.getLength(), (Object)var.getName(), (Object)module));
            this.strRep = var.getName();
        } else if (obj instanceof JvmIdentifiableElement) {
            JvmIdentifiableElement method = (JvmIdentifiableElement)obj;
            this.strRep = method.getIdentifier();
            this.uid = new Handler<Object, String>(obj, this.strRep);
        } else if (obj instanceof FunctionDef) {
            FunctionDef function = (FunctionDef)obj;
            ProtelisModule container = (ProtelisModule)function.eContainer();
            String name = Optional.ofNullable(container.getName()).orElse("default-module") + ":";
            this.strRep = name + function.getName();
            this.uid = new Handler<Object, String>(obj, this.strRep);
        } else if (obj instanceof Serializable) {
            this.uid = (Serializable)Objects.requireNonNull(obj);
        } else {
            throw new IllegalArgumentException("Cannot refer to " + obj);
        }
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Reference && ((Reference)obj).uid.equals(this.uid);
    }

    public String toString() {
        if (this.strRep == null) {
            this.strRep = "Var@" + this.uid;
        }
        return this.strRep;
    }

    private static final class Handler<T, S extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final S serializableState;
        private final Class<?> targetClass;

        private Handler(T target, S state) {
            this.targetClass = Objects.requireNonNull(target).getClass();
            this.serializableState = (Serializable)Objects.requireNonNull(state);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Handler) {
                Handler other = (Handler)obj;
                return this.targetClass.equals(other.targetClass) && this.serializableState.equals(other.serializableState);
            }
            return false;
        }

        public int hashCode() {
            return this.serializableState.hashCode();
        }
    }
}

