/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.protelis.lang.interpreter.util.Reference;
import org.protelis.parser.protelis.Assignment;
import org.protelis.parser.protelis.Block;
import org.protelis.parser.protelis.Declaration;
import org.protelis.parser.protelis.Expression;
import org.protelis.parser.protelis.ExpressionList;
import org.protelis.parser.protelis.FunctionDef;
import org.protelis.parser.protelis.IfWithoutElse;
import org.protelis.parser.protelis.InvocationArguments;
import org.protelis.parser.protelis.Lambda;
import org.protelis.parser.protelis.MethodCall;
import org.protelis.parser.protelis.ProtelisModule;
import org.protelis.parser.protelis.VarUse;

public final class ProtelisLoadingUtilities {
    public static final Reference IT = new Reference("it");
    private static final LoadingCache<Object, Reference> REFERENCES = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Object, Reference>(){

        @Nonnull
        public Reference load(@Nonnull Object key) {
            return new Reference(key);
        }
    });

    private ProtelisLoadingUtilities() {
    }

    public static Stream<Expression> argumentsToExpressionStream(@Nonnull InvocationArguments args) {
        Stream lastArgument = Optional.ofNullable(args.getLastArg()).map(Stream::of).orElseGet(Stream::empty);
        Stream inParenthesis = Optional.ofNullable(args.getArgs()).map(ExpressionList::getArgs).orElseGet(Collections::emptyList).stream();
        return Stream.concat(inParenthesis, lastArgument);
    }

    private static String nameFor(EObject container) {
        if (container instanceof Block) {
            return "b";
        }
        if (container instanceof Declaration) {
            return "let";
        }
        if (container instanceof Assignment) {
            return "=";
        }
        if (container instanceof IfWithoutElse) {
            return "ifwoe";
        }
        if (container instanceof ExpressionList) {
            return "";
        }
        if (container instanceof InvocationArguments) {
            return "()";
        }
        if (container instanceof MethodCall) {
            return ((MethodCall)container).getName();
        }
        if (container instanceof Expression) {
            Expression exp = (Expression)container;
            if (exp.getName() == null && exp.getElements().size() == 2) {
                return ProtelisLoadingUtilities.qualifiedNameFor(((VarUse)exp.getElements().get(0)).getReference(), "");
            }
            return exp.getName();
        }
        return container.getClass().getSimpleName();
    }

    private static String qualifiedNameFor(EObject origin, String suffix) {
        if (origin instanceof JvmIdentifiableElement) {
            return ((JvmIdentifiableElement)origin).getQualifiedName();
        }
        EObject container = origin.eContainer();
        if (container instanceof FunctionDef) {
            return ProtelisLoadingUtilities.qualifiedNameFor((FunctionDef)container) + suffix;
        }
        if (container instanceof ProtelisModule) {
            return ProtelisLoadingUtilities.qualifiedNameFor((ProtelisModule)container) + suffix;
        }
        int myId = 0;
        for (Object statement : container.eContents()) {
            if (statement.equals(origin)) {
                return ProtelisLoadingUtilities.qualifiedNameFor(container, ":$" + ProtelisLoadingUtilities.nameFor(container)) + suffix + myId;
            }
            ++myId;
        }
        throw new IllegalStateException("Bug in Protelis qualified name computation");
    }

    public static String qualifiedNameFor(FunctionDef functionDefinition) {
        return ProtelisLoadingUtilities.qualifiedNameFor((ProtelisModule)functionDefinition.eContainer()) + ":" + functionDefinition.getName();
    }

    public static String qualifiedNameFor(Lambda lambda) {
        return ProtelisLoadingUtilities.qualifiedNameFor((EObject)lambda, ":$l");
    }

    public static String qualifiedNameFor(ProtelisModule module) {
        return Optional.ofNullable(module).map(ProtelisModule::getName).map(it -> it.replace("protelis:state:time", "\u23f1").replace("protelis:state:nonselfstabilizing:time", "\u237c\u23f1").replace("protelis:lang:utils", "\u2692").replace("protelis:coord:meta:timereplication", "\u2387\u23f3").replace("protelis:coord:nonselfstabilizing:accumulation", "\u237c\u2356").replace("protelis:coord:accumulation", "\u2356").replace("protelis:coord:graph", "\u23e7").replace("protelis:coord:meta", "\u2387").replace("protelis:coord:sharedtimer", "\u26d6\u23f1").replace("protelis:coord:sparsechoice", "\u2318").replace("protelis:coord:spreading", "\u234f").replace("protelis:coord:tree", "\u23c9")).orElse("?");
    }

    public static Reference referenceFor(Object o) {
        try {
            return (Reference)REFERENCES.get(o);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Unable to create a reference for " + o, e);
        }
    }

    public static List<Reference> referenceListFor(List<?> l) {
        return l.stream().map(ProtelisLoadingUtilities::referenceFor).collect(Collectors.toList());
    }
}

