/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.datatype;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;

public final class JVMEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String memberName;
    private final SupportedEntityTypes memberType;
    private final String typeName;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient Object value;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient Class<?> type;

    public JVMEntity(JvmFeature feature) {
        this.typeName = feature.getDeclaringType().getQualifiedName();
        this.memberName = feature.getSimpleName();
        if (feature instanceof JvmField) {
            this.memberType = SupportedEntityTypes.FIELD;
            this.value = ((JvmField)feature).getConstantValue();
        } else if (feature instanceof JvmOperation) {
            this.memberType = SupportedEntityTypes.METHOD;
        } else {
            throw new IllegalArgumentException("Unknown JvmFeature type " + feature.getClass() + " (" + feature + ")");
        }
    }

    public JVMEntity(Method method) {
        this.typeName = method.getDeclaringClass().getName();
        this.memberName = method.getName();
        this.memberType = SupportedEntityTypes.METHOD;
    }

    public String getMemberName() {
        return this.memberName;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The field is immutable")
    public Class<?> getType() {
        if (this.type == null) {
            try {
                this.type = Class.forName(this.typeName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.type;
    }

    public Object getValue() {
        if (this.value == null) {
            try {
                switch (this.memberType) {
                    case FIELD: {
                        Field field = this.getType().getField(this.memberName);
                        if (Modifier.isStatic(field.getModifiers())) {
                            this.value = field.get(null);
                            break;
                        }
                        throw new IllegalStateException("Protelis cannot access non-static fields such as " + field);
                    }
                    case METHOD: {
                        this.value = this;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Fix Protelis code, it's bugged.");
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.value;
    }

    public String toString() {
        return this.memberType + ":" + this.typeName + "." + this.memberName;
    }

    static enum SupportedEntityTypes {
        FIELD,
        METHOD;

    }
}

