/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.lang.interpreter.impl;

import java.util.Objects;
import org.protelis.lang.interpreter.ProtelisAST;
import org.protelis.lang.interpreter.impl.AbstractProtelisAST;
import org.protelis.lang.interpreter.util.Bytecode;
import org.protelis.lang.interpreter.util.Op2;
import org.protelis.lang.loading.Metadata;
import org.protelis.vm.ExecutionContext;

public final class BinaryOp
extends AbstractProtelisAST<Object> {
    private static final long serialVersionUID = 2803028109250981637L;
    private final Op2 op;

    private BinaryOp(Metadata metadata, Op2 operator, ProtelisAST<?> branch1, ProtelisAST<?> branch2) {
        super(metadata, branch1, branch2);
        Objects.requireNonNull(branch1);
        Objects.requireNonNull(branch2);
        this.op = operator;
    }

    public BinaryOp(Metadata metadata, String name, ProtelisAST<?> branch1, ProtelisAST<?> branch2) {
        this(metadata, Op2.getOp(name), branch1, branch2);
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        return this.op.run(context.runInNewStackFrame(0, this.getBranch(0)::eval), context.runInNewStackFrame(1, this.getBranch(1)::eval));
    }

    @Override
    public Bytecode getBytecode() {
        return this.op.getBytecode();
    }

    @Override
    public String getName() {
        return this.op.toString();
    }

    @Override
    public String toString() {
        return BinaryOp.stringFor(this.getBranch(0)) + " " + this.getName() + " " + BinaryOp.stringFor(this.getBranch(1));
    }
}

