/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.vm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protelis.vm.ExecutionContext;
import org.protelis.vm.ProtelisProgram;

public class ProtelisVM {
    private final ProtelisProgram program;
    private final ExecutionContext context;
    @Nullable
    private Object lastValue;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is intentional")
    public ProtelisVM(ProtelisProgram program, ExecutionContext context) {
        this.program = program;
        this.context = context;
    }

    public void runCycle() {
        this.context.setup();
        this.lastValue = this.program.compute(this.context);
        this.context.commit();
    }

    @Nonnull
    public Object getCurrentValue() {
        return Objects.requireNonNull(this.lastValue, "No computation has happened so far, so no result is available yet. Call 'runCycle()' first.");
    }
}

