/*
 * Decompiled with CFR 0.152.
 */
package org.protelis.parser.validation;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.protelis.parser.ProtelisExtensions;
import org.protelis.parser.protelis.Assignment;
import org.protelis.parser.protelis.Block;
import org.protelis.parser.protelis.BuiltinHoodOp;
import org.protelis.parser.protelis.Declaration;
import org.protelis.parser.protelis.Expression;
import org.protelis.parser.protelis.FunctionDef;
import org.protelis.parser.protelis.GenericHood;
import org.protelis.parser.protelis.Hood;
import org.protelis.parser.protelis.InvocationArguments;
import org.protelis.parser.protelis.It;
import org.protelis.parser.protelis.JavaImport;
import org.protelis.parser.protelis.KotlinStyleLambda;
import org.protelis.parser.protelis.Lambda;
import org.protelis.parser.protelis.LongLambda;
import org.protelis.parser.protelis.MethodCall;
import org.protelis.parser.protelis.OldLambda;
import org.protelis.parser.protelis.OldLongLambda;
import org.protelis.parser.protelis.OldShortLambda;
import org.protelis.parser.protelis.ProtelisModule;
import org.protelis.parser.protelis.ProtelisPackage;
import org.protelis.parser.protelis.ShortLambda;
import org.protelis.parser.protelis.Statement;
import org.protelis.parser.protelis.VarDef;
import org.protelis.parser.protelis.VarDefList;
import org.protelis.parser.validation.AbstractProtelisValidator;

public class ProtelisValidator
extends AbstractProtelisValidator {
    public static final ImmutableList<Integer> MY_VERSION = ImmutableList.of((Object)10, (Object)0, (Object)2);
    private static final EStructuralFeature FIRST_LINE = ProtelisPackage.Literals.PROTELIS_MODULE.getEStructuralFeature(0);
    @Inject
    private TypeReferences references;
    @Inject
    private IEvaluationContext context;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    private static final Iterable<String> AUTO_IMPORT = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"java.lang.Math", "java.lang.Double", "org.protelis.Builtins"}));

    @Check
    public void letNameDoesNotShadowArguments(Declaration exp) {
        EObject parent = exp.eContainer();
        while (parent != null) {
            if (parent instanceof Block) {
                Functions.Function1 _function = it -> !Objects.equal((Object)it, (Object)exp);
                Functions.Function1 _function_1 = it -> {
                    Object _xifexpression = null;
                    _xifexpression = it instanceof Declaration ? ((Declaration)it).getName() : it;
                    return _xifexpression;
                };
                Functions.Function1 _function_2 = it -> it instanceof VarDef;
                Functions.Function1 _function_3 = it -> (VarDef)it;
                Functions.Function1 _function_4 = it -> {
                    String _name = it.getName();
                    String _name_1 = exp.getName().getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                };
                Consumer<VarDef> _function_5 = it -> this.error(exp);
                Optional.ofNullable((VarDef)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.takeWhile(((Block)parent).getStatements(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4))).ifPresent(_function_5);
            }
            if (parent instanceof FunctionDef) {
                boolean _tripleNotEquals;
                VarDefList _args = ((FunctionDef)parent).getArgs();
                boolean bl = _tripleNotEquals = _args != null;
                if (_tripleNotEquals) {
                    Functions.Function1 _function_6 = it -> it.getName();
                    boolean _contains = ListExtensions.map(((FunctionDef)parent).getArgs().getArgs(), (Functions.Function1)_function_6).contains(exp.getName());
                    if (_contains) {
                        this.error(exp);
                    }
                }
            }
            if (parent instanceof Lambda) {
                Functions.Function1 _function_7;
                EList<VarDef> args;
                boolean _exists;
                Object _switchResult = null;
                boolean _matched = false;
                if (parent instanceof OldLongLambda) {
                    _matched = true;
                    Object _elvis = null;
                    VarDefList _args_1 = ((OldLongLambda)parent).getArgs();
                    EList<VarDef> _args_2 = null;
                    if (_args_1 != null) {
                        _args_2 = _args_1.getArgs();
                    }
                    if (_args_2 != null) {
                        _elvis = _args_2;
                    } else {
                        List _emptyList = CollectionLiterals.emptyList();
                        _elvis = _emptyList;
                    }
                    _switchResult = _elvis;
                }
                if (!_matched && parent instanceof OldShortLambda) {
                    _matched = true;
                    VarDef _singleArg = ((OldShortLambda)parent).getSingleArg();
                    _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new VarDef[]{_singleArg}));
                }
                if (!_matched && parent instanceof ShortLambda) {
                    _matched = true;
                    _switchResult = CollectionLiterals.emptyList();
                }
                if (!_matched && parent instanceof LongLambda) {
                    _matched = true;
                    _switchResult = ((LongLambda)parent).getArgs().getArgs();
                }
                if (_exists = IterableExtensions.exists((Iterable)(args = _switchResult), (Functions.Function1)(_function_7 = it -> it.getName().equals(exp.getName())))) {
                    this.error(exp);
                }
            }
            parent = parent.eContainer();
        }
    }

    private void error(Declaration exp) {
        VarDef _name = exp.getName();
        String _plus = "Variable " + _name;
        String error = String.valueOf(_plus) + " has already been defined in this context. Pick another name.";
        this.error(error, exp, null);
    }

    @Check
    public void lastElementOfBlockIsExpression(Block block) {
        boolean _not;
        Statement _last = (Statement)IterableExtensions.last(block.getStatements());
        boolean bl = _not = !(_last instanceof Expression);
        if (_not) {
            this.error("The last statement in a returning block must be an expression", (EObject)IterableExtensions.last(block.getStatements()), null);
        }
    }

    @Check
    public void noProtelisBuiltinsAvailable(ProtelisModule module) {
        boolean _tripleEquals;
        JvmType _findDeclaredType = this.references.findDeclaredType("org.protelis.Builtins", (Notifier)module);
        boolean bl = _tripleEquals = _findDeclaredType == null;
        if (_tripleEquals) {
            this.warning("No builtins available. Is the interpreter in the classpath?", module, ProtelisPackage.Literals.PROTELIS_MODULE.getEStructuralFeature(0));
        }
    }

    @Check
    public void warnOnOldLambda(OldLambda lambda) {
        String _switchResult = null;
        boolean _matched = false;
        if (lambda instanceof OldShortLambda) {
            _matched = true;
            String _name = ((OldShortLambda)lambda).getSingleArg().getName();
            _switchResult = String.valueOf(_name) + " -> ";
        }
        if (!_matched && lambda instanceof OldLongLambda) {
            boolean _tripleEquals;
            _matched = true;
            String _xifexpression = null;
            VarDefList _args = ((OldLongLambda)lambda).getArgs();
            boolean bl = _tripleEquals = _args == null;
            if (_tripleEquals) {
                _xifexpression = "";
            } else {
                Functions.Function1 _function = it -> it.getName();
                _xifexpression = IterableExtensions.join(((OldLongLambda)lambda).getArgs().getArgs(), (CharSequence)"", (CharSequence)", ", (CharSequence)" -> ", (Functions.Function1)_function);
            }
            _switchResult = _xifexpression;
        }
        String args = _switchResult;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This lambda could be rewritten as { ");
        _builder.append(args);
        _builder.append("<body> }");
        this.warning(_builder.toString(), null);
    }

    @Check
    public void deprecatedHoodOperation(BuiltinHoodOp hood) {
        this.deprecatedHoodOperation(hood, ProtelisPackage.Literals.BUILTIN_HOOD_OP.getEStructuralFeature(1));
    }

    @Check
    public void deprecatedHoodOperation(GenericHood hood) {
        this.deprecatedHoodOperation(hood, ProtelisPackage.Literals.HOOD.getEStructuralFeature(1));
    }

    public void deprecatedHoodOperation(Hood hood, EStructuralFeature feature) {
        this.warning("Hardcoded hood operations have been deprecated and will be removed in a future release, see https://github.com/Protelis/Protelis/issues/75", hood, feature);
    }

    @Check
    public void emptyStarImport(JavaImport javaImport) {
        if (javaImport.isWildcard() && IterableExtensions.isEmpty(ProtelisExtensions.callableEntities(javaImport.getImportedType()))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No callable members in ");
            String _simpleName = javaImport.getImportedType().getSimpleName();
            _builder.append(_simpleName);
            this.warning(_builder.toString(), (EStructuralFeature)ProtelisPackage.Literals.JAVA_IMPORT__IMPORTED_TYPE);
        }
    }

    @Check
    public void unresolvableMethodOrField(JavaImport javaImport) {
        if (!javaImport.isWildcard() && IterableExtensions.isEmpty(ProtelisExtensions.callableEntitiesNamed(javaImport.getImportedType(), javaImport.getImportedMemberName()))) {
            StringConcatenation _builder = new StringConcatenation();
            String _importedMemberName = javaImport.getImportedMemberName();
            _builder.append(_importedMemberName);
            _builder.append(" is not a callable member of ");
            String _simpleName = javaImport.getImportedType().getSimpleName();
            _builder.append(_simpleName);
            this.error(_builder.toString(), (EStructuralFeature)ProtelisPackage.Literals.JAVA_IMPORT__IMPORTED_MEMBER_NAME);
        }
    }

    private Iterable<JvmFeature> autoImports(Notifier context) {
        Functions.Function1 _function = it -> {
            JvmType _findDeclaredType = this.references.findDeclaredType(it, context);
            return (JvmDeclaredType)_findDeclaredType;
        };
        Functions.Function1 _function_1 = it -> it.getAllFeatures();
        return IterableExtensions.flatMap((Iterable)IterableExtensions.map(AUTO_IMPORT, (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    @Check
    public void importOfAutomaticallyImportedClass(JavaImport javaImport) {
        boolean _not;
        Map<JvmFeature, JvmFeature> shadow = this.shadows(javaImport);
        boolean _isEmpty = shadow.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            BiConsumer<JvmFeature, JvmFeature> _function = (manual, auto) -> {
                StringConcatenation _builder = new StringConcatenation();
                String _qualifiedName = manual.getQualifiedName();
                _builder.append(_qualifiedName);
                _builder.append(" shadows automatically imported ");
                String _qualifiedName_1 = auto.getQualifiedName();
                _builder.append(_qualifiedName_1);
                this.info(_builder.toString(), (EStructuralFeature)ProtelisPackage.Literals.JAVA_IMPORT__IMPORTED_TYPE);
            };
            shadow.forEach(_function);
        }
    }

    private Map<JvmFeature, JvmFeature> shadows(JavaImport javaImport) {
        LinkedHashMap _xblockexpression = null;
        Iterable<JvmFeature> automaticallyImported = this.autoImports((Notifier)javaImport);
        LinkedHashMap shade = CollectionLiterals.newLinkedHashMap();
        Consumer<JvmFeature> _function = manual -> {
            Functions.Function1 _function_1 = it -> {
                String _simpleName = it.getSimpleName();
                String _simpleName_1 = manual.getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)_simpleName_1);
            };
            JvmFeature shadowed = (JvmFeature)IterableExtensions.findFirst((Iterable)automaticallyImported, (Functions.Function1)_function_1);
            if (shadowed != null) {
                shade.put(manual, shadowed);
            }
        };
        ProtelisExtensions.importedEntities(javaImport).forEach(_function);
        _xblockexpression = shade;
        return _xblockexpression;
    }

    @Check
    public void invokeLambdaWithCorrectNumberOfArguments(Expression invoke) {
        if (invoke.getName() == null && invoke.getElements().size() == 2 && invoke.getElements().get(0) instanceof Lambda && invoke.getElements().get(1) instanceof InvocationArguments) {
            boolean matches;
            EObject _get = (EObject)invoke.getElements().get(0);
            Lambda left = (Lambda)_get;
            EObject _get_1 = (EObject)invoke.getElements().get(1);
            InvocationArguments args = (InvocationArguments)_get_1;
            int _xifexpression = 0;
            _xifexpression = args == null || args.getArgs() == null ? 0 : args.getArgs().getArgs().size();
            int _xifexpression_1 = 0;
            KotlinStyleLambda _lastArg = args.getLastArg();
            boolean _tripleEquals = _lastArg == null;
            _xifexpression_1 = _tripleEquals ? 0 : 1;
            int provided = _xifexpression + _xifexpression_1;
            boolean _switchResult = false;
            boolean _matched = false;
            if (left instanceof OldShortLambda) {
                _matched = true;
                boolean bl = _switchResult = provided == 1;
            }
            if (!_matched && left instanceof OldLongLambda) {
                int _size;
                boolean _tripleEquals_1;
                _matched = true;
                boolean _xifexpression_2 = false;
                VarDefList _args = ((OldLongLambda)left).getArgs();
                boolean bl = _tripleEquals_1 = _args == null;
                _xifexpression_2 = _tripleEquals_1 ? provided == 0 : (_size = ((OldLongLambda)left).getArgs().getArgs().size()) == provided;
                _switchResult = _xifexpression_2;
            }
            if (!_matched && left instanceof ShortLambda) {
                _matched = true;
                boolean bl = _switchResult = provided == 0 || provided == 1;
            }
            if (!_matched && left instanceof LongLambda) {
                _matched = true;
                int _size = ((LongLambda)left).getArgs().getArgs().size();
                boolean bl = _switchResult = _size == provided;
            }
            if (!(matches = _switchResult)) {
                this.error("Arguments provided for invocation do not match lambda parameters", invoke, null);
            }
        }
    }

    private void error(String message, EObject target) {
        this.error(message, target, null);
    }

    private void warning(String message, EObject target) {
        this.warning(message, target, null);
    }

    @Check
    public void discourageDotApply(Expression methodCall) {
        EObject _get;
        MethodCall call;
        String _name_1;
        boolean _equals_1;
        String _name = methodCall.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)".");
        if (_equals && (_equals_1 = Objects.equal((Object)(_name_1 = (call = (MethodCall)(_get = (EObject)methodCall.getElements().get(1))).getName()), (Object)"apply"))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<invokable>.apply(...) is discouraged, prefer direct invocation: <invokable>(...)");
            this.warning(_builder.toString(), call);
        }
    }

    @Check
    public void reassignIsBadPractice(Assignment assignment) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Reassigning variables such as ");
        String _name = assignment.getRefVar().getName();
        _builder.append(_name);
        _builder.append(" is discouraged and may be dropped in a future release of Protelis. Prefer a functional approach.");
        this.warning(_builder.toString(), assignment);
    }

    @Check
    public void uselessModule(ProtelisModule module) {
        boolean _tripleEquals;
        Block _program = module.getProgram();
        boolean bl = _tripleEquals = _program == null;
        if (_tripleEquals && (module.getDefinitions() == null || IterableExtensions.findFirst(module.getDefinitions(), it -> it.isPublic()) == null)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Module ");
            String _elvis = null;
            String _name = module.getName();
            _elvis = _name != null ? _name : "anonymous";
            _builder.append(_elvis);
            _builder.append(" is useless, it does not contain a program nor a public function");
            this.warning(_builder.toString(), module);
        }
    }

    @Check
    public void appropriateUseOfIt(It it) {
        int shortLambdaParents = 0;
        EObject parent = it.eContainer();
        while (shortLambdaParents < 2 && parent != null) {
            int _shortLambdaParents = shortLambdaParents;
            int _xifexpression = 0;
            _xifexpression = parent instanceof ShortLambda ? 1 : 0;
            shortLambdaParents = _shortLambdaParents + _xifexpression;
            parent = parent.eContainer();
        }
        switch (shortLambdaParents) {
            case 0: {
                this.error("it can only be used inside short lambdas (i.e. { it + 1 })", it);
                break;
            }
            case 2: {
                this.error("Ambiguous use of it due to nested short lambdas: refactor with explicit names, e.g. rewrite { it + 1 } as { a -> a + 1 }", it);
            }
        }
    }

    @Check
    public void functionCouldBeRewrittenAsSingleExpression(FunctionDef function) {
        if (function.getBody() != null && function.getBody().getStatements().size() == 1) {
            String name = function.getName();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(name);
            _builder.append(" (<params>) { <body> } has a single expression and could be rewritten as ");
            _builder.append(name);
            _builder.append(" (<params>) = <body>");
            this.info(_builder.toString(), (EObject)function.getBody().getStatements().get(0), null);
        }
    }

    @Check
    public void builtinVersionShouldBeCompatible(ProtelisModule module) {
        JvmType type = this.references.findDeclaredType("org.protelis.Builtins", (Notifier)module);
        if (type instanceof JvmDeclaredType) {
            boolean _not;
            Object _value = this.context.getValue(this.qualifiedNameConverter.toQualifiedName("org.protelis.Builtins"));
            Class builtinsResolvedClass = (Class)_value;
            Field[] candidateFields = builtinsResolvedClass.getDeclaredFields();
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)"MINIMUM_PARSER_VERSION");
            };
            Field min = (Field)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)candidateFields)), (Functions.Function1)_function);
            List<Integer> minVersion = this.versionFromStaticField(min);
            if (minVersion == null) {
                this.warning("Builtins do not declare a minimum version, Protelis plugin / parser and interpreter versions may be mismatched", module, FIRST_LINE);
            }
            List<Integer> _elvis = null;
            _elvis = minVersion != null ? minVersion : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{0, 0, 0}));
            minVersion = _elvis;
            Functions.Function1 _function_1 = it -> {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)"MAXIMUM_PARSER_VERSION");
            };
            Field max = (Field)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)candidateFields)), (Functions.Function1)_function_1);
            List<Integer> maxVersion = this.versionFromStaticField(max);
            if (maxVersion == null) {
                this.warning("Builtins do not declare a maximum version", module, FIRST_LINE);
            }
            List<Integer> _elvis_1 = null;
            _elvis_1 = maxVersion != null ? maxVersion : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE}));
            maxVersion = _elvis_1;
            boolean bl = _not = !this.versionMinorEqual((Iterable<Integer>)MY_VERSION, (Iterable<Integer>)maxVersion) || !this.versionMinorEqual((Iterable<Integer>)minVersion, (Iterable<Integer>)MY_VERSION);
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Protelis plugin / parser and interpreter versions mismatch. Expected parser in range ");
                _builder.append(minVersion);
                _builder.append(" to ");
                _builder.append(maxVersion);
                _builder.append(", found version ");
                _builder.append(MY_VERSION);
                this.warning(_builder.toString(), module, FIRST_LINE);
            }
        }
    }

    private List<Integer> versionFromStaticField(Field field) {
        Object _get;
        List fieldValue;
        block4: {
            try {
                if (field != null) break block4;
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        if (Modifier.isStatic(field.getModifiers()) && List.class.isAssignableFrom(field.getType()) && (fieldValue = (List)(_get = field.get(null))).size() == 3 && IterableExtensions.forall((Iterable)fieldValue, it -> Integer.class.isAssignableFrom(it.getClass()))) {
            return fieldValue;
        }
        return null;
    }

    private boolean versionMinorEqual(Iterable<Integer> a, Iterable<Integer> b) {
        return IterableExtensions.isEmpty(a) && IterableExtensions.isEmpty(b) || ((Integer)IterableExtensions.head(a)).compareTo((Integer)IterableExtensions.head(b)) < 0 || Objects.equal((Object)IterableExtensions.head(a), (Object)IterableExtensions.head(b)) && this.versionMinorEqual(IterableExtensions.drop(a, (int)1), IterableExtensions.drop(b, (int)1));
    }
}

