/*
 * Decompiled with CFR 0.152.
 */
package org.puimula.libvoikko;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ByteArray
extends PointerType {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static String n2s(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, UTF8);
    }

    public static byte[] s2n(String string) {
        if (string == null) {
            return null;
        }
        byte[] stringBytes = string.getBytes(UTF8);
        byte[] allBytes = new byte[stringBytes.length + 1];
        System.arraycopy(stringBytes, 0, allBytes, 0, stringBytes.length);
        return allBytes;
    }

    public static ByteBuffer s2bb(String string) {
        if (string == null) {
            return null;
        }
        byte[] stringBytes = string.getBytes(UTF8);
        ByteBuffer allBytes = ByteBuffer.allocateDirect(stringBytes.length);
        allBytes.position(0);
        allBytes.put(stringBytes);
        return allBytes;
    }

    public String toString() {
        if (this.getPointer() == Pointer.NULL) {
            return null;
        }
        return ByteArray.n2s(this.getPointer().getByteArray(0L, (int)this.getPointer().indexOf(0L, (byte)0)));
    }
}

