/*
 * Decompiled with CFR 0.152.
 */
package org.puimula.libvoikko;

import java.util.List;

public class GrammarError {
    private final int errorCode;
    private final int startPos;
    private final int errorLen;
    private final List<String> suggestions;
    private final String shortDescription;

    public GrammarError(int errorCode, int startPos, int errorLen, List<String> suggestions, String shortDescription) {
        this.errorCode = errorCode;
        this.startPos = startPos;
        this.errorLen = errorLen;
        this.suggestions = suggestions;
        this.shortDescription = shortDescription;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getErrorLen() {
        return this.errorLen;
    }

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[code=");
        sb.append(this.errorCode);
        sb.append(", level=0, descr=\"\", stpos=");
        sb.append(this.startPos);
        sb.append(", len=");
        sb.append(this.errorLen);
        sb.append(", suggs={");
        boolean first = true;
        for (String suggestion : this.suggestions) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"");
            sb.append(suggestion);
            sb.append("\"");
        }
        sb.append("}]");
        return sb.toString();
    }
}

