/*
 * Decompiled with CFR 0.152.
 */
package org.puimula.libvoikko;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.puimula.libvoikko.Analysis;
import org.puimula.libvoikko.ByteArray;
import org.puimula.libvoikko.Dictionary;
import org.puimula.libvoikko.GrammarError;
import org.puimula.libvoikko.Libvoikko;
import org.puimula.libvoikko.Sentence;
import org.puimula.libvoikko.SentenceStartType;
import org.puimula.libvoikko.SizeT;
import org.puimula.libvoikko.SizeTByReference;
import org.puimula.libvoikko.SuggestionStrategy;
import org.puimula.libvoikko.Token;
import org.puimula.libvoikko.TokenType;
import org.puimula.libvoikko.VoikkoException;

public class Voikko {
    private static Libvoikko library = null;
    private static final String[] LIBRARY_NAMES = new String[]{"libvoikko.so.1", "voikko-1", "voikko"};
    private Libvoikko.VoikkoHandle handle;

    private static NativeLibrary tryLoadLibrary(String libName) {
        try {
            return NativeLibrary.getInstance((String)libName);
        }
        catch (UnsatisfiedLinkError e) {
            return null;
        }
    }

    private static synchronized Libvoikko getLib() {
        if (library == null) {
            for (String libName : LIBRARY_NAMES) {
                NativeLibrary nativeLibrary = Voikko.tryLoadLibrary(libName);
                if (nativeLibrary == null) continue;
                library = (Libvoikko)Native.loadLibrary((String)nativeLibrary.getFile().getPath(), Libvoikko.class);
                return library;
            }
            throw new UnsatisfiedLinkError("Could not load the native component of libvoikko. Please see http://voikko.puimula.org/java.html for more information.");
        }
        return library;
    }

    public Voikko(String language) {
        this(language, null);
    }

    public Voikko(String language, String path) {
        PointerByReference error = new PointerByReference();
        this.handle = Voikko.getLib().voikkoInit(error, ByteArray.s2n(language), ByteArray.s2n(path));
        if (this.handle == null && error.getPointer() != Pointer.NULL) {
            this.handle = null;
            throw new VoikkoException(this.stringFromPointer(error.getPointer().getPointer(0L)));
        }
    }

    public synchronized void terminate() {
        if (this.handle != null) {
            Voikko.getLib().voikkoTerminate(this.handle);
            this.handle = null;
        }
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    public synchronized boolean spell(String word) {
        this.requireValidHandle();
        if (!this.isValidInput(word)) {
            return false;
        }
        int spellResult = Voikko.getLib().voikkoSpellCstr(this.handle, ByteArray.s2n(word));
        return spellResult == 1;
    }

    private boolean isValidInput(String word) {
        return word.indexOf(0) == -1;
    }

    private void requireValidHandle() {
        if (this.handle == null) {
            throw new VoikkoException("Attempt to use Voikko instance after terminate() was called");
        }
    }

    public static List<Dictionary> listDicts() {
        return Voikko.listDicts(null);
    }

    public static List<Dictionary> listDicts(String path) {
        Libvoikko lib = Voikko.getLib();
        Pointer cDicts = lib.voikko_list_dicts(ByteArray.s2n(path));
        Pointer[] pointerArray = cDicts.getPointerArray(0L);
        ArrayList<Dictionary> dicts = new ArrayList<Dictionary>(pointerArray.length);
        for (Pointer cDict : pointerArray) {
            dicts.add(new Dictionary(lib.voikko_dict_language(cDict).toString(), lib.voikko_dict_script(cDict).toString(), lib.voikko_dict_variant(cDict).toString(), lib.voikko_dict_description(cDict).toString()));
        }
        lib.voikko_free_dicts(cDicts);
        return dicts;
    }

    public synchronized List<String> suggest(String word) {
        this.requireValidHandle();
        if (!this.isValidInput(word)) {
            return Collections.emptyList();
        }
        Pointer voikkoSuggestCstr = Voikko.getLib().voikkoSuggestCstr(this.handle, ByteArray.s2n(word));
        if (voikkoSuggestCstr == null) {
            return Collections.emptyList();
        }
        Pointer[] pointerArray = voikkoSuggestCstr.getPointerArray(0L);
        ArrayList<String> suggestions = new ArrayList<String>(pointerArray.length);
        for (Pointer cStr : pointerArray) {
            suggestions.add(this.stringFromPointer(cStr));
        }
        Voikko.getLib().voikkoFreeCstrArray(voikkoSuggestCstr);
        return suggestions;
    }

    private String stringFromPointer(Pointer cStr) {
        return ByteArray.n2s(cStr.getByteArray(0L, (int)cStr.indexOf(0L, (byte)0)));
    }

    public synchronized List<GrammarError> grammarErrors(String text, String language) {
        this.requireValidHandle();
        ArrayList<GrammarError> errorList = new ArrayList<GrammarError>();
        if (!this.isValidInput(text)) {
            return errorList;
        }
        int offset = 0;
        for (String paragraph : text.replace("\r", "\n").split("\\n")) {
            this.appendErrorsFromParagraph(errorList, paragraph, offset, language);
            offset += paragraph.length() + 1;
        }
        return errorList;
    }

    private void appendErrorsFromParagraph(List<GrammarError> errorList, String paragraph, int offset, String language) {
        int paragraphLen = ByteArray.s2n(paragraph).length - 1;
        Libvoikko lib = Voikko.getLib();
        int skipErrors = 0;
        Libvoikko.VoikkoGrammarError cError;
        while ((cError = lib.voikkoNextGrammarErrorCstr(this.handle, ByteArray.s2n(paragraph), new SizeT(paragraphLen), new SizeT(0L), skipErrors)) != null) {
            errorList.add(this.getGrammarError(cError, offset, language));
            lib.voikkoFreeGrammarError(cError);
            ++skipErrors;
        }
        return;
    }

    private GrammarError getGrammarError(Libvoikko.VoikkoGrammarError cError, int offset, String language) {
        List<String> suggestions;
        Libvoikko lib = Voikko.getLib();
        int errorCode = lib.voikkoGetGrammarErrorCode(cError);
        int startPos = lib.voikkoGetGrammarErrorStartPos(cError).intValue();
        int errorLength = lib.voikkoGetGrammarErrorLength(cError).intValue();
        Pointer cSuggestions = lib.voikkoGetGrammarErrorSuggestions(cError);
        if (cSuggestions == null) {
            suggestions = Collections.emptyList();
        } else {
            Pointer[] pointerArray = cSuggestions.getPointerArray(0L);
            suggestions = new ArrayList(pointerArray.length);
            for (Pointer cStr : pointerArray) {
                suggestions.add(this.stringFromPointer(cStr));
            }
        }
        Pointer cShortDescription = lib.voikkoGetGrammarErrorShortDescription(cError, ByteArray.s2n(language));
        String shortDescription = this.stringFromPointer(cShortDescription);
        lib.voikkoFreeErrorMessageCstr(cShortDescription);
        return new GrammarError(errorCode, offset + startPos, errorLength, suggestions, shortDescription);
    }

    public synchronized List<Analysis> analyze(String word) {
        this.requireValidHandle();
        ArrayList<Analysis> analysisList = new ArrayList<Analysis>();
        if (!this.isValidInput(word)) {
            return analysisList;
        }
        Libvoikko lib = Voikko.getLib();
        Pointer cAnalysisList = lib.voikkoAnalyzeWordCstr(this.handle, ByteArray.s2n(word));
        if (cAnalysisList == null) {
            return analysisList;
        }
        for (Pointer cAnalysis : cAnalysisList.getPointerArray(0L)) {
            Pointer cKeys = lib.voikko_mor_analysis_keys(cAnalysis);
            Analysis analysis = new Analysis();
            for (Pointer cKey : cKeys.getPointerArray(0L)) {
                String key = this.stringFromPointer(cKey);
                ByteArray value = lib.voikko_mor_analysis_value_cstr(cAnalysis, ByteArray.s2n(key));
                analysis.put(key, value.toString());
                lib.voikko_free_mor_analysis_value_cstr(value);
            }
            analysisList.add(analysis);
        }
        lib.voikko_free_mor_analysis(cAnalysisList);
        return analysisList;
    }

    public synchronized List<Token> tokens(String text) {
        this.requireValidHandle();
        ArrayList<Token> allTokens = new ArrayList<Token>();
        int lastStart = 0;
        int i = this.indexOfSpecialUnknown(text, 0);
        while (i != -1) {
            allTokens.addAll(this.tokensNonNull(text.substring(lastStart, i), lastStart));
            allTokens.add(new Token(TokenType.UNKNOWN, Character.toString(text.charAt(i)), i));
            lastStart = i + 1;
            i = this.indexOfSpecialUnknown(text, i + 1);
        }
        allTokens.addAll(this.tokensNonNull(text.substring(lastStart), lastStart));
        return allTokens;
    }

    private int indexOfSpecialUnknown(String text, int startFrom) {
        int len = text.length();
        for (int i = startFrom; i < len; ++i) {
            char c = text.charAt(i);
            if (c != '\u0000' && (c < '\ud800' || c > '\udfff')) continue;
            return i;
        }
        return -1;
    }

    private List<Token> tokensNonNull(String text, int lastStart) {
        int tokenBytes;
        Libvoikko lib = Voikko.getLib();
        ArrayList<Token> result = new ArrayList<Token>();
        ByteBuffer textBytes = ByteArray.s2bb(text);
        int bytesStart = 0;
        int textStart = 0;
        SizeTByReference tokenLenByRef = new SizeTByReference();
        for (int bytesLen = textBytes.capacity(); bytesLen > 0; bytesLen -= tokenBytes) {
            textBytes.position(bytesStart);
            int tokenTypeInt = lib.voikkoNextTokenCstr(this.handle, textBytes, new SizeT(bytesLen), tokenLenByRef);
            int tokenLen = tokenLenByRef.getValue().intValue();
            TokenType tokenType = TokenType.values()[tokenTypeInt];
            String tokenText = text.substring(textStart, textStart + tokenLen);
            result.add(new Token(tokenType, tokenText, lastStart + textStart));
            textStart += tokenText.length();
            tokenBytes = ByteArray.s2n(tokenText).length - 1;
            bytesStart += tokenBytes;
        }
        return result;
    }

    public synchronized List<Sentence> sentences(String text) {
        this.requireValidHandle();
        Libvoikko lib = Voikko.getLib();
        ArrayList<Sentence> result = new ArrayList<Sentence>();
        if (!this.isValidInput(text)) {
            result.add(new Sentence(text, SentenceStartType.NONE));
            return result;
        }
        byte[] textBytes = ByteArray.s2n(text);
        int textLen = textBytes.length - 1;
        SizeTByReference sentenceLenByRef = new SizeTByReference();
        while (textLen > 0) {
            int sentenceTypeInt = lib.voikkoNextSentenceStartCstr(this.handle, textBytes, new SizeT(textLen), sentenceLenByRef);
            int sentenceLen = sentenceLenByRef.getValue().intValue();
            SentenceStartType sentenceType = SentenceStartType.values()[sentenceTypeInt];
            String tokenText = text.substring(0, sentenceLen);
            result.add(new Sentence(tokenText, sentenceType));
            text = text.substring(sentenceLen);
            textBytes = ByteArray.s2n(text);
            textLen = textBytes.length - 1;
        }
        return result;
    }

    public synchronized String getHyphenationPattern(String word) {
        this.requireValidHandle();
        if (!this.isValidInput(word)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < word.length(); ++i) {
                sb.append(" ");
            }
            return sb.toString();
        }
        ByteArray cPattern = Voikko.getLib().voikkoHyphenateCstr(this.handle, ByteArray.s2n(word));
        String pattern = cPattern.toString();
        Voikko.getLib().voikkoFreeCstr(cPattern);
        return pattern;
    }

    public String hyphenate(String word) {
        String pattern = this.getHyphenationPattern(word);
        StringBuilder hyphenated = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char patternC = pattern.charAt(i);
            if (patternC == ' ') {
                hyphenated.append(word.charAt(i));
                continue;
            }
            if (patternC == '-') {
                hyphenated.append('-');
                hyphenated.append(word.charAt(i));
                continue;
            }
            if (patternC != '=') continue;
            hyphenated.append('-');
        }
        return hyphenated.toString();
    }

    private static int boolToInt(boolean value) {
        return value ? 1 : 0;
    }

    private synchronized void setBoolOption(int option, boolean value) {
        this.requireValidHandle();
        int result = Voikko.getLib().voikkoSetBooleanOption(this.handle, option, Voikko.boolToInt(value));
        if (result == 0) {
            throw new VoikkoException("Could not set boolean option " + option + " to value " + value + ".");
        }
    }

    public void setIgnoreDot(boolean value) {
        this.setBoolOption(0, value);
    }

    public void setIgnoreNumbers(boolean value) {
        this.setBoolOption(1, value);
    }

    public void setIgnoreUppercase(boolean value) {
        this.setBoolOption(3, value);
    }

    public void setAcceptFirstUppercase(boolean value) {
        this.setBoolOption(6, value);
    }

    public void setAcceptAllUppercase(boolean value) {
        this.setBoolOption(7, value);
    }

    public void setIgnoreNonwords(boolean value) {
        this.setBoolOption(10, value);
    }

    public void setAcceptExtraHyphens(boolean value) {
        this.setBoolOption(11, value);
    }

    public void setAcceptMissingHyphens(boolean value) {
        this.setBoolOption(12, value);
    }

    public void setAcceptTitlesInGc(boolean value) {
        this.setBoolOption(13, value);
    }

    public void setAcceptUnfinishedParagraphsInGc(boolean value) {
        this.setBoolOption(14, value);
    }

    public void setAcceptBulletedListsInGc(boolean value) {
        this.setBoolOption(16, value);
    }

    public void setNoUglyHyphenation(boolean value) {
        this.setBoolOption(4, value);
    }

    public void setHyphenateUnknownWords(boolean value) {
        this.setBoolOption(15, value);
    }

    private synchronized void setIntegerOption(int option, int value) {
        this.requireValidHandle();
        int result = Voikko.getLib().voikkoSetIntegerOption(this.handle, option, value);
        if (result == 0) {
            throw new VoikkoException("Could not set integer option " + option + " to value " + value + ".");
        }
    }

    public void setMinHyphenatedWordLength(int length) {
        this.setIntegerOption(9, length);
    }

    public void setSpellerCacheSize(int sizeParam) {
        this.setIntegerOption(17, sizeParam);
    }

    public void setSuggestionStrategy(SuggestionStrategy suggestionStrategy) {
        switch (suggestionStrategy) {
            case OCR: {
                this.setBoolOption(8, true);
                break;
            }
            case TYPO: {
                this.setBoolOption(8, false);
            }
        }
    }

    public static void addLibraryPath(String libraryPath) {
        for (String libraryName : LIBRARY_NAMES) {
            NativeLibrary.addSearchPath((String)libraryName, (String)libraryPath);
        }
    }
}

