/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.common.internal.font;

import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.radiance.common.api.font.FontPolicy;
import org.pushingpixels.radiance.common.api.font.FontSet;
import org.pushingpixels.radiance.common.internal.font.FontSets;

public class DefaultGnomeFontPolicy
implements FontPolicy {
    private static double fontScale;

    @Override
    public FontSet getFontSet() {
        double dsize;
        Object defaultGtkFontName = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Gtk/FontName");
        Object family = "";
        int style = 0;
        int size = 10;
        if (defaultGtkFontName instanceof String) {
            String pangoName = (String)defaultGtkFontName;
            StringTokenizer tok = new StringTokenizer(pangoName);
            while (tok.hasMoreTokens()) {
                String word = tok.nextToken();
                boolean allDigits = true;
                for (int i = 0; i < word.length(); ++i) {
                    if (Character.isDigit(word.charAt(i))) continue;
                    allDigits = false;
                    break;
                }
                if (word.equalsIgnoreCase("italic")) {
                    style |= 2;
                    continue;
                }
                if (word.equalsIgnoreCase("bold")) {
                    style |= 1;
                    continue;
                }
                if (allDigits) {
                    try {
                        size = Integer.parseInt(word);
                    }
                    catch (NumberFormatException nfe) {
                        size = 10;
                    }
                    continue;
                }
                if (((String)family).length() > 0) {
                    family = (String)family + " ";
                }
                family = (String)family + word;
            }
        }
        if ((size = (int)((dsize = (double)size * DefaultGnomeFontPolicy.getPointsToPixelsRatio()) + 0.5)) < 1) {
            size = 1;
        }
        if (((String)family).length() == 0) {
            family = "sans";
        }
        Font controlFont = null;
        String fcFamilyLC = ((String)family).toLowerCase();
        try {
            Class<?> fontManagerClass = Class.forName("sun.font.FontManager");
            Method mapFcMethod = fontManagerClass.getMethod("mapFcName", String.class);
            Object mapFcMethodResult = mapFcMethod.invoke(null, fcFamilyLC);
            if (mapFcMethodResult != null) {
                Method getFontConfigFUIRMethod = fontManagerClass.getMethod("getFontConfigFUIR", String.class, Integer.TYPE, Integer.TYPE);
                controlFont = (Font)getFontConfigFUIRMethod.invoke(null, fcFamilyLC, style, size);
            } else {
                FontUIResource font = new FontUIResource((String)family, style, size);
                Method getCompositeFontUIResourceMethod = fontManagerClass.getMethod("getCompositeFontUIResource", Font.class);
                controlFont = (Font)getCompositeFontUIResourceMethod.invoke(null, font);
            }
        }
        catch (Throwable t) {
            controlFont = new Font((String)family, style, size);
        }
        return FontSets.createDefaultFontSet(controlFont);
    }

    public static double getPointsToPixelsRatio() {
        int dpi = 96;
        Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
        if (value instanceof Integer) {
            dpi = (Integer)value / 1024;
            if (dpi == -1) {
                dpi = 96;
            }
            if (dpi < 50) {
                dpi = 50;
            }
            return (double)dpi / 72.0;
        }
        return fontScale;
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        AffineTransform at = gc.getNormalizingTransform();
        fontScale = at.getScaleY();
    }
}

