/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.common.internal.font;

import java.awt.Font;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.radiance.common.api.font.FontSet;

public class RadianceFontSet
implements FontSet {
    private FontSet systemFontSet;

    public RadianceFontSet(FontSet systemFontSet) {
        this.systemFontSet = systemFontSet;
    }

    private FontUIResource getRadianceFont(FontUIResource systemFont) {
        return systemFont;
    }

    private FontUIResource getRadianceFont(FontUIResource systemFont, boolean toBoldify, int extraFontSize) {
        Font derived;
        boolean isOrigItalic = systemFont.isItalic();
        int newStyle = systemFont.getStyle();
        if (toBoldify) {
            newStyle = isOrigItalic ? 3 : 1;
        }
        if ((derived = systemFont.deriveFont((float)(systemFont.getSize() + extraFontSize)).deriveFont(newStyle)) instanceof FontUIResource) {
            return (FontUIResource)derived;
        }
        return new FontUIResource(derived);
    }

    @Override
    public FontUIResource getControlFont() {
        return this.getRadianceFont(this.systemFontSet.getControlFont());
    }

    @Override
    public FontUIResource getMenuFont() {
        return this.getRadianceFont(this.systemFontSet.getMenuFont());
    }

    @Override
    public FontUIResource getMessageFont() {
        return this.getRadianceFont(this.systemFontSet.getMessageFont());
    }

    @Override
    public FontUIResource getSmallFont() {
        return this.getRadianceFont(this.systemFontSet.getSmallFont(), false, 1);
    }

    @Override
    public FontUIResource getTitleFont() {
        return this.getRadianceFont(this.systemFontSet.getTitleFont());
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return this.getRadianceFont(this.systemFontSet.getWindowTitleFont(), true, 1);
    }
}

