/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.neon.internal.contrib.intellij;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Map;

class GraphicsConfig {
    private final Graphics2D myG;
    private final Map myHints;
    private final Composite myComposite;

    public GraphicsConfig(Graphics g) {
        this.myG = (Graphics2D)g;
        this.myHints = (Map)this.myG.getRenderingHints().clone();
        this.myComposite = this.myG.getComposite();
    }

    public GraphicsConfig setAntialiasing(boolean on) {
        this.myG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, on ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        return this;
    }

    public GraphicsConfig setAlpha(float alpha) {
        this.myG.setComposite(AlphaComposite.getInstance(3, alpha));
        return this;
    }

    public Graphics2D getG() {
        return this.myG;
    }

    public void restore() {
        this.myG.setRenderingHints(this.myHints);
        this.myG.setComposite(this.myComposite);
    }
}

