/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.neon.internal.contrib.intellij;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.util.Locale;
import java.util.WeakHashMap;

public class UIUtil {
    private static final String JAVA_VENDOR = UIUtil.getSystemProperty("java.vendor");
    public static final boolean IS_VENDOR_APPLE = UIUtil.containsIgnoreCase(JAVA_VENDOR, "Apple");
    private static Double cachedScaleFactorReply = null;

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static boolean containsIgnoreCase(String str, String searchFor) {
        return str != null && str.toUpperCase(Locale.ENGLISH).contains(searchFor.toUpperCase(Locale.ENGLISH));
    }

    public static double getScaleFactor(Graphics2D graphics) {
        return DetectRetinaKit.getScaleFactor(graphics);
    }

    public static double getScaleFactor() {
        if (cachedScaleFactorReply != null) {
            return cachedScaleFactorReply;
        }
        double result = GraphicsEnvironment.isHeadless() ? 1.0 : DetectRetinaKit.getScaleFactor();
        cachedScaleFactorReply = result;
        return cachedScaleFactorReply;
    }

    private static final class DetectRetinaKit {
        private static final WeakHashMap<GraphicsDevice, Double> devicesScaleFactorCacheMap = new WeakHashMap();

        private DetectRetinaKit() {
        }

        private static double getScaleFactorModern(GraphicsDevice device) {
            GraphicsConfiguration graphicsConfig = device.getDefaultConfiguration();
            AffineTransform tx = graphicsConfig.getDefaultTransform();
            double scaleX = tx.getScaleX();
            double scaleY = tx.getScaleY();
            return Math.max(scaleX, scaleY);
        }

        private static double getScaleFactor(GraphicsDevice device) {
            if (IS_VENDOR_APPLE) {
                return 1.0;
            }
            if (devicesScaleFactorCacheMap.containsKey(device)) {
                return devicesScaleFactorCacheMap.get(device);
            }
            double result = DetectRetinaKit.getScaleFactorModern(device);
            devicesScaleFactorCacheMap.put(device, result);
            return result;
        }

        private static double getScaleFactor(Graphics2D g) {
            GraphicsDevice device = g.getDeviceConfiguration().getDevice();
            return DetectRetinaKit.getScaleFactor(device);
        }

        private static double getScaleFactor() {
            GraphicsDevice[] devices;
            if (IS_VENDOR_APPLE) {
                return 1.0;
            }
            double result = 1.0;
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice device : devices = e.getScreenDevices()) {
                result = Math.max(result, DetectRetinaKit.getScaleFactor(device));
            }
            return result;
        }
    }
}

