/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.neon.internal.font;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.neon.font.FontSet;

public final class FontSets {
    private static FontSet logicalFontSet;

    private FontSets() {
    }

    public static FontSet createDefaultFontSet(Font controlFont) {
        return FontSets.createDefaultFontSet(controlFont, null);
    }

    public static FontSet createDefaultFontSet(Font controlFont, Font menuFont) {
        return FontSets.createDefaultFontSet(controlFont, menuFont, null, null, null, null);
    }

    public static FontSet createDefaultFontSet(Font controlFont, Font menuFont, Font titleFont) {
        return FontSets.createDefaultFontSet(controlFont, menuFont, titleFont, null, null, null);
    }

    public static FontSet createDefaultFontSet(Font controlFont, Font menuFont, Font titleFont, Font messageFont, Font smallFont, Font windowTitleFont) {
        return new DefaultFontSet(controlFont, menuFont, titleFont, messageFont, smallFont, windowTitleFont);
    }

    public static FontSet getLogicalFontSet() {
        if (logicalFontSet == null) {
            logicalFontSet = new LogicalFontSet();
        }
        return logicalFontSet;
    }

    private static final class LogicalFontSet
    implements FontSet {
        private FontUIResource controlFont;
        private FontUIResource titleFont;
        private FontUIResource systemFont;
        private FontUIResource smallFont;

        private LogicalFontSet() {
        }

        @Override
        public FontUIResource getControlFont() {
            if (this.controlFont == null) {
                this.controlFont = new FontUIResource(Font.getFont("swing.plaf.metal.controlFont", new Font("Dialog", 0, 12)));
            }
            return this.controlFont;
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.getControlFont();
        }

        @Override
        public FontUIResource getTitleFont() {
            if (this.titleFont == null) {
                this.titleFont = new FontUIResource(this.getControlFont().deriveFont(1));
            }
            return this.titleFont;
        }

        @Override
        public FontUIResource getSmallFont() {
            if (this.smallFont == null) {
                this.smallFont = new FontUIResource(Font.getFont("swing.plaf.metal.smallFont", new Font("Dialog", 0, 10)));
            }
            return this.smallFont;
        }

        @Override
        public FontUIResource getMessageFont() {
            if (this.systemFont == null) {
                this.systemFont = new FontUIResource(Font.getFont("swing.plaf.metal.systemFont", new Font("Dialog", 0, 12)));
            }
            return this.systemFont;
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.getTitleFont();
        }
    }

    private static final class DefaultFontSet
    implements FontSet {
        private final FontUIResource controlFont;
        private final FontUIResource menuFont;
        private final FontUIResource titleFont;
        private final FontUIResource messageFont;
        private final FontUIResource smallFont;
        private final FontUIResource windowTitleFont;

        public DefaultFontSet(Font controlFont, Font menuFont, Font titleFont, Font messageFont, Font smallFont, Font windowTitleFont) {
            this.controlFont = this.wrapIfNecessary(controlFont);
            this.menuFont = menuFont != null ? this.wrapIfNecessary(menuFont) : this.controlFont;
            this.titleFont = titleFont != null ? this.wrapIfNecessary(titleFont) : this.controlFont;
            this.messageFont = messageFont != null ? this.wrapIfNecessary(messageFont) : this.controlFont;
            this.smallFont = this.wrapIfNecessary(smallFont != null ? smallFont : controlFont.deriveFont(controlFont.getSize2D() - 2.0f));
            this.windowTitleFont = windowTitleFont != null ? this.wrapIfNecessary(windowTitleFont) : this.titleFont;
        }

        private FontUIResource wrapIfNecessary(Font font) {
            if (font instanceof DefaultUIResourceFont) {
                return (DefaultUIResourceFont)font;
            }
            return new FontUIResource(font);
        }

        @Override
        public FontUIResource getControlFont() {
            return this.controlFont;
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.menuFont;
        }

        @Override
        public FontUIResource getTitleFont() {
            return this.titleFont;
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.windowTitleFont;
        }

        @Override
        public FontUIResource getSmallFont() {
            return this.smallFont;
        }

        @Override
        public FontUIResource getMessageFont() {
            return this.messageFont;
        }
    }

    public static final class DefaultUIResourceFont
    extends FontUIResource
    implements UIResource {
        public DefaultUIResourceFont(Font font) {
            super(font);
        }

        public DefaultUIResourceFont(String name, int style, int size) {
            super(name, style, size);
        }

        @Override
        public Font deriveFont(AffineTransform trans) {
            return new DefaultUIResourceFont(super.deriveFont(trans));
        }

        @Override
        public Font deriveFont(float size) {
            return new DefaultUIResourceFont(super.deriveFont(size));
        }

        @Override
        public Font deriveFont(int style) {
            return new DefaultUIResourceFont(super.deriveFont(style));
        }

        @Override
        public Font deriveFont(int style, AffineTransform trans) {
            return new DefaultUIResourceFont(super.deriveFont(style, trans));
        }

        @Override
        public Font deriveFont(int style, float size) {
            return new DefaultUIResourceFont(super.deriveFont(style, size));
        }

        @Override
        public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
            return new DefaultUIResourceFont(super.deriveFont(attributes));
        }
    }
}

