/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.EbonyColorScheme;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;

abstract class GraphiteBaseSkin
extends SubstanceSkin {
    SubstanceColorSchemeBundle defaultSchemeBundle;

    public GraphiteBaseSkin() {
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/graphite.colorschemes");
        SubstanceColorScheme activeScheme = schemes.get("Graphite Active");
        SubstanceColorScheme selectedDisabledScheme = schemes.get("Graphite Selected Disabled");
        SubstanceColorScheme selectedScheme = schemes.get("Graphite Selected");
        SubstanceColorScheme disabledScheme = schemes.get("Graphite Disabled");
        SubstanceColorScheme enabledScheme = schemes.get("Graphite Enabled");
        SubstanceColorScheme backgroundScheme = schemes.get("Graphite Background");
        this.defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        SubstanceColorScheme highlightScheme = schemes.get("Graphite Highlight");
        this.defaultSchemeBundle.registerHighlightAlpha(0.6f, ComponentState.ROLLOVER_UNSELECTED);
        this.defaultSchemeBundle.registerHighlightAlpha(0.8f, ComponentState.SELECTED);
        this.defaultSchemeBundle.registerHighlightAlpha(1.0f, ComponentState.ROLLOVER_SELECTED);
        this.defaultSchemeBundle.registerHighlightAlpha(0.75f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        this.defaultSchemeBundle.registerHighlightColorScheme(highlightScheme, ComponentState.ROLLOVER_UNSELECTED, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        SubstanceColorScheme borderScheme = schemes.get("Graphite Border");
        SubstanceColorScheme separatorScheme = schemes.get("Graphite Separator");
        this.defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)new EbonyColorScheme(), SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, ComponentState.getActiveStates());
        this.defaultSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        this.defaultSchemeBundle.registerColorScheme(separatorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme textHighlightScheme = schemes.get("Graphite Text Highlight");
        this.defaultSchemeBundle.registerColorScheme(textHighlightScheme, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        this.defaultSchemeBundle.registerColorScheme(highlightScheme, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        SubstanceColorScheme highlightMarkScheme = schemes.get("Graphite Highlight Mark");
        this.defaultSchemeBundle.registerColorScheme(highlightMarkScheme, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_MARK, ComponentState.getActiveStates());
        this.defaultSchemeBundle.registerColorScheme(highlightMarkScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED);
        this.defaultSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED);
        this.defaultSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_UNSELECTED);
        this.defaultSchemeBundle.registerAlpha(0.65f, ComponentState.DISABLED_SELECTED);
        this.defaultSchemeBundle.registerColorScheme(disabledScheme, ComponentState.DISABLED_UNSELECTED);
        this.defaultSchemeBundle.registerColorScheme(selectedDisabledScheme, ComponentState.DISABLED_SELECTED);
        this.defaultSchemeBundle.registerColorScheme(disabledScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        this.defaultSchemeBundle.registerColorScheme(highlightScheme, ComponentState.ROLLOVER_SELECTED);
        this.defaultSchemeBundle.registerColorScheme(selectedScheme, ComponentState.SELECTED);
        SubstanceColorScheme tabHighlightScheme = schemes.get("Graphite Tab Highlight");
        this.defaultSchemeBundle.registerColorScheme(tabHighlightScheme, SubstanceSlices.ColorSchemeAssociationKind.TAB, ComponentState.ROLLOVER_SELECTED);
        this.registerDecorationAreaSchemeBundle(this.defaultSchemeBundle, backgroundScheme, SubstanceSlices.DecorationAreaType.NONE);
        this.setTabFadeStart(0.18);
        this.setTabFadeEnd(0.18);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.borderPainter = new CompositeBorderPainter("Graphite", new DelegateBorderPainter("Graphite Outer", new ClassicBorderPainter(), -1, -1, -1, scheme -> scheme.shade(0.4f)), new DelegateBorderPainter("Graphite Inner", new ClassicBorderPainter(), -1593835521, -1862270977, -1593835521, scheme -> scheme.tint(0.25)));
        this.highlightBorderPainter = new ClassicBorderPainter();
    }
}

