/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.UIDefaults;
import org.pushingpixels.substance.api.SubstanceComponentPlugin;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSkinPlugin;
import org.pushingpixels.substance.internal.plugin.BaseSkinPlugin;
import org.pushingpixels.substance.internal.plugin.ColorChooserPlugin;

public class SubstancePluginRepository {
    private Set<SubstanceComponentPlugin> componentPlugins = new HashSet<SubstanceComponentPlugin>();
    private Set<SubstanceSkinPlugin> skinPlugins = new HashSet<SubstanceSkinPlugin>();
    private static SubstancePluginRepository instance = new SubstancePluginRepository();

    public static SubstancePluginRepository getInstance() {
        if (SubstancePluginRepository.instance.componentPlugins.isEmpty()) {
            SubstancePluginRepository.instance.componentPlugins.add(new ColorChooserPlugin());
        }
        if (SubstancePluginRepository.instance.skinPlugins.isEmpty()) {
            SubstancePluginRepository.instance.skinPlugins.add(new BaseSkinPlugin());
        }
        return instance;
    }

    public synchronized void registerComponentPlugin(SubstanceComponentPlugin componentPlugin) {
        this.componentPlugins.add(componentPlugin);
    }

    public synchronized void unregisterComponentPlugin(SubstanceComponentPlugin componentPlugin) {
        this.componentPlugins.remove(componentPlugin);
    }

    public synchronized void registerSkinPlugin(SubstanceSkinPlugin skinPlugin) {
        this.skinPlugins.add(skinPlugin);
    }

    public synchronized void unregisterSkinPlugin(SubstanceSkinPlugin skinPlugin) {
        this.skinPlugins.remove(skinPlugin);
    }

    public synchronized Set<SubstanceComponentPlugin> getComponentPlugins() {
        return Collections.unmodifiableSet(this.componentPlugins);
    }

    public synchronized Set<SubstanceSkinPlugin> getSkinPlugins() {
        return Collections.unmodifiableSet(this.skinPlugins);
    }

    public void initializeAllComponentPlugins() {
        for (SubstanceComponentPlugin componentPlugin : this.componentPlugins) {
            componentPlugin.initialize();
        }
    }

    public void uninitializeAllComponentPlugins() {
        for (SubstanceComponentPlugin componentPlugin : this.componentPlugins) {
            componentPlugin.uninitialize();
        }
    }

    public void processAllDefaultsEntriesComponentPlugins(UIDefaults table, SubstanceSkin skin) {
        for (SubstanceComponentPlugin componentPlugin : this.componentPlugins) {
            Object[] defaults = componentPlugin.getDefaults(skin);
            if (defaults == null) continue;
            table.putDefaults(defaults);
        }
    }
}

