/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.jgoodies.looks;

public final class LookUtils {
    private static final String OS_NAME = LookUtils.getSystemProperty("os.name");
    private static final String OS_VERSION = LookUtils.getSystemProperty("os.version");
    public static final boolean IS_OS_MAC = LookUtils.startsWith(OS_NAME, "Mac");
    public static final boolean IS_OS_WINDOWS_MODERN = LookUtils.startsWith(OS_NAME, "Windows") && !LookUtils.startsWith(OS_VERSION, "4.0");

    private LookUtils() {
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static String getSystemProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    public static Boolean getBooleanSystemProperty(String key, String logMessage) {
        String value = LookUtils.getSystemProperty(key, "");
        Boolean result = value.equalsIgnoreCase("false") ? Boolean.FALSE : (value.equalsIgnoreCase("true") ? Boolean.TRUE : null);
        return result;
    }

    public static boolean getToolkitUsesNativeDropShadows() {
        return IS_OS_MAC;
    }

    private static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }
}

