/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.Color;
import java.awt.Component;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeTransform;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.painter.highlight.SubstanceHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.api.trait.SubstanceTrait;
import org.pushingpixels.substance.internal.utils.SkinUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;

public abstract class SubstanceSkin
implements SubstanceTrait {
    public static final double DEFAULT_TAB_FADE_START = 0.1;
    public static final double DEFAULT_TAB_FADE_END = 0.3;
    private Map<SubstanceSlices.DecorationAreaType, SubstanceColorSchemeBundle> colorSchemeBundleMap = new HashMap<SubstanceSlices.DecorationAreaType, SubstanceColorSchemeBundle>();
    private Map<SubstanceSlices.DecorationAreaType, SubstanceColorScheme> backgroundColorSchemeMap = new HashMap<SubstanceSlices.DecorationAreaType, SubstanceColorScheme>();
    private Map<SubstanceSlices.DecorationAreaType, List<SubstanceOverlayPainter>> overlayPaintersMap = new HashMap<SubstanceSlices.DecorationAreaType, List<SubstanceOverlayPainter>>();
    protected SubstanceButtonShaper buttonShaper;
    protected SubstanceFillPainter fillPainter;
    protected SubstanceBorderPainter borderPainter;
    protected SubstanceBorderPainter highlightBorderPainter;
    protected SubstanceHighlightPainter highlightPainter;
    protected SubstanceDecorationPainter decorationPainter;
    private Set<SubstanceSlices.DecorationAreaType> decoratedAreaSet;
    protected double tabFadeStart;
    protected double tabFadeEnd;
    private Set<ComponentState> statesWithAlpha;
    private Map<SubstanceSlices.ColorOverlayType, Map<SubstanceSlices.DecorationAreaType, Map<ComponentState, Color>>> colorOverlayMap = new HashMap<SubstanceSlices.ColorOverlayType, Map<SubstanceSlices.DecorationAreaType, Map<ComponentState, Color>>>();

    protected SubstanceSkin() {
        this.decoratedAreaSet = new HashSet<SubstanceSlices.DecorationAreaType>();
        this.decoratedAreaSet.add(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        this.decoratedAreaSet.add(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
        this.tabFadeStart = 0.1;
        this.tabFadeEnd = 0.3;
        this.statesWithAlpha = new HashSet<ComponentState>();
    }

    public final SubstanceBorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public final SubstanceBorderPainter getHighlightBorderPainter() {
        return this.highlightBorderPainter;
    }

    public final SubstanceButtonShaper getButtonShaper() {
        return this.buttonShaper;
    }

    public final SubstanceFillPainter getFillPainter() {
        return this.fillPainter;
    }

    public final SubstanceHighlightPainter getHighlightPainter() {
        return this.highlightPainter;
    }

    public final SubstanceDecorationPainter getDecorationPainter() {
        return this.decorationPainter;
    }

    void addCustomEntriesToTable(UIDefaults table) {
        if (table == null) {
            return;
        }
        SkinUtilities.addCustomEntriesToTable(table, this);
    }

    public final SubstanceColorScheme getColorScheme(Component comp, ComponentState componentState) {
        SubstanceColorScheme registered;
        if (this.colorSchemeBundleMap.size() > 1) {
            SubstanceSlices.DecorationAreaType decorationAreaType;
            SubstanceSlices.DecorationAreaType decorationAreaType2 = decorationAreaType = comp == null ? SubstanceSlices.DecorationAreaType.NONE : SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp);
            if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
                SubstanceColorScheme registered2 = this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(componentState);
                if (registered2 == null) {
                    throw new IllegalStateException("Color scheme shouldn't be null here. Please report this issue");
                }
                return registered2;
            }
        }
        if ((registered = this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getColorScheme(componentState)) == null) {
            throw new IllegalStateException("Color scheme shouldn't be null here. Please report this issue");
        }
        return registered;
    }

    public final float getHighlightAlpha(Component comp, ComponentState componentState) {
        float registered;
        SubstanceSlices.DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp)) && (double)(registered = this.colorSchemeBundleMap.get(decorationAreaType).getHighlightAlpha(componentState)) >= 0.0) {
            return registered;
        }
        float registered2 = this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getHighlightAlpha(componentState);
        if ((double)registered2 >= 0.0) {
            return registered2;
        }
        boolean isRollover = componentState.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER);
        boolean isSelected = componentState.isFacetActive(SubstanceSlices.ComponentStateFacet.SELECTION);
        boolean isArmed = componentState.isFacetActive(SubstanceSlices.ComponentStateFacet.ARM);
        if (isRollover && isSelected) {
            return 0.9f;
        }
        if (isRollover && isArmed) {
            return 0.8f;
        }
        if (isSelected) {
            return 0.7f;
        }
        if (isArmed) {
            return 0.6f;
        }
        if (isRollover) {
            return 0.4f;
        }
        return 0.0f;
    }

    public final float getAlpha(Component comp, ComponentState componentState) {
        float registered;
        ComponentState fallback = componentState.getHardFallback();
        if (fallback == null && !this.statesWithAlpha.contains(componentState)) {
            return 1.0f;
        }
        if (this.colorSchemeBundleMap.size() > 1) {
            float registered2;
            SubstanceSlices.DecorationAreaType decorationAreaType;
            SubstanceSlices.DecorationAreaType decorationAreaType2 = decorationAreaType = comp == null ? SubstanceSlices.DecorationAreaType.NONE : SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp);
            if (this.colorSchemeBundleMap.containsKey(decorationAreaType) && (double)(registered2 = this.colorSchemeBundleMap.get(decorationAreaType).getAlpha(componentState)) >= 0.0) {
                return registered2;
            }
        }
        if ((double)(registered = this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getAlpha(componentState)) >= 0.0) {
            return registered;
        }
        if (fallback == null) {
            return 1.0f;
        }
        return this.getAlpha(comp, fallback);
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle bundle, SubstanceColorScheme backgroundColorScheme, SubstanceSlices.DecorationAreaType ... areaTypes) {
        if (bundle == null) {
            return;
        }
        if (backgroundColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (SubstanceSlices.DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.colorSchemeBundleMap.put(areaType, bundle);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
        this.statesWithAlpha.addAll(bundle.getStatesWithAlpha());
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle bundle, SubstanceSlices.DecorationAreaType ... areaTypes) {
        this.registerDecorationAreaSchemeBundle(bundle, bundle.getEnabledColorScheme(), areaTypes);
    }

    public void registerAsDecorationArea(SubstanceColorScheme backgroundColorScheme, SubstanceSlices.DecorationAreaType ... areaTypes) {
        if (backgroundColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (SubstanceSlices.DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
    }

    public boolean isRegisteredAsDecorationArea(SubstanceSlices.DecorationAreaType decorationType) {
        return this.decoratedAreaSet.contains(decorationType);
    }

    public final SubstanceColorScheme getActiveColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getActiveColorScheme();
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getActiveColorScheme();
    }

    public final SubstanceColorScheme getEnabledColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getEnabledColorScheme();
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getEnabledColorScheme();
    }

    public final SubstanceColorScheme getDisabledColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getDisabledColorScheme();
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getDisabledColorScheme();
    }

    public final double getTabFadeStart() {
        return this.tabFadeStart;
    }

    public final double getTabFadeEnd() {
        return this.tabFadeEnd;
    }

    public void setTabFadeEnd(double tabFadeEnd) {
        if (tabFadeEnd < 0.0 || tabFadeEnd > 1.0) {
            throw new IllegalArgumentException("Value for tab fade end should be in 0.0-1.0 range");
        }
        this.tabFadeEnd = tabFadeEnd;
    }

    public void setTabFadeStart(double tabFadeStart) {
        if (tabFadeStart < 0.0 || tabFadeStart > 1.0) {
            throw new IllegalArgumentException("Value for tab fade start should be in 0.0-1.0 range");
        }
        this.tabFadeStart = tabFadeStart;
    }

    public void addOverlayPainter(SubstanceOverlayPainter overlayPainter, SubstanceSlices.DecorationAreaType ... areaTypes) {
        for (SubstanceSlices.DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey(areaType)) {
                this.overlayPaintersMap.put(areaType, new ArrayList());
            }
            this.overlayPaintersMap.get(areaType).add(overlayPainter);
        }
    }

    public void removeOverlayPainter(SubstanceOverlayPainter overlayPainter, SubstanceSlices.DecorationAreaType ... areaTypes) {
        for (SubstanceSlices.DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey(areaType)) {
                return;
            }
            this.overlayPaintersMap.get(areaType).remove(overlayPainter);
            if (this.overlayPaintersMap.get(areaType).size() != 0) continue;
            this.overlayPaintersMap.remove(areaType);
        }
    }

    public void clearOverlayPainters(SubstanceSlices.DecorationAreaType ... areaTypes) {
        for (SubstanceSlices.DecorationAreaType areaType : areaTypes) {
            if (!this.overlayPaintersMap.containsKey(areaType)) {
                return;
            }
            this.overlayPaintersMap.get(areaType).clear();
            this.overlayPaintersMap.remove(areaType);
        }
    }

    public List<SubstanceOverlayPainter> getOverlayPainters(SubstanceSlices.DecorationAreaType decorationAreaType) {
        if (!this.overlayPaintersMap.containsKey(decorationAreaType)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.overlayPaintersMap.get(decorationAreaType));
    }

    public final SubstanceColorScheme getColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(associationKind, componentState, true);
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getColorScheme(associationKind, componentState, true);
    }

    public final SubstanceColorScheme getColorScheme(Component comp, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (this.colorSchemeBundleMap.size() > 1) {
            SubstanceSlices.DecorationAreaType decorationAreaType;
            SubstanceSlices.DecorationAreaType decorationAreaType2 = decorationAreaType = comp == null ? SubstanceSlices.DecorationAreaType.NONE : SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp);
            if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
                return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(associationKind, componentState, true);
            }
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getColorScheme(associationKind, componentState, true);
    }

    public final SubstanceColorScheme getDirectColorScheme(Component comp, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        SubstanceSlices.DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp))) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(associationKind, componentState, false);
        }
        return this.colorSchemeBundleMap.get(SubstanceSlices.DecorationAreaType.NONE).getColorScheme(associationKind, componentState, false);
    }

    public SubstanceSkin transform(ColorSchemeTransform transform, final String name) {
        SubstanceSkin result = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return name;
            }
        };
        result.borderPainter = this.borderPainter;
        result.buttonShaper = this.buttonShaper;
        result.decorationPainter = this.decorationPainter;
        result.fillPainter = this.fillPainter;
        result.highlightPainter = this.highlightPainter;
        result.highlightBorderPainter = this.highlightBorderPainter;
        result.tabFadeEnd = this.tabFadeEnd;
        result.tabFadeStart = this.tabFadeStart;
        if (this.colorSchemeBundleMap != null) {
            result.colorSchemeBundleMap = new HashMap<SubstanceSlices.DecorationAreaType, SubstanceColorSchemeBundle>();
            for (Map.Entry<SubstanceSlices.DecorationAreaType, SubstanceColorSchemeBundle> entry : this.colorSchemeBundleMap.entrySet()) {
                result.colorSchemeBundleMap.put(entry.getKey(), entry.getValue().transform(transform));
            }
        }
        if (this.decoratedAreaSet != null) {
            result.decoratedAreaSet = new HashSet<SubstanceSlices.DecorationAreaType>(this.decoratedAreaSet);
        }
        if (this.backgroundColorSchemeMap != null) {
            result.backgroundColorSchemeMap = new HashMap<SubstanceSlices.DecorationAreaType, SubstanceColorScheme>();
            for (Map.Entry<SubstanceSlices.DecorationAreaType, Object> entry : this.backgroundColorSchemeMap.entrySet()) {
                result.backgroundColorSchemeMap.put(entry.getKey(), transform.transform((SubstanceColorScheme)entry.getValue()));
            }
        }
        result.overlayPaintersMap = new HashMap<SubstanceSlices.DecorationAreaType, List<SubstanceOverlayPainter>>(this.overlayPaintersMap);
        return result;
    }

    public final SubstanceColorScheme getBackgroundColorScheme(SubstanceSlices.DecorationAreaType decorationAreaType) {
        SubstanceColorScheme registered;
        if (this.backgroundColorSchemeMap.containsKey(decorationAreaType)) {
            return this.backgroundColorSchemeMap.get(decorationAreaType);
        }
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType) && (registered = this.colorSchemeBundleMap.get(decorationAreaType).getEnabledColorScheme()) != null) {
            return registered;
        }
        return this.backgroundColorSchemeMap.get(SubstanceSlices.DecorationAreaType.NONE);
    }

    public void setOverlayColor(Color color, SubstanceSlices.ColorOverlayType colorOverlayType, SubstanceSlices.DecorationAreaType decorationAreaType, ComponentState ... componentStates) {
        Map<SubstanceSlices.DecorationAreaType, Map<ComponentState, Color>> forOverlay;
        if (!this.colorOverlayMap.containsKey((Object)colorOverlayType)) {
            this.colorOverlayMap.put(colorOverlayType, new HashMap());
        }
        if (!(forOverlay = this.colorOverlayMap.get((Object)colorOverlayType)).containsKey(decorationAreaType)) {
            forOverlay.put(decorationAreaType, new HashMap());
        }
        Map<ComponentState, Color> forDecorationArea = forOverlay.get(decorationAreaType);
        for (ComponentState componentState : componentStates) {
            forDecorationArea.put(componentState, color);
        }
    }

    public Color getOverlayColor(SubstanceSlices.ColorOverlayType colorOverlayType, SubstanceSlices.DecorationAreaType decorationAreaType, ComponentState componentState) {
        if (!this.colorOverlayMap.containsKey((Object)colorOverlayType)) {
            return null;
        }
        Map<SubstanceSlices.DecorationAreaType, Map<ComponentState, Color>> forOverlay = this.colorOverlayMap.get((Object)colorOverlayType);
        if (!forOverlay.containsKey(decorationAreaType)) {
            return null;
        }
        return forOverlay.get(decorationAreaType).get(componentState);
    }

    public boolean isValid() {
        if (!this.colorSchemeBundleMap.containsKey(SubstanceSlices.DecorationAreaType.NONE)) {
            return false;
        }
        if (this.getButtonShaper() == null) {
            return false;
        }
        if (this.getFillPainter() == null) {
            return false;
        }
        if (this.getBorderPainter() == null) {
            return false;
        }
        if (this.getHighlightPainter() == null) {
            return false;
        }
        return this.getDecorationPainter() != null;
    }

    public static ColorSchemes getColorSchemes(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Can't read color schemes from a null stream");
        }
        return SubstanceColorSchemeUtilities.getColorSchemes(inputStream);
    }

    public static interface ColorSchemes {
        public Collection<SubstanceColorScheme> getAll();

        public SubstanceColorScheme get(String var1);
    }

    public static abstract class Accented
    extends SubstanceSkin {
        private final SubstanceColorScheme windowChromeAccent;
        private final SubstanceColorScheme activeControlsAccent;
        private final SubstanceColorScheme enabledControlsAccent;
        private final SubstanceColorScheme highlightsAccent;
        private final SubstanceColorScheme backgroundAccent;

        protected Accented(AccentBuilder accentBuilder) {
            this.windowChromeAccent = accentBuilder.windowChromeAccent;
            this.activeControlsAccent = accentBuilder.activeControlsAccent;
            this.enabledControlsAccent = accentBuilder.enabledControlsAccent;
            this.highlightsAccent = accentBuilder.highlightsAccent;
            this.backgroundAccent = accentBuilder.backgroundAccent;
        }

        public SubstanceColorScheme getBackgroundAccent() {
            return this.backgroundAccent;
        }

        public SubstanceColorScheme getActiveControlsAccent() {
            return this.activeControlsAccent;
        }

        public SubstanceColorScheme getEnabledControlsAccent() {
            return this.enabledControlsAccent;
        }

        public SubstanceColorScheme getHighlightsAccent() {
            return this.highlightsAccent;
        }

        public SubstanceColorScheme getWindowChromeAccent() {
            return this.windowChromeAccent;
        }

        public static final class AccentBuilder {
            private SubstanceColorScheme windowChromeAccent;
            private SubstanceColorScheme enabledControlsAccent;
            private SubstanceColorScheme activeControlsAccent;
            private SubstanceColorScheme highlightsAccent;
            private SubstanceColorScheme backgroundAccent;
            private ColorSchemes accentColorSchemes;

            public AccentBuilder withAccentResource(String colorSchemeResourceName) {
                this.accentColorSchemes = SubstanceSkin.getColorSchemes(AccentBuilder.class.getClassLoader().getResourceAsStream(colorSchemeResourceName));
                return this;
            }

            public AccentBuilder withWindowChromeAccent(String windowChromeAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.windowChromeAccent = this.accentColorSchemes.get(windowChromeAccentName);
                return this;
            }

            public AccentBuilder withWindowChromeAccent(SubstanceColorScheme windowChromeAccent) {
                this.windowChromeAccent = windowChromeAccent;
                return this;
            }

            public AccentBuilder withActiveControlsAccent(String activeControlsAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.activeControlsAccent = this.accentColorSchemes.get(activeControlsAccentName);
                return this;
            }

            public AccentBuilder withActiveControlsAccent(SubstanceColorScheme activeControlsAccent) {
                this.activeControlsAccent = activeControlsAccent;
                return this;
            }

            public AccentBuilder withEnabledControlsAccent(String enabledControlsAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.enabledControlsAccent = this.accentColorSchemes.get(enabledControlsAccentName);
                return this;
            }

            public AccentBuilder withEnabledControlsAccent(SubstanceColorScheme enabledControlsAccent) {
                this.enabledControlsAccent = enabledControlsAccent;
                return this;
            }

            public AccentBuilder withHighlightsAccent(String highlightsAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.highlightsAccent = this.accentColorSchemes.get(highlightsAccentName);
                return this;
            }

            public AccentBuilder withHighlightsAccent(SubstanceColorScheme highlightsAccent) {
                this.highlightsAccent = highlightsAccent;
                return this;
            }

            public AccentBuilder withBackgroundAccent(String backgroundAccentName) {
                if (this.accentColorSchemes == null) {
                    throw new IllegalStateException("Builder not configured with accent resource file");
                }
                this.backgroundAccent = this.accentColorSchemes.get(backgroundAccentName);
                return this;
            }

            public AccentBuilder withBackgroundAccent(SubstanceColorScheme backgroundAccent) {
                this.backgroundAccent = backgroundAccent;
                return this;
            }
        }
    }
}

