/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.BaseDarkColorScheme;
import org.pushingpixels.substance.api.colorscheme.BaseLightColorScheme;
import org.pushingpixels.substance.api.colorscheme.BottleGreenColorScheme;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunGlareColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunfireRedColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceTitleButton;

public class SubstanceColorSchemeUtilities {
    private static final LazyResettableHashMap<SubstanceColorScheme> shiftedCache = new LazyResettableHashMap("ShiftColorScheme.shiftedSchemes");
    public static final SubstanceColorScheme YELLOW = new SunGlareColorScheme();
    public static final SubstanceColorScheme ORANGE = new SunfireRedColorScheme();
    public static final SubstanceColorScheme GREEN = new BottleGreenColorScheme();

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme scheme, boolean isEnabled) {
        Component forQuerying = component;
        if (component != null && component.getParent() != null && (component.getClass().isAnnotationPresent(SubstanceInternalArrowButton.class) || component instanceof SubstanceTitleButton)) {
            forQuerying = component.getParent();
        }
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, scheme, forQuerying == null ? null : forQuerying.getForeground(), forQuerying == null ? null : forQuerying.getBackground(), isEnabled);
    }

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme scheme, Color fgColor, Color bgColor, boolean isEnabled) {
        if (scheme != null && component != null) {
            if (bgColor instanceof UIResource) {
                bgColor = null;
            }
            if (fgColor instanceof UIResource) {
                fgColor = null;
            }
            if (bgColor != null || fgColor != null) {
                double colorization = SubstanceCoreUtilities.getColorizationFactor(component);
                if (!isEnabled) {
                    colorization /= 2.0;
                }
                if (colorization > 0.0) {
                    return SubstanceColorSchemeUtilities.getShiftedScheme(scheme, bgColor, colorization, fgColor, colorization);
                }
            }
        }
        return scheme;
    }

    public static SubstanceColorScheme getColorScheme(JTabbedPane jtp, int tabIndex, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(jtp);
        if (skin == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(jtp, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(jtp, associationKind, componentState);
        if (tabIndex >= 0) {
            Component component = jtp.getComponentAt(tabIndex);
            SubstanceColorScheme colorized = SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, jtp.getForegroundAt(tabIndex), jtp.getBackgroundAt(tabIndex), !componentState.isDisabled());
            return colorized;
        }
        return SubstanceColorSchemeUtilities.getColorizedScheme(jtp, nonColorized, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getColorScheme(Component component, ComponentState componentState) {
        SubstanceSkin skin;
        boolean isButtonThatIsNeverPainted;
        Component orig = component;
        boolean bl = isButtonThatIsNeverPainted = component instanceof AbstractButton && SubstanceCoreUtilities.isButtonNeverPainted((AbstractButton)component);
        if (isButtonThatIsNeverPainted || SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        if ((skin = SubstanceCoreUtilities.getSkin(component)) == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(component, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(component, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(orig, nonColorized, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getColorScheme(Component component, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        SubstanceSkin skin;
        if (!(component instanceof JToolBar) && SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        if ((skin = SubstanceCoreUtilities.getSkin(component)) == null) {
            return null;
        }
        SubstanceColorScheme nonColorized = skin.getColorScheme(component, associationKind, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getDirectColorScheme(Component component, SubstanceSlices.ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (!(component instanceof JToolBar) && SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        SubstanceColorScheme nonColorized = SubstanceCoreUtilities.getSkin(component).getDirectColorScheme(component, associationKind, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getActiveColorScheme(Component component, ComponentState componentState) {
        if (!(component instanceof JToolBar) && SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        SubstanceColorScheme nonColorized = SubstanceCoreUtilities.getSkin(component).getActiveColorScheme(SubstanceCortex.ComponentOrParentChainScope.getDecorationType(component));
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, nonColorized, !componentState.isDisabled());
    }

    public static float getHighlightAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getHighlightAlpha(component, componentState);
    }

    public static float getAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getAlpha(component, componentState);
    }

    public static SubstanceColorScheme getLightColorScheme(String name, final Color[] colors, final Map<String, Color> additionalColors) {
        if (colors == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colors.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseLightColorScheme(name){

            @Override
            public Color getUltraLightColor() {
                return colors[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colors[1];
            }

            @Override
            public Color getLightColor() {
                return colors[2];
            }

            @Override
            public Color getMidColor() {
                return colors[3];
            }

            @Override
            public Color getDarkColor() {
                return colors[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colors[5];
            }

            @Override
            public Color getForegroundColor() {
                return colors[6];
            }

            @Override
            public Color getLineColor() {
                if (additionalColors.containsKey("colorLine")) {
                    return (Color)additionalColors.get("colorLine");
                }
                return super.getLineColor();
            }

            @Override
            public Color getBackgroundFillColor() {
                if (additionalColors.containsKey("colorBackgroundFill")) {
                    return (Color)additionalColors.get("colorBackgroundFill");
                }
                return super.getBackgroundFillColor();
            }

            @Override
            public Color getTextBackgroundFillColor() {
                if (additionalColors.containsKey("colorTextBackgroundFill")) {
                    return (Color)additionalColors.get("colorTextBackgroundFill");
                }
                return super.getTextBackgroundFillColor();
            }

            @Override
            public Color getSelectionBackgroundColor() {
                if (additionalColors.containsKey("colorSelectionBackground")) {
                    return (Color)additionalColors.get("colorSelectionBackground");
                }
                return super.getSelectionBackgroundColor();
            }

            @Override
            public Color getSelectionForegroundColor() {
                if (additionalColors.containsKey("colorSelectionForeground")) {
                    return (Color)additionalColors.get("colorSelectionForeground");
                }
                return super.getSelectionForegroundColor();
            }

            @Override
            public Color getFocusRingColor() {
                if (additionalColors.containsKey("colorFocusRing")) {
                    return (Color)additionalColors.get("colorFocusRing");
                }
                return super.getFocusRingColor();
            }

            @Override
            public Color getSeparatorLightColor() {
                if (additionalColors.containsKey("colorSeparatorLight")) {
                    return (Color)additionalColors.get("colorSeparatorLight");
                }
                return super.getSeparatorLightColor();
            }

            @Override
            public Color getSeparatorDarkColor() {
                if (additionalColors.containsKey("colorSeparatorDark")) {
                    return (Color)additionalColors.get("colorSeparatorDark");
                }
                return super.getSeparatorDarkColor();
            }

            @Override
            public Color getSeparatorShadowColor() {
                if (additionalColors.containsKey("colorSeparatorShadow")) {
                    return (Color)additionalColors.get("colorSeparatorShadow");
                }
                return super.getSeparatorShadowColor();
            }
        };
    }

    public static SubstanceColorScheme getDarkColorScheme(String name, final Color[] colors, final Map<String, Color> additionalColors) {
        if (colors == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colors.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseDarkColorScheme(name){

            @Override
            public Color getUltraLightColor() {
                return colors[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colors[1];
            }

            @Override
            public Color getLightColor() {
                return colors[2];
            }

            @Override
            public Color getMidColor() {
                return colors[3];
            }

            @Override
            public Color getDarkColor() {
                return colors[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colors[5];
            }

            @Override
            public Color getForegroundColor() {
                return colors[6];
            }

            @Override
            public Color getLineColor() {
                if (additionalColors.containsKey("colorLine")) {
                    return (Color)additionalColors.get("colorLine");
                }
                return super.getLineColor();
            }

            @Override
            public Color getBackgroundFillColor() {
                if (additionalColors.containsKey("colorBackgroundFill")) {
                    return (Color)additionalColors.get("colorBackgroundFill");
                }
                return super.getBackgroundFillColor();
            }

            @Override
            public Color getTextBackgroundFillColor() {
                if (additionalColors.containsKey("colorTextBackgroundFill")) {
                    return (Color)additionalColors.get("colorTextBackgroundFill");
                }
                return super.getTextBackgroundFillColor();
            }

            @Override
            public Color getSelectionBackgroundColor() {
                if (additionalColors.containsKey("colorSelectionBackground")) {
                    return (Color)additionalColors.get("colorSelectionBackground");
                }
                return super.getSelectionBackgroundColor();
            }

            @Override
            public Color getSelectionForegroundColor() {
                if (additionalColors.containsKey("colorSelectionForeground")) {
                    return (Color)additionalColors.get("colorSelectionForeground");
                }
                return super.getSelectionForegroundColor();
            }

            @Override
            public Color getFocusRingColor() {
                if (additionalColors.containsKey("colorFocusRing")) {
                    return (Color)additionalColors.get("colorFocusRing");
                }
                return super.getFocusRingColor();
            }

            @Override
            public Color getSeparatorLightColor() {
                if (additionalColors.containsKey("colorSeparatorLight")) {
                    return (Color)additionalColors.get("colorSeparatorLight");
                }
                return super.getSeparatorLightColor();
            }

            @Override
            public Color getSeparatorDarkColor() {
                if (additionalColors.containsKey("colorSeparatorDark")) {
                    return (Color)additionalColors.get("colorSeparatorDark");
                }
                return super.getSeparatorDarkColor();
            }

            @Override
            public Color getSeparatorShadowColor() {
                if (additionalColors.containsKey("colorSeparatorShadow")) {
                    return (Color)additionalColors.get("colorSeparatorShadow");
                }
                return super.getSeparatorShadowColor();
            }
        };
    }

    private static Color decodeColor(String value, Map<String, Color> colorMap) {
        if (value.startsWith("@")) {
            return colorMap.get(value.substring(1));
        }
        return Color.decode(value);
    }

    public static SubstanceSkin.ColorSchemes getColorSchemes(InputStream inputStream) {
        final ArrayList<SubstanceColorScheme> schemes = new ArrayList<SubstanceColorScheme>();
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        Color ultraLight = null;
        Color extraLight = null;
        Color light = null;
        Color mid = null;
        Color dark = null;
        Color ultraDark = null;
        Color foreground = null;
        Color background = null;
        String name = null;
        ColorSchemeKind kind = null;
        HashMap<String, Color> additionalColors = new HashMap<String, Color>();
        boolean inColorSchemeBlock = false;
        boolean inColorsBlock = false;
        int lineNumber = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            while (true) {
                String line = reader.readLine();
                ++lineNumber;
                if (line == null) {
                    break;
                }
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.contains("{")) {
                    if (inColorSchemeBlock || inColorsBlock) {
                        throw new IllegalArgumentException("Already in color scheme or colors definition, line " + lineNumber);
                    }
                    name = line.substring(0, line.indexOf("{")).trim();
                    if (name.equals("@colors")) {
                        inColorsBlock = true;
                        continue;
                    }
                    inColorSchemeBlock = true;
                    continue;
                }
                if (line.contains("}")) {
                    Color[] colorArray;
                    if (!inColorSchemeBlock && !inColorsBlock) {
                        throw new IllegalArgumentException("Not in color scheme or colors definition, line " + lineNumber);
                    }
                    if (inColorsBlock) {
                        inColorsBlock = false;
                        continue;
                    }
                    inColorSchemeBlock = false;
                    if (background == null) {
                        if (name == null || kind == null || ultraLight == null || extraLight == null || light == null || mid == null || dark == null || ultraDark == null || foreground == null) {
                            throw new IllegalArgumentException("Incomplete specification of '" + name + "', line " + lineNumber);
                        }
                    } else if (name == null || foreground == null) {
                        throw new IllegalArgumentException("Incomplete specification '" + name + "', line " + lineNumber);
                    }
                    if (background != null) {
                        Color[] colorArray2 = new Color[7];
                        colorArray2[0] = background;
                        colorArray2[1] = background;
                        colorArray2[2] = background;
                        colorArray2[3] = background;
                        colorArray2[4] = background;
                        colorArray2[5] = background;
                        colorArray = colorArray2;
                        colorArray2[6] = foreground;
                    } else {
                        Color[] colorArray3 = new Color[7];
                        colorArray3[0] = ultraLight;
                        colorArray3[1] = extraLight;
                        colorArray3[2] = light;
                        colorArray3[3] = mid;
                        colorArray3[4] = dark;
                        colorArray3[5] = ultraDark;
                        colorArray = colorArray3;
                        colorArray3[6] = foreground;
                    }
                    Color[] colors = colorArray;
                    if (kind == ColorSchemeKind.LIGHT) {
                        schemes.add(SubstanceColorSchemeUtilities.getLightColorScheme(name, colors, new HashMap<String, Color>(additionalColors)));
                    } else {
                        schemes.add(SubstanceColorSchemeUtilities.getDarkColorScheme(name, colors, new HashMap<String, Color>(additionalColors)));
                    }
                    name = null;
                    kind = null;
                    ultraLight = null;
                    extraLight = null;
                    light = null;
                    mid = null;
                    dark = null;
                    ultraDark = null;
                    foreground = null;
                    background = null;
                    additionalColors.clear();
                    continue;
                }
                String[] split = line.split("=");
                if (split.length != 2) {
                    throw new IllegalArgumentException("Unsupported format in line " + line + " [" + lineNumber + "]");
                }
                String key = split[0].trim();
                String value = split[1].trim();
                if (inColorsBlock) {
                    colorMap.put(key, Color.decode(value));
                    continue;
                }
                if ("kind".equals(key)) {
                    if (kind == null) {
                        if ("Light".equals(value)) {
                            kind = ColorSchemeKind.LIGHT;
                            continue;
                        }
                        if ("Dark".equals(value)) {
                            kind = ColorSchemeKind.DARK;
                            continue;
                        }
                        throw new IllegalArgumentException("Unsupported format in line " + line + " [" + lineNumber + "]");
                    }
                    throw new IllegalArgumentException("'kind' should only be defined once, line " + lineNumber);
                }
                if ("colorUltraLight".equals(key)) {
                    if (ultraLight == null) {
                        ultraLight = SubstanceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraLight' should only be defined once, line " + lineNumber);
                }
                if ("colorExtraLight".equals(key)) {
                    if (extraLight == null) {
                        extraLight = SubstanceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'extraLight' should only be defined once, line " + lineNumber);
                }
                if ("colorLight".equals(key)) {
                    if (light == null) {
                        light = SubstanceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'light' should only be defined once, line " + lineNumber);
                }
                if ("colorMid".equals(key)) {
                    if (mid == null) {
                        mid = SubstanceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'mid' should only be defined once, line " + lineNumber);
                }
                if ("colorDark".equals(key)) {
                    if (dark == null) {
                        dark = SubstanceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'dark' should only be defined once, line " + lineNumber);
                }
                if ("colorUltraDark".equals(key)) {
                    if (ultraDark == null) {
                        ultraDark = SubstanceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraDark' should only be defined once, line " + lineNumber);
                }
                if ("colorForeground".equals(key)) {
                    if (foreground == null) {
                        foreground = SubstanceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once, line " + lineNumber);
                }
                if ("colorBackground".equals(key)) {
                    if (value.contains("->")) {
                        String[] splitInner = value.split("->");
                        Color colorStart = SubstanceColorSchemeUtilities.decodeColor(splitInner[0].trim(), colorMap);
                        Color colorEnd = SubstanceColorSchemeUtilities.decodeColor(splitInner[1].trim(), colorMap);
                        ultraLight = colorStart;
                        extraLight = SubstanceColorUtilities.getInterpolatedColor(colorStart, colorEnd, 0.9f);
                        light = SubstanceColorUtilities.getInterpolatedColor(colorStart, colorEnd, 0.7f);
                        mid = SubstanceColorUtilities.getInterpolatedColor(colorStart, colorEnd, 0.5);
                        dark = SubstanceColorUtilities.getInterpolatedColor(colorStart, colorEnd, 0.2f);
                        ultraDark = colorEnd;
                        continue;
                    }
                    if (background == null) {
                        background = SubstanceColorSchemeUtilities.decodeColor(value, colorMap);
                        continue;
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once, line " + lineNumber);
                }
                additionalColors.put(key, SubstanceColorSchemeUtilities.decodeColor(value, colorMap));
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        return new SubstanceSkin.ColorSchemes(){

            @Override
            public Collection<SubstanceColorScheme> getAll() {
                return Collections.unmodifiableCollection(schemes);
            }

            @Override
            public SubstanceColorScheme get(String displayName) {
                for (SubstanceColorScheme scheme : schemes) {
                    if (!scheme.getDisplayName().equals(displayName)) continue;
                    return scheme;
                }
                return null;
            }
        };
    }

    public static SubstanceColorScheme getShiftedScheme(SubstanceColorScheme orig, Color backgroundShiftColor, double backgroundShiftFactor, Color foregroundShiftColor, double foregroundShiftFactor) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(orig.getDisplayName(), backgroundShiftColor == null ? "" : Integer.valueOf(backgroundShiftColor.getRGB()), backgroundShiftFactor, foregroundShiftColor == null ? "" : Integer.valueOf(foregroundShiftColor.getRGB()), foregroundShiftFactor);
        SubstanceColorScheme result = shiftedCache.get(key);
        if (result == null) {
            result = orig.shift(backgroundShiftColor, backgroundShiftFactor, foregroundShiftColor, foregroundShiftFactor);
            shiftedCache.put(key, result);
        }
        return result;
    }

    private static enum ColorSchemeKind {
        LIGHT,
        DARK;

    }
}

