/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceMenuBarUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitleButton;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePaneUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.SubstanceIconFactory;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class SubstanceInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected PropertyChangeListener substancePropertyListener;
    private PropertyChangeListener substanceWinModifiedListener;
    private static final String ICONIFYING = "substancelaf.internal.internalTitleFramePane.iconifying";
    private static final String UNINSTALLED = "substancelaf.internal.internalTitleFramePane.uninstalled";

    public SubstanceInternalFrameTitlePane(JInternalFrame f) {
        super(f);
        this.setToolTipText(f.getTitle());
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType(this, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            this.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceCoreUtilities.getSkin(this.frame).getActiveColorScheme(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE)));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substancePropertyListener = propertyChangeEvent -> {
            if ("title".equals(propertyChangeEvent.getPropertyName())) {
                this.setToolTipText((String)propertyChangeEvent.getNewValue());
            }
            if ("JInternalFrame.messageType".equals(propertyChangeEvent.getPropertyName())) {
                this.updateOptionPaneState();
                this.frame.repaint();
            }
        };
        this.frame.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceWinModifiedListener = propertyChangeEvent -> {
            if ("substancelaf.internal.contentsModified".equals(propertyChangeEvent.getPropertyName())) {
                this.syncCloseButtonTooltip();
            }
        };
        this.frame.getRootPane().addPropertyChangeListener(this.substanceWinModifiedListener);
    }

    @Override
    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SubstanceMenuBar();
        this.menuBar.setBorderPainted(true);
        this.menuBar.setOpaque(false);
        this.menuBar.setFocusable(false);
        this.menuBar.applyComponentOrientation(this.getComponentOrientation());
        SubstanceSlices.TitleIconHorizontalGravity iconGravity = SubstanceTitlePaneUtilities.getTitlePaneIconGravity();
        SubstanceTitlePaneUtilities.markTitlePaneExtraComponent(this.menuBar, iconGravity == SubstanceSlices.TitleIconHorizontalGravity.NEXT_TO_TITLE ? SubstanceTitlePaneUtilities.ExtraComponentKind.WITH_TITLE : SubstanceTitlePaneUtilities.ExtraComponentKind.LEADING);
        return this.menuBar;
    }

    @Override
    public void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.frame.getRootPane().removePropertyChangeListener(this.substanceWinModifiedListener);
        this.substanceWinModifiedListener = null;
        super.uninstallListeners();
    }

    public void uninstall() {
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            SubstanceMenuBarUI ui;
            MenuBarUI menuBarUI = this.menuBar.getUI();
            if (menuBarUI instanceof SubstanceMenuBarUI && (ui = (SubstanceMenuBarUI)menuBarUI).getMenuBar() == this.menuBar) {
                menuBarUI.uninstallUI(this.menuBar);
            }
            SubstanceCoreUtilities.uninstallMenu(this.menuBar.getMenu(0));
            this.remove(this.menuBar);
            this.remove(this.maxButton);
            this.remove(this.closeButton);
            this.remove(this.iconButton);
        }
        this.uninstallListeners();
        this.putClientProperty(UNINSTALLED, Boolean.TRUE);
    }

    @Override
    protected void enableActions() {
        super.enableActions();
        if (!this.frame.isIcon()) {
            if (this.maxButton != null) {
                this.maxButton.setEnabled(this.maximizeAction.isEnabled() || this.restoreAction.isEnabled());
            }
            if (this.iconButton != null) {
                this.iconButton.setEnabled(this.iconifyAction.isEnabled());
            }
        }
    }

    private String getDisplayTitle() {
        String theTitle = this.frame.getTitle();
        if (theTitle == null) {
            return null;
        }
        FontUIResource font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
        Rectangle titleTextRect = SubstanceTitlePaneUtilities.getTitlePaneTextRectangle(this, this.frame);
        FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics(font);
        int titleWidth = titleTextRect.width - 20;
        String clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth, theTitle);
        return clippedTitle;
    }

    @Override
    public void paintComponent(Graphics g) {
        Color backgr;
        JInternalFrame hostFrame;
        Graphics2D graphics = (Graphics2D)g.create();
        float coef = this.getParent() instanceof JInternalFrame.JDesktopIcon ? 0.9f : 1.0f;
        graphics.setComposite(WidgetUtilities.getAlphaComposite(this.frame, coef, g));
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight() + 2;
        SubstanceColorScheme scheme = SubstanceCoreUtilities.getSkin(this.frame).getEnabledColorScheme(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
        JComponent hostForColorization = hostFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this);
        if (hostFrame == null) {
            JInternalFrame.JDesktopIcon desktopIcon = (JInternalFrame.JDesktopIcon)SwingUtilities.getAncestorOfClass(JInternalFrame.JDesktopIcon.class, this);
            if (desktopIcon != null) {
                hostFrame = desktopIcon.getInternalFrame();
            }
            hostForColorization = desktopIcon;
        }
        if (!((backgr = hostFrame.getBackground()) instanceof UIResource)) {
            double colorization = SubstanceCoreUtilities.getColorizationFactor(hostForColorization);
            scheme = SubstanceColorSchemeUtilities.getShiftedScheme(scheme, backgr, colorization, null, 0.0);
        }
        BackgroundPaintingUtils.update(graphics, this, false);
        String theTitle = this.frame.getTitle();
        String displayTitle = this.getDisplayTitle();
        FontUIResource font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
        graphics.setFont(font);
        if (displayTitle != null) {
            Rectangle titleTextRect = SubstanceTitlePaneUtilities.getTitlePaneTextRectangle(this, this.frame);
            FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics(font);
            int displayTitleWidth = fm.stringWidth(displayTitle);
            if (theTitle.equals(displayTitle)) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(theTitle);
            }
            int xOffset = 0;
            SubstanceSlices.HorizontalGravity titleTextGravity = SubstanceTitlePaneUtilities.getTitlePaneTextGravity();
            switch (titleTextGravity) {
                case LEADING: {
                    xOffset = leftToRight ? titleTextRect.x : titleTextRect.x + titleTextRect.width - displayTitleWidth;
                    break;
                }
                case TRAILING: {
                    xOffset = leftToRight ? titleTextRect.x + titleTextRect.width - displayTitleWidth : titleTextRect.x;
                    break;
                }
                default: {
                    xOffset = titleTextRect.x + (titleTextRect.width - displayTitleWidth) / 2;
                }
            }
            int yOffset = titleTextRect.y + (int)((titleTextRect.getHeight() - (double)fm.getHeight()) / 2.0) + fm.getAscent();
            SubstanceColorScheme fillScheme = SubstanceCoreUtilities.getSkin(this.frame).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE);
            Color echoColor = !fillScheme.isDark() ? fillScheme.getUltraDarkColor() : fillScheme.getUltraLightColor();
            SubstanceTextUtilities.paintTextWithDropShadow(this, graphics, SubstanceColorUtilities.getForegroundColor(scheme), echoColor, displayTitle, width, height, xOffset, yOffset);
        }
        graphics.dispose();
    }

    @Override
    protected void setButtonIcons() {
        super.setButtonIcons();
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        TransitionAwareIcon restoreIcon = new TransitionAwareIcon(this.maxButton, scheme -> SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, scheme, SubstanceCoreUtilities.getSkin(this).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE)), "substance.internalFrame.restoreIcon");
        TransitionAwareIcon maximizeIcon = new TransitionAwareIcon(this.maxButton, scheme -> SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, scheme, SubstanceCoreUtilities.getSkin(this).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE)), "substance.internalFrame.maxIcon");
        TransitionAwareIcon minimizeIcon = new TransitionAwareIcon(this.iconButton, scheme -> SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, scheme, SubstanceCoreUtilities.getSkin(this).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE)), "substance.internalFrame.minIcon");
        TransitionAwareIcon closeIcon = new TransitionAwareIcon(this.closeButton, scheme -> SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, scheme, SubstanceCoreUtilities.getSkin(this).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE)), "substance.internalFrame.closeIcon");
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(restoreIcon);
            this.iconButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.restore"));
            this.maxButton.setIcon(maximizeIcon);
            this.maxButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.maximize"));
        } else {
            this.iconButton.setIcon(minimizeIcon);
            this.iconButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.iconify"));
            if (this.frame.isMaximum()) {
                this.maxButton.setIcon(restoreIcon);
                this.maxButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.restore"));
            } else {
                this.maxButton.setIcon(maximizeIcon);
                this.maxButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.maximize"));
            }
        }
        this.closeButton.setIcon(closeIcon);
        this.syncCloseButtonTooltip();
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.iconifyAction = new SubstanceIconifyAction();
    }

    @Override
    protected void createButtons() {
        this.iconButton = new SubstanceTitleButton("InternalFrameTitlePane.iconifyButtonAccessibleName");
        this.iconButton.addActionListener(this.iconifyAction);
        this.maxButton = new SubstanceTitleButton("InternalFrameTitlePane.maximizeButtonAccessibleName");
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new SubstanceTitleButton("InternalFrameTitlePane.closeButtonAccessibleName");
        this.closeButton.addActionListener(this.closeAction);
        SubstanceTitlePaneUtilities.ExtraComponentKind buttonExtraComponentKind = SubstanceTitlePaneUtilities.getTitlePaneControlButtonKind(this.getRootPane());
        SubstanceTitlePaneUtilities.markTitlePaneExtraComponent(this.iconButton, buttonExtraComponentKind);
        SubstanceTitlePaneUtilities.markTitlePaneExtraComponent(this.maxButton, buttonExtraComponentKind);
        SubstanceTitlePaneUtilities.markTitlePaneExtraComponent(this.closeButton, buttonExtraComponentKind);
        this.setButtonIcons();
        for (ActionListener listener : this.iconButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.iconButton.addActionListener(new ClickListener());
        for (ActionListener listener : this.maxButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.maxButton.addActionListener(new ClickListener());
        SubstanceCoreUtilities.markButtonAsFlat(this.iconButton);
        SubstanceCoreUtilities.markButtonAsFlat(this.maxButton);
        SubstanceCoreUtilities.markButtonAsFlat(this.closeButton);
        this.closeButton.putClientProperty("substancelaf.internal.isTitleCloseButton", Boolean.TRUE);
        this.enableActions();
    }

    @Override
    protected LayoutManager createLayout() {
        return new SubstanceTitlePaneLayout();
    }

    protected void syncCloseButtonTooltip() {
        if (SubstanceCoreUtilities.isRootPaneModified(this.frame.getRootPane())) {
            this.closeButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close") + " [" + SubstanceCortex.GlobalScope.getLabelBundle().getString("Tooltip.contentsNotSaved") + "]");
        } else {
            this.closeButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close"));
        }
        this.closeButton.repaint();
    }

    @Override
    public void removeNotify() {
        boolean isAlive;
        super.removeNotify();
        boolean bl = isAlive = this.frame.isIcon() && !this.frame.isClosed() || Boolean.TRUE.equals(this.frame.getClientProperty(ICONIFYING));
        if (!isAlive) {
            this.uninstall();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (Boolean.TRUE.equals(this.getClientProperty(UNINSTALLED))) {
            this.installTitlePane();
            this.putClientProperty(UNINSTALLED, null);
        }
    }

    private void updateOptionPaneState() {
        Object obj = this.frame.getClientProperty("JInternalFrame.messageType");
        if (obj == null) {
            return;
        }
        if (this.frame.isClosable()) {
            this.frame.setClosable(false);
        }
    }

    public AbstractButton getCloseButton() {
        return this.closeButton;
    }

    public class SubstanceMenuBar
    extends JMenuBar {
        @Override
        public void paint(Graphics g) {
            Icon icon = SubstanceInternalFrameTitlePane.this.frame.getFrameIcon();
            if (icon != null) {
                int width = this.getWidth();
                int height = this.getHeight();
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                if (iconWidth <= width && iconHeight <= height) {
                    icon.paintIcon(this, g, 0, 0);
                } else {
                    float scale = Math.min((float)width / (float)iconWidth, (float)height / (float)iconHeight);
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.scale(scale, scale);
                    icon.paintIcon(this, g2d, 0, 0);
                    g2d.dispose();
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
            return new Dimension(Math.max(iSize, size.width), Math.max(size.height, iSize));
        }
    }

    public class SubstanceIconifyAction
    extends BasicInternalFrameTitlePane.IconifyAction {
        public SubstanceIconifyAction() {
            super(SubstanceInternalFrameTitlePane.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SubstanceInternalFrameTitlePane.this.frame.putClientProperty(SubstanceInternalFrameTitlePane.ICONIFYING, Boolean.TRUE);
            super.actionPerformed(e);
            SubstanceInternalFrameTitlePane.this.frame.putClientProperty(SubstanceInternalFrameTitlePane.ICONIFYING, null);
        }
    }

    protected class SubstanceTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        protected SubstanceTitlePaneLayout() {
            super(SubstanceInternalFrameTitlePane.this);
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int title_length;
            int width = 30;
            if (SubstanceInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (SubstanceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics(SubstanceInternalFrameTitlePane.this.getFont());
            String frameTitle = SubstanceInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            if (title_length > 2) {
                int subtitle_w = fm.stringWidth(SubstanceInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...");
                width += Math.min(title_w, subtitle_w);
            } else {
                width += title_w;
            }
            int height = 0;
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            Icon icon = SubstanceInternalFrameTitlePane.this.frame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            height = Math.max(fontHeight, iconHeight += 5);
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container c) {
            int spacing;
            JRootPane rootPane = SubstanceInternalFrameTitlePane.this.frame.getRootPane();
            boolean leftToRight = rootPane.getComponentOrientation().isLeftToRight();
            boolean controlButtonsOnRight = SubstanceTitlePaneUtilities.areTitlePaneControlButtonsOnRight(rootPane);
            int w = SubstanceInternalFrameTitlePane.this.getWidth();
            int buttonHeight = SubstanceInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int buttonWidth = SubstanceInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            int y = (SubstanceInternalFrameTitlePane.this.getHeight() - buttonHeight) / 2;
            int x = leftToRight ? w : 0;
            SubstanceSlices.TitleIconHorizontalGravity iconGravity = SubstanceTitlePaneUtilities.getTitlePaneIconGravity();
            SubstanceSlices.HorizontalGravity titleTextGravity = SubstanceTitlePaneUtilities.getTitlePaneTextGravity();
            if (SubstanceInternalFrameTitlePane.this.menuBar != null) {
                int menuBarLeft;
                spacing = 5;
                block0 : switch (iconGravity) {
                    case OPPOSITE_CONTROL_BUTTONS: {
                        menuBarLeft = controlButtonsOnRight ? spacing : w - buttonWidth - spacing;
                        break;
                    }
                    case NEXT_TO_TITLE: {
                        Rectangle titleRect = SubstanceTitlePaneUtilities.getTitlePaneTextRectangle(SubstanceInternalFrameTitlePane.this, SubstanceInternalFrameTitlePane.this.frame);
                        String displayTitle = SubstanceInternalFrameTitlePane.this.getDisplayTitle();
                        FontUIResource font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
                        int displayTitleWidth = SubstanceMetricsUtilities.getFontMetrics(font).stringWidth(displayTitle);
                        switch (titleTextGravity) {
                            case LEADING: {
                                menuBarLeft = leftToRight ? titleRect.x - buttonWidth - spacing : titleRect.x + titleRect.width + spacing;
                                break block0;
                            }
                            case TRAILING: {
                                menuBarLeft = leftToRight ? titleRect.x + titleRect.width - displayTitleWidth - buttonWidth - spacing : titleRect.x + titleRect.width + spacing;
                                break block0;
                            }
                        }
                        int displayTitleLeft = titleRect.x + (titleRect.width - displayTitleWidth) / 2;
                        menuBarLeft = leftToRight ? displayTitleLeft - buttonWidth - spacing : displayTitleLeft + displayTitleWidth + spacing;
                        break;
                    }
                    default: {
                        menuBarLeft = -1;
                    }
                }
                if (menuBarLeft >= 0) {
                    SubstanceInternalFrameTitlePane.this.menuBar.setVisible(true);
                    SubstanceInternalFrameTitlePane.this.menuBar.setBounds(menuBarLeft, y, buttonWidth, buttonHeight);
                } else {
                    SubstanceInternalFrameTitlePane.this.menuBar.setVisible(false);
                }
            }
            x = controlButtonsOnRight ? w : 0;
            spacing = 3;
            SubstanceInternalFrameTitlePane.this.closeButton.setVisible(SubstanceInternalFrameTitlePane.this.frame.isClosable());
            if (SubstanceInternalFrameTitlePane.this.frame.isClosable()) {
                SubstanceInternalFrameTitlePane.this.closeButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!controlButtonsOnRight) {
                    x += buttonWidth;
                }
            }
            SubstanceInternalFrameTitlePane.this.maxButton.setVisible(SubstanceInternalFrameTitlePane.this.frame.isMaximizable());
            if (SubstanceInternalFrameTitlePane.this.frame.isMaximizable()) {
                spacing = SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4;
                SubstanceInternalFrameTitlePane.this.maxButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!controlButtonsOnRight) {
                    x += buttonWidth;
                }
            }
            SubstanceInternalFrameTitlePane.this.iconButton.setVisible(SubstanceInternalFrameTitlePane.this.frame.isIconifiable());
            if (SubstanceInternalFrameTitlePane.this.frame.isIconifiable()) {
                spacing = SubstanceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                SubstanceInternalFrameTitlePane.this.iconButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!controlButtonsOnRight) {
                    x += buttonWidth;
                }
            }
        }
    }

    public static class ClickListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton src = (AbstractButton)e.getSource();
            ButtonModel model = src.getModel();
            model.setArmed(false);
            model.setPressed(false);
            model.setRollover(false);
            model.setSelected(false);
        }
    }
}

