/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.api.tabbed.BaseTabCloseListener;
import org.pushingpixels.substance.api.tabbed.MultipleTabCloseListener;
import org.pushingpixels.substance.api.tabbed.TabCloseCallback;
import org.pushingpixels.substance.api.tabbed.TabCloseListener;
import org.pushingpixels.substance.api.tabbed.VetoableMultipleTabCloseListener;
import org.pushingpixels.substance.api.tabbed.VetoableTabCloseListener;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.ImageHashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollButton;
import org.pushingpixels.trident.api.Timeline;
import org.pushingpixels.trident.api.callback.TimelineCallback;
import org.pushingpixels.trident.api.swing.EventDispatchThreadTimelineCallbackAdapter;
import org.pushingpixels.trident.api.swing.SwingComponentTimeline;

public class SubstanceTabbedPaneUI
extends BasicTabbedPaneUI {
    private Point substanceMouseLocation;
    private static LazyResettableHashMap<BufferedImage> backgroundMap = new LazyResettableHashMap("SubstanceTabbedPaneUI.background");
    private static LazyResettableHashMap<BufferedImage> closeButtonMap = new LazyResettableHashMap("SubstanceTabbedPaneUI.closeButton");
    private Map<Component, Timeline> modifiedTimelines;
    private int currSelectedIndex = -1;
    private StateTransitionMultiTracker<Integer> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    private Set<SubstanceWidget<JComponent>> lafWidgets;
    private MouseRolloverHandler substanceRolloverHandler;
    private TabbedContainerListener substanceContainerListener;
    private ChangeListener substanceSelectionListener;
    private boolean substanceContentOpaque;
    private Map<Integer, Color> tabTextColorMap = new HashMap<Integer, Color>();

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceTabbedPaneUI();
    }

    private SubstanceTabbedPaneUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceRolloverHandler = new MouseRolloverHandler();
        this.tabPane.addMouseMotionListener(this.substanceRolloverHandler);
        this.tabPane.addMouseListener(this.substanceRolloverHandler);
        this.substanceContainerListener = new TabbedContainerListener();
        this.substanceContainerListener.trackExistingTabs();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component tabComp = this.tabPane.getComponentAt(i);
            if (!SubstanceCoreUtilities.isTabModified(tabComp)) continue;
            this.trackTabModification(i, tabComp);
        }
        this.tabPane.addContainerListener(this.substanceContainerListener);
        this.substanceSelectionListener = changeEvent -> SwingUtilities.invokeLater(() -> {
            StateTransitionTracker tracker;
            if (this.tabPane == null) {
                return;
            }
            int selected = this.tabPane.getSelectedIndex();
            if (this.currSelectedIndex >= 0 && this.currSelectedIndex < this.tabPane.getTabCount() && this.tabPane.isEnabledAt(this.currSelectedIndex)) {
                tracker = this.getTracker(this.currSelectedIndex, this.getRolloverTabIndex() == this.currSelectedIndex, true);
                tracker.getModel().setSelected(false);
            }
            this.currSelectedIndex = selected;
            if (selected >= 0 && selected < this.tabPane.getTabCount() && this.tabPane.isEnabledAt(selected)) {
                tracker = this.getTracker(selected, this.getRolloverTabIndex() == selected, false);
                tracker.getModel().setSelected(true);
            }
        });
        this.tabPane.getModel().addChangeListener(this.substanceSelectionListener);
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.substanceRolloverHandler != null) {
            this.tabPane.removeMouseMotionListener(this.substanceRolloverHandler);
            this.tabPane.removeMouseListener(this.substanceRolloverHandler);
            this.substanceRolloverHandler = null;
        }
        if (this.substanceContainerListener != null) {
            for (Map.Entry entry : this.substanceContainerListener.listeners.entrySet()) {
                Component comp = (Component)entry.getKey();
                for (PropertyChangeListener pcl : (List)entry.getValue()) {
                    comp.removePropertyChangeListener(pcl);
                }
            }
            this.substanceContainerListener.listeners.clear();
            this.tabPane.removeContainerListener(this.substanceContainerListener);
            this.substanceContainerListener = null;
        }
        this.tabPane.getModel().removeChangeListener(this.substanceSelectionListener);
        this.substanceSelectionListener = null;
        for (SubstanceWidget substanceWidget : this.lafWidgets) {
            substanceWidget.uninstallListeners();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.substanceContentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        this.modifiedTimelines = new HashMap<Component, Timeline>();
        this.currSelectedIndex = this.tabPane.getSelectedIndex();
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        for (Timeline timeline : this.modifiedTimelines.values()) {
            timeline.cancel();
        }
        this.modifiedTimelines.clear();
        for (SubstanceWidget substanceWidget : this.lafWidgets) {
            substanceWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void uninstallComponents() {
        for (SubstanceWidget<JComponent> lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
        super.uninstallComponents();
    }

    private static BufferedImage getTabBackground(JTabbedPane tabPane, int width, int height, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, boolean paintOnlyBorder) {
        double scale = NeonCortex.getScaleFactor((Component)tabPane);
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(tabPane);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(tabPane);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(tabPane);
        float borderDelta = 2.0f * SubstanceSizeUtils.getBorderStrokeWidth(tabPane);
        float borderInsets = SubstanceSizeUtils.getBorderStrokeWidth(tabPane) / 2.0f;
        int dy = (int)(2.0f + borderDelta);
        EnumSet<SubstanceSlices.Side> straightSides = EnumSet.of(SubstanceSlices.Side.BOTTOM);
        float cornerRadius = (float)height / 3.0f;
        if (shaper instanceof ClassicButtonShaper) {
            cornerRadius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(tabPane));
            --width;
        }
        Shape contour = SubstanceOutlineUtilities.getBaseOutline(width, height + dy, cornerRadius, straightSides, borderInsets);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(scale, width, height);
        Graphics2D resGraphics = result.createGraphics();
        if (!paintOnlyBorder) {
            fillPainter.paintContourBackground(resGraphics, tabPane, width, height + dy, contour, false, fillScheme, true);
        }
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth(tabPane);
        Shape contourInner = borderPainter.isPaintingInnerContour() ? SubstanceOutlineUtilities.getBaseOutline(width, height + dy, cornerRadius - borderThickness, straightSides, borderThickness + borderInsets) : null;
        borderPainter.paintBorder(resGraphics, tabPane, width, height + dy, contour, contourInner, borderScheme);
        resGraphics.dispose();
        return result;
    }

    private static BufferedImage getFinalTabBackgroundImage(JTabbedPane tabPane, int tabIndex, int width, int height, int tabPlacement, SubstanceSlices.Side side, SubstanceColorScheme colorScheme, SubstanceColorScheme borderScheme) {
        Color tabColor;
        double scale = NeonCortex.getScaleFactor((Component)tabPane);
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(tabPane);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(tabPane);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(tabPane);
        Component compForBackground = tabPane.getTabComponentAt(tabIndex);
        if (compForBackground == null) {
            compForBackground = tabPane.getComponentAt(tabIndex);
        }
        if (compForBackground == null) {
            compForBackground = tabPane;
        }
        if ((tabColor = compForBackground.getBackground()) instanceof UIResource) {
            tabColor = SubstanceColorUtilities.getBackgroundFillColor(compForBackground);
        }
        ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, width, height, tabPlacement, fillPainter.getDisplayName(), borderPainter.getDisplayName(), shaper.getDisplayName(), tabPlacement == 3, side.name(), colorScheme.getDisplayName(), borderScheme.getDisplayName(), tabColor);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(tabPane);
        BufferedImage result = backgroundMap.get(key);
        if (result == null) {
            BufferedImage backgroundImage = null;
            switch (tabPlacement) {
                case 3: {
                    BufferedImage unrotated = SubstanceTabbedPaneUI.getFinalTabBackgroundImage(tabPane, tabIndex, width, height, 1, side, colorScheme, borderScheme);
                    return SubstanceImageCreator.getRotated(scale, unrotated, 2);
                }
                case 1: 
                case 2: 
                case 4: {
                    backgroundImage = SubstanceTabbedPaneUI.getTabBackground(tabPane, width, height, colorScheme, borderScheme, false);
                    int fw = backgroundImage.getWidth();
                    int fh = backgroundImage.getHeight();
                    BufferedImage fade = SubstanceCoreUtilities.getBlankUnscaledImage(backgroundImage);
                    Graphics2D fadeGraphics = fade.createGraphics();
                    fadeGraphics.setColor(tabColor);
                    fadeGraphics.fillRect(0, 0, fw, fh);
                    BufferedImage background = SubstanceTabbedPaneUI.getTabBackground(tabPane, width, height, colorScheme, borderScheme, true);
                    fadeGraphics.drawImage(background, 0, 0, background.getWidth(), background.getHeight(), null);
                    backgroundImage = SubstanceCoreUtilities.blendImagesVertical(backgroundImage, fade, skin.getTabFadeStart(), skin.getTabFadeEnd());
                }
            }
            backgroundMap.put(key, backgroundImage);
        }
        return backgroundMap.get(key);
    }

    private static BufferedImage getCloseButtonImage(JTabbedPane tabPane, int width, int height, boolean toPaintBorder, SubstanceColorScheme fillScheme, SubstanceColorScheme markScheme) {
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(tabPane);
        if (fillPainter == null) {
            return null;
        }
        double scale = NeonCortex.getScaleFactor((Component)tabPane);
        ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, width, height, toPaintBorder, fillPainter.getDisplayName(), fillScheme.getDisplayName(), markScheme.getDisplayName());
        BufferedImage result = closeButtonMap.get(key);
        if (result == null) {
            result = SubstanceCoreUtilities.getBlankImage(scale, width, height);
            Graphics2D finalGraphics = (Graphics2D)result.getGraphics().create();
            if (toPaintBorder) {
                Shape contour = SubstanceOutlineUtilities.getBaseOutline(width, height, 1.0f, null);
                fillPainter.paintContourBackground(finalGraphics, tabPane, width, height, contour, false, fillScheme, true);
                SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(tabPane);
                finalGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                borderPainter.paintBorder(finalGraphics, tabPane, width, height, contour, null, markScheme);
            }
            finalGraphics.setStroke(new BasicStroke(SubstanceSizeUtils.getTabCloseButtonStrokeWidth(tabPane)));
            int delta = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(tabPane));
            if (delta % 2 != 0) {
                --delta;
            }
            int iconSize = width - delta;
            ScaleAwareImageWrapperIcon closeIcon = SubstanceImageCreator.getCloseIcon(tabPane, iconSize, markScheme);
            finalGraphics.translate(delta / 2, delta / 2);
            closeIcon.paintIcon(tabPane, finalGraphics, 0, 0);
            finalGraphics.dispose();
            closeButtonMap.put(key, result);
        }
        return result;
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        BufferedImage fullOpacity;
        boolean isRollover;
        double scale = NeonCortex.getScaleFactor((Component)this.tabPane);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)this.tabPane, g));
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        ComponentState currState = this.getTabState(tabIndex, false);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(tabIndex);
        boolean bl = isRollover = this.getRolloverTab() == tabIndex;
        if (!isSelected && !isRollover && modelStateInfo == null) {
            return;
        }
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, currState);
        SubstanceColorScheme baseColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB, currState);
        --w;
        Component comp = this.tabPane.getComponentAt(tabIndex);
        boolean isWindowModified = SubstanceCoreUtilities.isTabModified(comp);
        boolean toMarkModifiedCloseButton = SubstanceCoreUtilities.toAnimateCloseIconOfModifiedTab(this.tabPane, tabIndex);
        if (isWindowModified && isEnabled && !toMarkModifiedCloseButton) {
            SubstanceColorScheme colorScheme2 = SubstanceColorSchemeUtilities.YELLOW;
            SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.ORANGE;
            float cyclePos = this.modifiedTimelines.get(comp).getTimelinePosition();
            BufferedImage layer1 = SubstanceTabbedPaneUI.getFinalTabBackgroundImage(this.tabPane, tabIndex, w, h, tabPlacement, SubstanceSlices.Side.BOTTOM, colorScheme, baseBorderScheme);
            BufferedImage layer2 = SubstanceTabbedPaneUI.getFinalTabBackgroundImage(this.tabPane, tabIndex, w, h, tabPlacement, SubstanceSlices.Side.BOTTOM, colorScheme2, baseBorderScheme);
            fullOpacity = SubstanceCoreUtilities.getBlankUnscaledImage(layer1);
            Graphics2D g2d = fullOpacity.createGraphics();
            if (cyclePos < 1.0f) {
                g2d.drawImage(layer1, 0, 0, layer1.getWidth(), layer1.getHeight(), null);
            }
            if (cyclePos > 0.0f) {
                g2d.setComposite(AlphaComposite.SrcOver.derive(cyclePos));
                g2d.drawImage(layer2, 0, 0, layer2.getWidth(), layer2.getHeight(), null);
            }
            g2d.dispose();
        } else {
            BufferedImage layerBase = SubstanceTabbedPaneUI.getFinalTabBackgroundImage(this.tabPane, tabIndex, w, h, tabPlacement, SubstanceSlices.Side.BOTTOM, baseColorScheme, baseBorderScheme);
            if (modelStateInfo == null || currState.isDisabled() || modelStateInfo.getStateContributionMap().size() == 1) {
                fullOpacity = layerBase;
            } else {
                fullOpacity = SubstanceCoreUtilities.getBlankUnscaledImage(layerBase);
                Graphics2D g2d = fullOpacity.createGraphics();
                g2d.drawImage(layerBase, 0, 0, layerBase.getWidth(), layerBase.getHeight(), null);
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                    float stateContribution;
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
                    g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
                    SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB, activeState);
                    SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, activeState);
                    BufferedImage layer = SubstanceTabbedPaneUI.getFinalTabBackgroundImage(this.tabPane, tabIndex, w, h, tabPlacement, SubstanceSlices.Side.BOTTOM, fillScheme, borderScheme);
                    g2d.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
                }
            }
        }
        boolean isCloseMarkOnParentBackground = SubstanceCoreUtilities.getSkin(this.tabPane).getTabFadeEnd() <= 0.5;
        ComponentState markState = currState;
        if (isCloseMarkOnParentBackground) {
            markState = this.getTabState(tabIndex, true);
        }
        SubstanceColorScheme baseMarkScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, isCloseMarkOnParentBackground ? SubstanceSlices.ColorSchemeAssociationKind.FILL : SubstanceSlices.ColorSchemeAssociationKind.MARK, markState);
        graphics.clip(new Rectangle(x, y, w, h));
        float finalAlpha = 0.0f;
        StateTransitionTracker tabTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
        if (!isSelected && modelStateInfo != null) {
            finalAlpha += tabTracker.getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER);
        } else if (isRollover || isSelected) {
            finalAlpha = 1.0f;
        }
        graphics.setComposite(WidgetUtilities.getAlphaComposite(this.tabPane, finalAlpha *= SubstanceColorSchemeUtilities.getAlpha(this.tabPane.getComponentAt(tabIndex), currState), g));
        NeonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)fullOpacity, (int)x, (int)y);
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && isEnabled) {
            float alpha;
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            float f = alpha = isSelected || isRollover ? 1.0f : 0.0f;
            if (!isSelected && tabTracker != null) {
                alpha = tabTracker.getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER);
            }
            if ((double)alpha > 0.0) {
                graphics.setComposite(WidgetUtilities.getAlphaComposite(this.tabPane, finalAlpha * alpha, g));
                Rectangle orig = this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
                boolean toPaintCloseBorder = false;
                if (isRollover && this.substanceMouseLocation != null) {
                    Rectangle rect;
                    Rectangle bounds = new Rectangle();
                    bounds = this.getTabBounds(tabIndex, bounds);
                    if (this.toRotateTabsOnPlacement(tabPlacement)) {
                        bounds = new Rectangle(bounds.x, bounds.y, bounds.height, bounds.width);
                    }
                    if ((rect = this.getCloseButtonRectangleForEvents(tabIndex, bounds.x, bounds.y, bounds.width, bounds.height)).contains(this.substanceMouseLocation)) {
                        toPaintCloseBorder = true;
                    }
                }
                if (isWindowModified && isEnabled && toMarkModifiedCloseButton) {
                    SubstanceColorScheme colorScheme2 = SubstanceColorSchemeUtilities.YELLOW;
                    SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.ORANGE;
                    float cyclePos = this.modifiedTimelines.get(comp).getTimelinePosition();
                    BufferedImage layer1 = SubstanceTabbedPaneUI.getCloseButtonImage(this.tabPane, orig.width, orig.height, toPaintCloseBorder, colorScheme, baseMarkScheme);
                    BufferedImage layer2 = SubstanceTabbedPaneUI.getCloseButtonImage(this.tabPane, orig.width, orig.height, toPaintCloseBorder, colorScheme2, baseMarkScheme);
                    if (cyclePos < 1.0f) {
                        NeonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)layer1, (int)orig.x, (int)orig.y);
                    }
                    if (cyclePos > 0.0f) {
                        graphics.setComposite(AlphaComposite.SrcOver.derive(cyclePos));
                        NeonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)layer2, (int)orig.x, (int)orig.y);
                    }
                } else {
                    BufferedImage layerBase = SubstanceTabbedPaneUI.getCloseButtonImage(this.tabPane, orig.width, orig.height, toPaintCloseBorder, baseColorScheme, baseMarkScheme);
                    if (modelStateInfo == null || currState.isDisabled() || modelStateInfo.getStateContributionMap().size() == 1) {
                        NeonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)layerBase, (int)orig.x, (int)orig.y);
                    } else {
                        BufferedImage complete = SubstanceCoreUtilities.getBlankUnscaledImage(layerBase);
                        Graphics2D g2d = complete.createGraphics();
                        g2d.drawImage(layerBase, 0, 0, layerBase.getWidth(), layerBase.getHeight(), null);
                        Map<ComponentState, StateTransitionTracker.StateContributionInfo> contributionInfoMap = isCloseMarkOnParentBackground ? modelStateInfo.getStateNoSelectionContributionMap() : modelStateInfo.getStateContributionMap();
                        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : contributionInfoMap.entrySet()) {
                            float stateContribution;
                            ComponentState activeState = activeEntry.getKey();
                            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
                            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
                            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB, activeState);
                            SubstanceColorScheme markScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, isCloseMarkOnParentBackground ? SubstanceSlices.ColorSchemeAssociationKind.FILL : SubstanceSlices.ColorSchemeAssociationKind.MARK, activeState);
                            BufferedImage layer = SubstanceTabbedPaneUI.getCloseButtonImage(this.tabPane, orig.width, orig.height, toPaintCloseBorder, fillScheme, markScheme);
                            g2d.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
                        }
                        g2d.dispose();
                        NeonCortex.drawImageWithScale((Graphics)graphics, (double)scale, (Image)complete, (int)orig.x, (int)orig.y);
                    }
                }
            }
        }
        graphics.dispose();
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected JButton createScrollButton(int direction) {
        double scale = NeonCortex.getScaleFactor((Component)this.tabPane);
        SubstanceScrollButton ssb = new SubstanceScrollButton();
        TransitionAwareIcon icon = new TransitionAwareIcon(ssb, scheme -> {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.tabPane);
            return SubstanceImageCreator.getArrowIcon(scale, fontSize, direction, scheme);
        }, "substance.tabbedpane.scroll." + direction);
        ssb.setIcon(icon);
        return ssb;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (toSwap) {
            return this.getTabExtraWidth(tabPlacement, tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, this.getFontMetrics());
        }
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (toSwap) {
            return super.calculateTabHeight(tabPlacement, tabIndex, metrics.getHeight());
        }
        return this.getTabExtraWidth(tabPlacement, tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, metrics);
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        if (this.toRotateTabsOnPlacement(tabPlacement)) {
            return super.calculateMaxTabHeight(tabPlacement);
        }
        int result = 0;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            result = Math.max(result, this.calculateTabHeight(tabPlacement, i, this.getFontMetrics().getHeight()));
        }
        return result;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (toSwap) {
            return super.getTabRunOverlay(tabPlacement);
        }
        return 0;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (this.tabPane.getLayout().getClass() == TabbedPaneLayout.class) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        }
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        Graphics2D g2d = (Graphics2D)g.create(x, y, w, h);
        BackgroundPaintingUtils.update(g2d, c, false);
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (toSwap) {
            Graphics2D tempG = (Graphics2D)g.create();
            Rectangle tabRect = rects[tabIndex];
            Rectangle correctRect = new Rectangle(tabRect.x, tabRect.y, tabRect.height, tabRect.width);
            if (tabPlacement == 2) {
                tempG.rotate(-1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(-tabRect.height, 0);
            } else {
                tempG.rotate(1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(0.0, -tabRect.getWidth());
            }
            tempG.setColor(Color.red);
            rects[tabIndex] = correctRect;
            super.paintTab(tempG, tabPlacement, rects, tabIndex, iconRect, textRect);
            rects[tabIndex] = tabRect;
            tempG.dispose();
        } else if (this.tabPane.getLayout().getClass() == TabbedPaneLayout.class) {
            super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        } else {
            Graphics2D g2d = (Graphics2D)g.create();
            NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.tabPane.getFont());
            super.paintTab(g2d, tabPlacement, rects, tabIndex, iconRect, textRect);
            g2d.dispose();
        }
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.substanceContentOpaque) {
            int width = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
            if (tabPlacement == 1 || tabPlacement == 3) {
                width = Math.max(width, this.tabPane.getWidth());
            }
            int height = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
            if (this.toRotateTabsOnPlacement(tabPlacement)) {
                height = Math.max(height, this.tabPane.getHeight());
            }
            Graphics2D g2d = (Graphics2D)g.create(0, 0, width, height);
            BackgroundPaintingUtils.update(g2d, this.tabPane, true);
            g2d.dispose();
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    protected Rectangle getCloseButtonRectangleForDraw(int tabIndex, int x, int y, int width, int height) {
        int dimension = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        int borderDelta = (int)Math.ceil(3.0f + SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane));
        int xs = this.tabPane.getComponentOrientation().isLeftToRight() ? x + width - dimension - borderDelta : x + borderDelta;
        int ys = y + (height - dimension) / 2 + 1;
        if (this.tabPane.getTabPlacement() == 3) {
            ys -= 2;
        }
        return new Rectangle(xs, ys, dimension, dimension);
    }

    protected Rectangle getCloseButtonRectangleForEvents(int tabIndex, int x, int y, int w, int h) {
        Point2D transCorner;
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean toSwap = this.toRotateTabsOnPlacement(tabPlacement);
        if (!toSwap) {
            return this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
        }
        int dimension = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        Rectangle rectForDraw = this.getCloseButtonRectangleForDraw(tabIndex, x, y, h, w);
        AffineTransform trans = new AffineTransform();
        if (tabPlacement == 2) {
            trans.rotate(-1.5707963267948966, x, y);
            trans.translate(-h, 0.0);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMaxX(), rectForDraw.getMinY());
            transCorner = trans.transform(origCorner, null);
        } else {
            trans.rotate(1.5707963267948966, x, y);
            trans.translate(0.0, -w);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMinX(), rectForDraw.getMaxY());
            transCorner = trans.transform(origCorner, null);
        }
        return new Rectangle((int)transCorner.getX(), (int)transCorner.getY(), dimension, dimension);
    }

    protected void ensureCurrentLayout() {
        LayoutManager lm;
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid() && (lm = this.tabPane.getLayout()) instanceof BasicTabbedPaneUI.TabbedPaneLayout) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)lm;
            layout.calculateLayoutInfo();
        }
    }

    protected void tryCloseTabs(int tabIndex, SubstanceSlices.TabCloseKind tabCloseKind) {
        if (tabCloseKind == null) {
            return;
        }
        if (tabCloseKind == SubstanceSlices.TabCloseKind.NONE) {
            return;
        }
        if (tabCloseKind == SubstanceSlices.TabCloseKind.ALL_BUT_THIS) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                if (i == tabIndex) continue;
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        if (tabCloseKind == SubstanceSlices.TabCloseKind.ALL) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        this.tryCloseTab(tabIndex);
    }

    protected void tryCloseTab(int tabIndex) {
        Component component = this.tabPane.getComponentAt(tabIndex);
        HashSet<Component> componentSet = new HashSet<Component>();
        componentSet.add(component);
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : SubstanceCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            BaseTabCloseListener vetoableListener;
            if (listener instanceof VetoableTabCloseListener) {
                vetoableListener = (VetoableTabCloseListener)listener;
                boolean bl = isVetoed = isVetoed || vetoableListener.vetoTabClosing(this.tabPane, component);
            }
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : SubstanceCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosing(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        this.tabPane.remove(tabIndex);
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : SubstanceCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosed(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    protected void tryCloseTabs(Set<Integer> tabIndexes) {
        HashSet<Component> componentSet = new HashSet<Component>();
        for (int tabIndex : tabIndexes) {
            componentSet.add(this.tabPane.getComponentAt(tabIndex));
        }
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : SubstanceCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            VetoableMultipleTabCloseListener vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : SubstanceCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        for (Component toRemove : componentSet) {
            this.tabPane.remove(toRemove);
        }
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : SubstanceCortex.ComponentScope.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int delta = 0;
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex)) {
            delta = this.tabPane.getComponentOrientation().isLeftToRight() ? 5 - SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex) : SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex) - 5;
        }
        return delta + super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return tabPlacement == 3 ? -1 : 1;
    }

    protected int getTabExtraWidth(int tabPlacement, int tabIndex) {
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
        int extraWidth = shaper instanceof ClassicButtonShaper ? (int)(2.0 * (double)SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.tabPane))) : super.calculateTabHeight(tabPlacement, tabIndex, this.getFontMetrics().getHeight()) / 3;
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && this.tabPane.isEnabledAt(tabIndex)) {
            extraWidth += 4 + SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        }
        return extraWidth;
    }

    public int getRolloverTabIndex() {
        return this.getRolloverTab();
    }

    public void setTabAreaInsets(Insets insets) {
        Insets old = this.tabAreaInsets;
        this.tabAreaInsets = insets;
        WidgetUtilities.firePropertyChangeEvent(this.tabPane, "tabAreaInsets", old, this.tabAreaInsets);
    }

    public Insets getTabAreaInsets() {
        return this.tabAreaInsets;
    }

    public Rectangle getTabRectangle(int tabIndex) {
        return this.rects[tabIndex];
    }

    @Override
    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1 && run < this.runCount - 1;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TabbedPaneLayout();
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        int delta;
        Insets insets = SubstanceSizeUtils.getTabbedPaneContentInsets(this.tabPane);
        SubstanceSlices.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean isPlacement = kind == SubstanceSlices.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        int n = delta = isDouble ? (int)Math.ceil(SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane) + 1.5f) : 0;
        if (isPlacement) {
            switch (tabPlacement) {
                case 1: {
                    return new Insets(insets.top + delta, 0, 0, 0);
                }
                case 2: {
                    return new Insets(0, insets.left + delta, 0, 0);
                }
                case 4: {
                    return new Insets(0, 0, 0, insets.right + delta);
                }
                case 3: {
                    return new Insets(0, 0, insets.bottom + delta, 0);
                }
            }
        } else {
            switch (tabPlacement) {
                case 1: {
                    return new Insets(insets.top + delta, insets.left, insets.bottom, insets.right);
                }
                case 2: {
                    return new Insets(insets.top, insets.left + delta, insets.bottom, insets.right);
                }
                case 4: {
                    return new Insets(insets.top, insets.left, insets.bottom, insets.right + delta);
                }
                case 3: {
                    return new Insets(insets.top, insets.left, insets.bottom + delta, insets.right);
                }
            }
        }
        return insets;
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB, ComponentState.ENABLED);
        this.highlight = scheme.getSeparatorSecondaryColor();
        super.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean isPlacement;
        SubstanceSlices.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl = isPlacement = kind == SubstanceSlices.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (isPlacement && tabPlacement != 3) {
            return;
        }
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane);
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        int offset = (int)((double)strokeWidth / 2.0);
        int ribbonDelta = (int)Math.ceil(strokeWidth + 1.5f);
        boolean isUnbroken = tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w;
        x += offset;
        y += offset;
        w -= 2 * offset;
        h -= 2 * offset;
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
        Color darkShadowColor = SubstanceColorUtilities.getMidBorderColor(borderScheme);
        if (isUnbroken) {
            g2d.setColor(this.highlight);
            g2d.drawLine(x, y + h - 1, x + w, y + h - 1);
        } else {
            SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
            int delta = shaper instanceof ClassicButtonShaper ? 1 : 0;
            float borderInsets = SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane) / 2.0f;
            GeneralPath bottomOutline = new GeneralPath();
            bottomOutline.moveTo(x, y + h - 1);
            bottomOutline.lineTo((float)selRect.x + borderInsets, y + h - 1);
            int bumpHeight = super.calculateTabHeight(tabPlacement, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            bottomOutline.lineTo((float)selRect.x + borderInsets, y + h + bumpHeight);
            if (selRect.x + selRect.width < x + w) {
                float selectionEndX = (float)(selRect.x + selRect.width - delta - 1) - borderInsets;
                bottomOutline.lineTo(selectionEndX, y + h - 1 + bumpHeight);
                bottomOutline.lineTo(selectionEndX, y + h - 1);
                bottomOutline.lineTo(x + w, y + h - 1);
            }
            g2d.setPaint(new GradientPaint(x, y + h - 1, darkShadowColor, x, y + h - 1 + bumpHeight, SubstanceColorUtilities.getAlphaColor(darkShadowColor, 0)));
            g2d.draw(bottomOutline);
        }
        if (isDouble) {
            if (tabPlacement == 3) {
                g2d.setColor(this.highlight);
                g2d.setColor(darkShadowColor);
                g2d.drawLine(x, y + h - 1 - ribbonDelta, x + w, y + h - 1 - ribbonDelta);
            }
            if (tabPlacement == 2) {
                g2d.setPaint(new GradientPaint(x, y + h - 1, darkShadowColor, x + 4 * ribbonDelta, y + h - 1, this.highlight));
                g2d.drawLine(x, y + h - 1, x + 4 * ribbonDelta, y + h - 1);
            }
            if (tabPlacement == 4) {
                g2d.setPaint(new GradientPaint(x + w - 1 - 4 * ribbonDelta, y + h - 1, this.highlight, x + w - 1, y + h - 1, darkShadowColor));
                g2d.drawLine(x + w - 1 - 4 * ribbonDelta, y + h - 1, x + w - 1, y + h - 1);
            }
        }
        g2d.dispose();
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean isPlacement;
        SubstanceSlices.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl = isPlacement = kind == SubstanceSlices.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (isPlacement && tabPlacement != 2) {
            return;
        }
        int ribbonDelta = (int)(SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane) + 1.5f);
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane);
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        int offset = (int)((double)strokeWidth / 2.0);
        boolean isUnbroken = tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h;
        x += offset;
        y += offset;
        h -= 2 * offset;
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
        Color darkShadowColor = SubstanceColorUtilities.getMidBorderColor(borderScheme);
        if (isUnbroken) {
            g2d.setColor(this.highlight);
            g2d.drawLine(x, y, x, y + h);
        } else {
            SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
            boolean delta = shaper instanceof ClassicButtonShaper;
            float borderInsets = SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane) / 2.0f;
            GeneralPath leftOutline = new GeneralPath();
            leftOutline.moveTo(x, y);
            leftOutline.lineTo(x, (float)selRect.y + borderInsets + (float)delta + 1.0f);
            int bumpWidth = super.calculateTabHeight(tabPlacement, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            leftOutline.lineTo(x - bumpWidth, (float)selRect.y + borderInsets + (float)delta + 1.0f);
            if (selRect.y + selRect.height < y + h) {
                float selectionEndY = (float)(selRect.y + selRect.height) - borderInsets;
                leftOutline.lineTo(x - bumpWidth, selectionEndY);
                leftOutline.lineTo(x, selectionEndY);
                leftOutline.lineTo(x, y + h);
            }
            g2d.setPaint(new GradientPaint(x, y, darkShadowColor, x - bumpWidth, y, SubstanceColorUtilities.getAlphaColor(darkShadowColor, 0)));
            g2d.draw(leftOutline);
        }
        if (isDouble) {
            if (tabPlacement == 2) {
                g2d.setColor(darkShadowColor);
                g2d.drawLine(x + ribbonDelta, y, x + ribbonDelta, y + h);
            }
            if (tabPlacement == 1) {
                g2d.setPaint(new GradientPaint(x, y, darkShadowColor, x, y + 4 * ribbonDelta, this.highlight));
                g2d.drawLine(x, y, x, y + 4 * ribbonDelta);
            }
            if (tabPlacement == 3) {
                g2d.setPaint(new GradientPaint(x, y + h - 1 - 4 * ribbonDelta, this.highlight, x, y + h - 1, darkShadowColor));
                g2d.drawLine(x, y + h - 1 - 4 * ribbonDelta, x, y + h - 1);
            }
        }
        g2d.dispose();
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean isPlacement;
        SubstanceSlices.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl = isPlacement = kind == SubstanceSlices.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (isPlacement && tabPlacement != 4) {
            return;
        }
        int ribbonDelta = (int)(SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane) + 1.5f);
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane);
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        int offset = (int)((double)strokeWidth / 2.0);
        boolean isUnbroken = tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h;
        x += offset;
        y += offset;
        w -= 2 * offset;
        h -= 2 * offset;
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
        Color darkShadowColor = SubstanceColorUtilities.getMidBorderColor(borderScheme);
        if (isUnbroken) {
            g2d.setColor(this.highlight);
            g2d.drawLine(x + w - 1, y, x + w - 1, y + h);
        } else {
            SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
            int delta = shaper instanceof ClassicButtonShaper ? 1 : 0;
            float borderInsets = SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane) / 2.0f;
            GeneralPath rightOutline = new GeneralPath();
            rightOutline.moveTo(x + w - 1, y);
            rightOutline.lineTo(x + w - 1, (float)selRect.y + borderInsets);
            int bumpWidth = super.calculateTabHeight(tabPlacement, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            rightOutline.lineTo(x + w - 1 + bumpWidth, (float)selRect.y + borderInsets);
            if (selRect.y + selRect.height < y + h) {
                float selectionEndY = (float)(selRect.y + selRect.height - delta - 1) - borderInsets;
                rightOutline.lineTo(x + w - 1 + bumpWidth, selectionEndY);
                rightOutline.lineTo(x + w - 1, selectionEndY);
                rightOutline.lineTo(x + w - 1, y + h);
            }
            g2d.setPaint(new GradientPaint(x + w - 1, y, darkShadowColor, x + w - 1 + bumpWidth, y, SubstanceColorUtilities.getAlphaColor(darkShadowColor, 0)));
            g2d.draw(rightOutline);
        }
        if (isDouble) {
            if (tabPlacement == 4) {
                g2d.setColor(this.highlight);
                g2d.setColor(darkShadowColor);
                g2d.drawLine(x + w - 1 - ribbonDelta, y, x + w - 1 - ribbonDelta, y + h);
            }
            if (tabPlacement == 1) {
                g2d.setPaint(new GradientPaint(x + w - 1, y, darkShadowColor, x + w - 1, y + 4 * ribbonDelta, this.highlight));
                g2d.drawLine(x + w - 1, y, x + w - 1, y + 4 * ribbonDelta);
            }
            if (tabPlacement == 3) {
                g2d.setPaint(new GradientPaint(x + w - 1, y + h - 1 - 4 * ribbonDelta, this.highlight, x + w - 1, y + h - 1, darkShadowColor));
                g2d.drawLine(x + w - 1, y + h - 1 - 4 * ribbonDelta, x + w - 1, y + h - 1);
            }
        }
        g2d.dispose();
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean isPlacement;
        SubstanceSlices.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl = isPlacement = kind == SubstanceSlices.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (isPlacement && tabPlacement != 1) {
            return;
        }
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane);
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        int offset = (int)((double)strokeWidth / 2.0);
        int ribbonDelta = (int)Math.ceil(strokeWidth + 1.5f);
        boolean isUnbroken = tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w;
        x += offset;
        y += offset;
        w -= 2 * offset;
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, selectedIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
        Color darkShadowColor = SubstanceColorUtilities.getMidBorderColor(borderScheme);
        if (isUnbroken) {
            g2d.setColor(this.highlight);
            g2d.drawLine(x, y, x + w, y);
        } else {
            SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
            int delta = shaper instanceof ClassicButtonShaper ? 1 : 0;
            float borderInsets = SubstanceSizeUtils.getBorderStrokeWidth(this.tabPane) / 2.0f;
            GeneralPath topOutline = new GeneralPath();
            topOutline.moveTo(x, y);
            topOutline.lineTo((float)selRect.x + borderInsets, y);
            int bumpHeight = super.calculateTabHeight(tabPlacement, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            topOutline.lineTo((float)selRect.x + borderInsets, y - bumpHeight);
            if (selRect.x + selRect.width < x + w) {
                float selectionEndX = (float)(selRect.x + selRect.width - delta - 1) - borderInsets;
                topOutline.lineTo(selectionEndX, y - bumpHeight);
                topOutline.lineTo(selectionEndX, y);
                topOutline.lineTo(x + w, y);
            }
            g2d.setPaint(new GradientPaint(x, y, darkShadowColor, x, y - bumpHeight, SubstanceColorUtilities.getAlphaColor(darkShadowColor, 0)));
            g2d.draw(topOutline);
        }
        if (isDouble) {
            if (tabPlacement == 1) {
                g2d.setColor(darkShadowColor);
                g2d.drawLine(x, y + ribbonDelta, x + w, y + ribbonDelta);
            }
            if (tabPlacement == 2) {
                g2d.setPaint(new GradientPaint(x, y, darkShadowColor, x + 4 * ribbonDelta, y, this.highlight));
                g2d.drawLine(x, y, x + 4 * ribbonDelta, y);
            }
            if (tabPlacement == 4) {
                g2d.setPaint(new GradientPaint(x + w - 1 - 4 * ribbonDelta, y, this.highlight, x + w - 1, y, darkShadowColor));
                g2d.drawLine(x + w - 1 - 4 * ribbonDelta, y, x + w - 1, y);
            }
        }
        g2d.dispose();
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    private StateTransitionTracker.ModelStateInfo getModelStateInfo(int tabIndex) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
        if (tracker == null) {
            return null;
        }
        return tracker.getModelStateInfo();
    }

    protected ComponentState getTabState(int tabIndex, boolean toAllowIgnoringSelectedState) {
        boolean ignoreSelectedState;
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
        boolean bl = ignoreSelectedState = toAllowIgnoringSelectedState && SubstanceCoreUtilities.getSkin(this.tabPane).getTabFadeEnd() <= 0.5;
        if (tracker == null) {
            boolean isRollover;
            boolean bl2 = isRollover = this.getRolloverTabIndex() == tabIndex;
            boolean isSelected = ignoreSelectedState ? false : this.tabPane.getSelectedIndex() == tabIndex;
            return ComponentState.getState(isEnabled, isRollover, isSelected);
        }
        ComponentState fromTracker = ignoreSelectedState ? tracker.getModelStateInfo().getCurrModelStateNoSelection() : tracker.getModelStateInfo().getCurrModelState();
        return fromTracker;
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            boolean isTextOnParentBackground = SubstanceCoreUtilities.getSkin(this.tabPane).getTabFadeEnd() <= 0.5;
            ComponentState currState = this.getTabState(tabIndex, true);
            if (isTextOnParentBackground) {
                currState = this.tabPane.isEnabledAt(tabIndex) ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            }
            StateTransitionTracker.ModelStateInfo modelStateInfo = isTextOnParentBackground ? null : this.getModelStateInfo(tabIndex);
            Color fg = null;
            if (modelStateInfo != null) {
                Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
                SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB, currState);
                if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                    fg = colorScheme.getForegroundColor();
                } else {
                    float aggrRed = 0.0f;
                    float aggrGreen = 0.0f;
                    float aggrBlue = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                        ComponentState activeState = activeEntry.getKey();
                        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB, activeState);
                        Color schemeFg = scheme.getForegroundColor();
                        float contribution = activeEntry.getValue().getContribution();
                        aggrRed += (float)schemeFg.getRed() * contribution;
                        aggrGreen += (float)schemeFg.getGreen() * contribution;
                        aggrBlue += (float)schemeFg.getBlue() * contribution;
                    }
                    fg = new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
                }
            } else {
                SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, tabIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB, currState);
                fg = scheme.getForegroundColor();
            }
            Graphics2D graphics = (Graphics2D)g.create();
            if (currState.isDisabled()) {
                Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor(this.tabPane);
                fg = SubstanceColorUtilities.getInterpolatedColor(fg, bgFillColor, SubstanceColorSchemeUtilities.getAlpha(this.tabPane.getComponentAt(tabIndex), currState));
            }
            graphics.clip(this.getTabRectangle(tabIndex));
            SubstanceTextUtilities.paintText((Graphics)graphics, textRect, title, mnemIndex, graphics.getFont(), fg, null);
            graphics.dispose();
            this.tabTextColorMap.put(tabIndex, fg);
        }
    }

    @Override
    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(iconRect.x, iconRect.y);
        SubstanceSlices.IconThemingStrategy iconThemingStrategy = SubstanceCoreUtilities.getIconThemingType(this.tabPane);
        if (iconThemingStrategy != null) {
            ComponentState currState = this.getTabState(tabIndex, true);
            StateTransitionTracker tabTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
            ScaleAwareImageWrapperIcon themedIcon = SubstanceCoreUtilities.getThemedIcon(this.tabPane, tabIndex, icon, this.tabTextColorMap.get(tabIndex));
            if (tabTracker == null && (currState.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER) || currState.isFacetActive(SubstanceSlices.ComponentStateFacet.SELECTION) || currState.isDisabled())) {
                if (iconThemingStrategy.isForInactiveState()) {
                    icon.paintIcon(this.tabPane, g2d, 0, 0);
                } else {
                    themedIcon.paintIcon(this.tabPane, g2d, 0, 0);
                }
                return;
            }
            if (tabTracker != null) {
                themedIcon.paintIcon(this.tabPane, g2d, 0, 0);
                float activeAmount = tabTracker.getActiveStrength();
                if (activeAmount > 0.0f && iconThemingStrategy != null && iconThemingStrategy.isForInactiveState() && icon != themedIcon) {
                    g2d.setComposite(WidgetUtilities.getAlphaComposite(this.tabPane, activeAmount, g));
                    icon.paintIcon(this.tabPane, g2d, 0, 0);
                }
            } else if (iconThemingStrategy.isForInactiveState() && this.tabPane.getSelectedIndex() == tabIndex) {
                icon.paintIcon(this.tabPane, g2d, 0, 0);
            } else {
                themedIcon.paintIcon(this.tabPane, g2d, 0, 0);
            }
        } else {
            icon.paintIcon(this.tabPane, g2d, 0, 0);
        }
        g2d.dispose();
    }

    @Override
    protected MouseListener createMouseListener() {
        return null;
    }

    protected boolean toRotateTabsOnPlacement(int tabPlacement) {
        return tabPlacement == 2 || tabPlacement == 4;
    }

    private StateTransitionTracker getTracker(int tabIndex, boolean initialRollover, boolean initialSelected) {
        StateTransitionTracker tracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)tabIndex);
        if (tracker == null) {
            DefaultButtonModel model = new DefaultButtonModel();
            model.setSelected(initialSelected);
            model.setRollover(initialRollover);
            tracker = new StateTransitionTracker(this.tabPane, model);
            tracker.registerModelListeners();
            tracker.setRepaintCallback(() -> new TabRepaintCallback(this.tabPane, tabIndex));
            this.stateTransitionMultiTracker.addTracker((Comparable<Integer>)tabIndex, tracker);
        }
        return tracker;
    }

    private void trackTabModification(int tabIndex, Component tabComponent) {
        SwingComponentTimeline modifiedTimeline = ((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().modifiedTimelineBuilder(this.tabPane).addCallback((TimelineCallback)new TabRepaintCallback(this.tabPane, tabIndex))).build();
        modifiedTimeline.playLoop(Timeline.RepeatBehavior.REVERSE);
        this.modifiedTimelines.put(tabComponent, (Timeline)modifiedTimeline);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(SubstanceTabbedPaneUI.this);
        }

        @Override
        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.normalizeTabRuns(tabPlacement, tabCount, start, max);
            }
        }

        @Override
        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        @Override
        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }
    }

    protected class TabRepaintCallback
    extends EventDispatchThreadTimelineCallbackAdapter {
        protected JTabbedPane tabbedPane;
        protected int tabIndex;

        public TabRepaintCallback(JTabbedPane tabPane, int tabIndex) {
            this.tabbedPane = tabPane;
            this.tabIndex = tabIndex;
        }

        public void onTimelinePulse(float durationFraction, float timelinePosition) {
            this.repaintTab();
        }

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            this.repaintTab();
        }

        protected void repaintTab() {
            SwingUtilities.invokeLater(() -> {
                if (SubstanceTabbedPaneUI.this.tabPane == null) {
                    return;
                }
                SubstanceTabbedPaneUI.this.ensureCurrentLayout();
                int tabCount = SubstanceTabbedPaneUI.this.tabPane.getTabCount();
                if (tabCount > 0 && this.tabIndex < tabCount && this.tabIndex < SubstanceTabbedPaneUI.this.rects.length) {
                    Rectangle rect = SubstanceTabbedPaneUI.this.getTabBounds(SubstanceTabbedPaneUI.this.tabPane, this.tabIndex);
                    SubstanceTabbedPaneUI.this.tabPane.repaint(rect);
                }
            });
        }
    }

    private class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        private int prevRolledOver = -1;
        private boolean prevInCloseButton = false;
        private int tabOfPressedCloseButton = -1;

        private MouseRolloverHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            TabCloseCallback closeCallback = SubstanceCoreUtilities.getTabCloseCallback(SubstanceTabbedPaneUI.this.tabPane, tabIndex);
            if (closeCallback == null) {
                return;
            }
            SubstanceSlices.TabCloseKind tabCloseKind = closeCallback.onAreaClick(SubstanceTabbedPaneUI.this.tabPane, tabIndex, e);
            if (tabCloseKind == SubstanceSlices.TabCloseKind.NONE) {
                return;
            }
            SwingUtilities.invokeLater(() -> SubstanceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.handleMouseMoveDrag(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SubstanceTabbedPaneUI.this.setRolloverTab(SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY()));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SubstanceTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (tabIndex >= 0 && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                Rectangle rect = new Rectangle();
                rect = SubstanceTabbedPaneUI.this.getTabBounds(tabIndex, rect);
                Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(tabIndex, rect.x, rect.y, rect.width, rect.height);
                boolean inCloseButton = close.contains(e.getPoint());
                int n = this.tabOfPressedCloseButton = inCloseButton ? tabIndex : -1;
                if (tabIndex != SubstanceTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (inCloseButton) {
                        return;
                    }
                    SubstanceTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                } else if (SubstanceTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    SubstanceTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handleMouseMoveDrag(e);
        }

        private void handleMouseMoveDrag(MouseEvent e) {
            if (e.getSource() != SubstanceTabbedPaneUI.this.tabPane) {
                return;
            }
            SubstanceTabbedPaneUI.this.setRolloverTab(SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY()));
            if (!AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.ROLLOVER, SubstanceTabbedPaneUI.this.tabPane)) {
                return;
            }
            SubstanceTabbedPaneUI.this.substanceMouseLocation = e.getPoint();
            int currRolledOver = SubstanceTabbedPaneUI.this.getRolloverTab();
            TabCloseCallback tabCloseCallback = SubstanceCoreUtilities.getTabCloseCallback(SubstanceTabbedPaneUI.this.tabPane, currRolledOver);
            if (currRolledOver == this.prevRolledOver) {
                if (currRolledOver >= 0) {
                    Rectangle rect = new Rectangle();
                    rect = SubstanceTabbedPaneUI.this.getTabBounds(currRolledOver, rect);
                    Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(currRolledOver, rect.x, rect.y, rect.width, rect.height);
                    boolean inCloseButton = close.contains(e.getPoint());
                    if (this.prevInCloseButton == inCloseButton) {
                        return;
                    }
                    this.prevInCloseButton = inCloseButton;
                    if (tabCloseCallback != null) {
                        if (inCloseButton) {
                            String closeButtonTooltip = tabCloseCallback.getCloseButtonTooltip(SubstanceTabbedPaneUI.this.tabPane, currRolledOver);
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, closeButtonTooltip);
                        } else {
                            String areaTooltip = tabCloseCallback.getAreaTooltip(SubstanceTabbedPaneUI.this.tabPane, currRolledOver);
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, areaTooltip);
                        }
                    }
                    if (currRolledOver >= 0 && currRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount()) {
                        StateTransitionTracker tracker = SubstanceTabbedPaneUI.this.getTracker(currRolledOver, true, currRolledOver == SubstanceTabbedPaneUI.this.currSelectedIndex);
                        tracker.getModel().setRollover(false);
                        tracker.endTransition();
                    }
                }
            } else {
                if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                    SubstanceTabbedPaneUI.this.getTracker(this.prevRolledOver, true, this.prevRolledOver == SubstanceTabbedPaneUI.this.currSelectedIndex).getModel().setRollover(false);
                }
                if (currRolledOver >= 0 && currRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(currRolledOver)) {
                    SubstanceTabbedPaneUI.this.getTracker(currRolledOver, false, currRolledOver == SubstanceTabbedPaneUI.this.currSelectedIndex).getModel().setRollover(true);
                }
            }
            this.prevRolledOver = currRolledOver;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SubstanceTabbedPaneUI.this.setRolloverTab(-1);
            if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                SubstanceTabbedPaneUI.this.getTracker(this.prevRolledOver, true, this.prevRolledOver == SubstanceTabbedPaneUI.this.currSelectedIndex).getModel().setRollover(false);
                if (SubstanceCoreUtilities.getTabCloseCallback(SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver) != null) {
                    SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(this.prevRolledOver, null);
                }
            }
            this.prevRolledOver = -1;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (SubstanceCoreUtilities.hasCloseButton(SubstanceTabbedPaneUI.this.tabPane, tabIndex) && tabIndex == this.tabOfPressedCloseButton) {
                SwingUtilities.invokeLater(() -> {
                    if (tabIndex >= 0 && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                        Rectangle rect = new Rectangle();
                        rect = SubstanceTabbedPaneUI.this.getTabBounds(tabIndex, rect);
                        Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(tabIndex, rect.x, rect.y, rect.width, rect.height);
                        if (close.contains(e.getPoint())) {
                            TabCloseCallback closeCallback = SubstanceCoreUtilities.getTabCloseCallback(SubstanceTabbedPaneUI.this.tabPane, tabIndex);
                            SubstanceSlices.TabCloseKind tabCloseKind = closeCallback == null ? SubstanceSlices.TabCloseKind.THIS : closeCallback.onCloseButtonClick(SubstanceTabbedPaneUI.this.tabPane, tabIndex, e);
                            SubstanceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind);
                        }
                    }
                });
                this.tabOfPressedCloseButton = -1;
            }
        }
    }

    private final class TabbedContainerListener
    extends ContainerAdapter {
        private Map<Component, List<PropertyChangeListener>> listeners = new HashMap<Component, List<PropertyChangeListener>>();

        private TabbedContainerListener() {
        }

        private void trackExistingTabs() {
            for (int i = 0; i < SubstanceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.trackTab(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        private void trackTab(Component tabComponent) {
            int tabIndex;
            if (tabComponent == null) {
                return;
            }
            PropertyChangeListener tabModifiedListener = propertyChangeEvent -> {
                if ("substancelaf.internal.contentsModified".equals(propertyChangeEvent.getPropertyName())) {
                    int tabIndex;
                    Object oldValue = propertyChangeEvent.getOldValue();
                    Object newValue = propertyChangeEvent.getNewValue();
                    boolean wasModified = Boolean.TRUE.equals(oldValue);
                    boolean isModified = Boolean.TRUE.equals(newValue);
                    if (wasModified) {
                        if (!isModified) {
                            Timeline modifiedTimeline = (Timeline)SubstanceTabbedPaneUI.this.modifiedTimelines.get(tabComponent);
                            modifiedTimeline.cancel();
                            SubstanceTabbedPaneUI.this.modifiedTimelines.remove(tabComponent);
                        }
                    } else if (isModified && (tabIndex = SubstanceTabbedPaneUI.this.tabPane.indexOfComponent(tabComponent)) >= 0) {
                        SubstanceTabbedPaneUI.this.trackTabModification(tabIndex, tabComponent);
                    }
                }
            };
            tabComponent.addPropertyChangeListener(tabModifiedListener);
            List<PropertyChangeListener> currList = this.listeners.get(tabComponent);
            if (currList == null) {
                currList = new LinkedList<PropertyChangeListener>();
            }
            currList.add(tabModifiedListener);
            this.listeners.put(tabComponent, currList);
            if (tabComponent instanceof JComponent && Boolean.TRUE.equals(((JComponent)tabComponent).getClientProperty("substancelaf.internal.contentsModified")) && (tabIndex = SubstanceTabbedPaneUI.this.tabPane.indexOfComponent(tabComponent)) >= 0) {
                SubstanceTabbedPaneUI.this.trackTabModification(tabIndex, tabComponent);
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent instanceof UIResource) {
                return;
            }
            this.trackTab(tabComponent);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent == null) {
                return;
            }
            if (tabComponent instanceof UIResource) {
                return;
            }
            for (PropertyChangeListener pcl : this.listeners.get(tabComponent)) {
                tabComponent.removePropertyChangeListener(pcl);
            }
            this.listeners.get(tabComponent).clear();
            this.listeners.remove(tabComponent);
            Timeline timeline = (Timeline)SubstanceTabbedPaneUI.this.modifiedTimelines.get(tabComponent);
            if (timeline != null) {
                timeline.cancel();
                SubstanceTabbedPaneUI.this.modifiedTimelines.remove(tabComponent);
            }
        }
    }
}

