/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.security.AccessControlException;
import javax.swing.AbstractButton;
import javax.swing.plaf.basic.BasicButtonListener;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;

public class RolloverButtonListener
extends BasicButtonListener {
    private boolean isMouseInside;
    private AbstractButton button;
    private StateTransitionTracker stateTransitionTracker;

    public RolloverButtonListener(AbstractButton b, StateTransitionTracker stateTransitionTracker) {
        super(b);
        this.button = b;
        this.isMouseInside = false;
        this.stateTransitionTracker = stateTransitionTracker;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean isMouseDrag;
            super.mouseEntered(e);
            this.isMouseInside = true;
            boolean bl = isMouseDrag = e.getButton() == 1;
            if (!isMouseDrag) {
                this.button.getModel().setRollover(true);
            }
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseExited(e);
            this.isMouseInside = false;
            this.button.getModel().setRollover(false);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseReleased(e);
            for (ActionListener al : this.button.getActionListeners()) {
                if (!(al instanceof SubstanceInternalFrameTitlePane.ClickListener)) continue;
                return;
            }
            this.button.getModel().setRollover(this.isMouseInside);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseMoved(e);
            for (ActionListener al : this.button.getActionListeners()) {
                if (!(al instanceof SubstanceInternalFrameTitlePane.ClickListener)) continue;
                return;
            }
            this.button.getModel().setRollover(this.isMouseInside);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusGained(FocusEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.focusGained(e);
            if (!this.button.isShowing()) {
                return;
            }
            try {
                PointerInfo pi = MouseInfo.getPointerInfo();
                int px = pi.getLocation().x - this.button.getLocationOnScreen().x;
                int py = pi.getLocation().y - this.button.getLocationOnScreen().y;
                this.button.getModel().setRollover(this.button.contains(px, py));
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.focusLost(e);
            this.button.getModel().setRollover(false);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseClicked(e);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseDragged(e);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mousePressed(e);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }
}

