/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.colorscheme.ColorTransform;
import org.pushingpixels.substance.api.colorscheme.SchemeBaseColors;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;

@FunctionalInterface
public interface ColorSchemeSingleColorQuery {
    public static final ColorSchemeSingleColorQuery ULTRALIGHT = SchemeBaseColors::getUltraLightColor;
    public static final ColorSchemeSingleColorQuery EXTRALIGHT = SchemeBaseColors::getExtraLightColor;
    public static final ColorSchemeSingleColorQuery LIGHT = SchemeBaseColors::getLightColor;
    public static final ColorSchemeSingleColorQuery MID = SchemeBaseColors::getMidColor;
    public static final ColorSchemeSingleColorQuery DARK = SchemeBaseColors::getDarkColor;
    public static final ColorSchemeSingleColorQuery ULTRADARK = SchemeBaseColors::getUltraDarkColor;
    public static final ColorSchemeSingleColorQuery FOREGROUND = SchemeBaseColors::getForegroundColor;

    public Color query(SubstanceColorScheme var1);

    public static ColorSchemeSingleColorQuery composite(ColorSchemeSingleColorQuery base, ColorTransform ... transforms) {
        return scheme -> {
            Color result = base.query(scheme);
            for (ColorTransform transform : transforms) {
                result = transform.transform(result);
            }
            return result;
        };
    }
}

