/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.shaper;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.shaper.RectangularButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;

public class PillButtonShaper
implements SubstanceButtonShaper,
RectangularButtonShaper {
    private static final LazyResettableHashMap<Shape> contours = new LazyResettableHashMap("PillButtonShaper");

    @Override
    public String getDisplayName() {
        return "Pill";
    }

    @Override
    public Shape getButtonOutline(AbstractButton button, float extraInsets, float width, float height, boolean isInner) {
        HashMapKey key;
        Shape result;
        Set<SubstanceSlices.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.internal.buttonStraightSide");
        float radius = this.getCornerRadius(button, extraInsets);
        if (isInner && (radius -= SubstanceSizeUtils.getBorderStrokeWidth(button)) < 0.0f) {
            radius = 0.0f;
        }
        if ((result = contours.get(key = SubstanceCoreUtilities.getHashKey(Float.valueOf(width), Float.valueOf(height), straightSides, Float.valueOf(radius), Float.valueOf(extraInsets)))) != null) {
            return result;
        }
        result = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, straightSides, extraInsets);
        contours.put(key, result);
        return result;
    }

    @Override
    public Border getButtonBorder(final AbstractButton button) {
        return new SubstanceButtonBorder(PillButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component c) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(button);
                Insets buttonInsets = SubstanceSizeUtils.getButtonInsets(button, fontSize);
                float focusPadding = SubstanceSizeUtils.getFocusRingPadding(button, fontSize);
                int lrPadding = SubstanceCoreUtilities.hasText(button) ? SubstanceSizeUtils.getTextButtonLRPadding(fontSize) : 0;
                Set<SubstanceSlices.Side> openSides = SubstanceCoreUtilities.getSides(button, "substancelaf.internal.buttonOpenSide");
                int left = lrPadding + buttonInsets.left + (int)focusPadding + (openSides != null && openSides.contains((Object)SubstanceSlices.Side.LEFT) ? -1 : 0);
                int right = lrPadding + buttonInsets.right + (int)focusPadding + (openSides != null && openSides.contains((Object)SubstanceSlices.Side.RIGHT) ? -1 : 0);
                int top = buttonInsets.top + (openSides != null && openSides.contains((Object)SubstanceSlices.Side.TOP) ? -1 : 0);
                int bottom = buttonInsets.bottom + (openSides != null && openSides.contains((Object)SubstanceSlices.Side.BOTTOM) ? -1 : 0);
                return new Insets(top, left, bottom, right);
            }
        };
    }

    @Override
    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = SubstanceCoreUtilities.hasIcon(button);
        boolean hasText = SubstanceCoreUtilities.hasText(button);
        Insets margin = button.getMargin();
        Dimension result = uiPreferredSize;
        boolean hasNoMinSizeProperty = SubstanceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            baseWidth = Math.max(baseWidth + uiPreferredSize.height, SubstanceSizeUtils.getMinButtonWidth(SubstanceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result.height;
            result = new Dimension(result.width, baseHeight);
        } else if (hasNoMinSizeProperty && margin != null) {
            result = new Dimension(result.width + margin.left + margin.right, result.height + margin.top + margin.bottom);
        }
        int extraPadding = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(button));
        int iconPaddingWidth = 6 + 2 * extraPadding;
        int iconPaddingHeight = 6 + 2 * extraPadding;
        if (margin != null) {
            iconPaddingWidth = Math.max(iconPaddingWidth, margin.left + margin.right);
            iconPaddingHeight = Math.max(iconPaddingHeight, margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - (double)iconPaddingHeight) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - (double)iconPaddingWidth) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (SubstanceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + iconPaddingWidth, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + iconPaddingHeight);
        }
        if (result.height % 2 != 0) {
            ++result.height;
        }
        return result;
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !SubstanceCoreUtilities.isComboBoxButton(button) && !SubstanceCoreUtilities.isScrollButton(button) && SubstanceCoreUtilities.hasText(button);
    }

    @Override
    public boolean isProportionate() {
        return true;
    }

    @Override
    public float getCornerRadius(AbstractButton button, float insets) {
        Border parentBorder;
        float width = (float)button.getWidth() - 2.0f * insets;
        float height = (float)button.getHeight() - 2.0f * insets;
        boolean isRoundCorners = PillButtonShaper.isRoundButton(button);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(button));
        if (button.getClass().isAnnotationPresent(SubstanceInternalArrowButton.class) && (parentBorder = ((JComponent)button.getParent()).getBorder()) instanceof SubstanceBorder) {
            radius *= ((SubstanceBorder)parentBorder).getRadiusScaleFactor();
        }
        if (isRoundCorners) {
            radius = width > height ? height / 2.0f : width / 2.0f;
        }
        if (SubstanceCoreUtilities.isToolBarButton(button)) {
            radius = SubstanceCoreUtilities.getToolbarButtonCornerRadius(button, insets);
        }
        return radius;
    }
}

