/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.NeonIconUIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.icon.SubstanceIconPack;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceFileChooserUI
extends MetalFileChooserUI {
    private final SubstanceFileView fileView = new SubstanceFileView();
    private static final int ICON_SIZE = 14;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceFileChooserUI((JFileChooser)comp);
    }

    private SubstanceFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    @Override
    protected void installIcons(JFileChooser fc) {
        super.installIcons(fc);
        SubstanceIconPack iconPack = SubstanceCortex.GlobalScope.getIconPack();
        SubstanceColorScheme colorScheme = SubstanceCoreUtilities.getSkin(fc).getEnabledColorScheme(SubstanceSlices.DecorationAreaType.NONE);
        this.directoryIcon = iconPack.getFileChooserDirectoryIcon(14, colorScheme);
        this.fileIcon = iconPack.getFileChooserFileIcon(14, colorScheme);
        this.computerIcon = iconPack.getFileChooserComputerIcon(14, colorScheme);
        this.hardDriveIcon = iconPack.getFileChooserHardDriveIcon(14, colorScheme);
        this.floppyDriveIcon = iconPack.getFileChooserFloppyDriveIcon(14, colorScheme);
        this.newFolderIcon = iconPack.getFileChooserNewFolderIcon(14, colorScheme);
        this.upFolderIcon = iconPack.getFileChooserUpFolderIcon(14, colorScheme);
        this.homeFolderIcon = iconPack.getFileChooserHomeFolderIcon(14, colorScheme);
        this.detailsViewIcon = iconPack.getFileChooserDetailsViewIcon(14, colorScheme);
        this.listViewIcon = iconPack.getFileChooserListViewIcon(14, colorScheme);
        this.viewMenuIcon = iconPack.getFileChooserViewMenuIcon(14, colorScheme);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        super.installComponents(fc);
        JPanel buttonPanel = this.getButtonPanel();
        buttonPanel.setLayout(new SubstanceFooterLayout(SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(buttonPanel), 8, 4, 1, true), SubstanceCortex.GlobalScope.getButtonBarOrder().isDefaultButtonLeading()));
        buttonPanel.setBorder(new EmptyBorder(SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(buttonPanel), 16, 4, 1, true), 0, 0, 0));
    }

    private static class SubstanceFooterLayout
    implements LayoutManager {
        private int padding;
        private boolean isDefaultButtonLeading;

        public SubstanceFooterLayout(int padding, boolean isDefaultButtonLeading) {
            this.padding = padding;
            this.isDefaultButtonLeading = isDefaultButtonLeading;
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        private Dimension getMaxButtonSize(Container container) {
            Component[] children = container.getComponents();
            Dimension result = new Dimension(0, 0);
            for (Component child : children) {
                Dimension pref = child.getPreferredSize();
                result.width = Math.max(result.width, pref.width);
                result.height = Math.max(result.height, pref.height);
            }
            return result;
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int x;
                int numChildren = children.length;
                Insets insets = container.getInsets();
                Dimension maxDimension = this.getMaxButtonSize(container);
                int totalButtonWidth = maxDimension.width * numChildren + this.padding * (numChildren - 1);
                boolean isLeftToRight = container.getComponentOrientation().isLeftToRight();
                int buttonAlignment = SubstanceCoreUtilities.getButtonBarGravity(container);
                switch (buttonAlignment) {
                    case 2: {
                        x = insets.left;
                        break;
                    }
                    case 0: {
                        x = (container.getWidth() - insets.left - insets.right - totalButtonWidth) / 2;
                        break;
                    }
                    default: {
                        x = container.getWidth() - insets.right - totalButtonWidth;
                    }
                }
                boolean iterateForward = isLeftToRight == this.isDefaultButtonLeading;
                for (int counter = 0; counter < numChildren; ++counter) {
                    int index = iterateForward ? counter : numChildren - counter - 1;
                    children[index].setBounds(x, insets.top, maxDimension.width, maxDimension.height);
                    x += children[index].getWidth() + this.padding;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            if (container == null) {
                return new Dimension(0, 0);
            }
            Component[] children = container.getComponents();
            if (children == null || children.length == 0) {
                return new Dimension(0, 0);
            }
            int numChildren = children.length;
            Insets insets = container.getInsets();
            Dimension maxDimension = this.getMaxButtonSize(container);
            return new Dimension(insets.left + insets.right + maxDimension.width * numChildren + this.padding * (numChildren - 1), insets.top + insets.bottom + maxDimension.height);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }

    private class SubstanceFileView
    extends BasicFileChooserUI.BasicFileView {
        private final Map<String, Icon> pathIconCache;

        private SubstanceFileView() {
            super(SubstanceFileChooserUI.this);
            this.pathIconCache = new HashMap<String, Icon>();
        }

        @Override
        public Icon getCachedIcon(File f) {
            return this.pathIconCache.get(f.getPath());
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            icon = this.getDefaultIcon(f);
            if (icon == null && (icon = super.getIcon(f)) == null) {
                icon = new ImageIcon(SubstanceCoreUtilities.getBlankImage(NeonCortex.getScaleFactor(null), 8, 8));
            }
            this.cacheIcon(f, icon);
            return icon;
        }

        @Override
        public void cacheIcon(File f, Icon icon) {
            this.pathIconCache.put(f.getPath(), icon);
        }

        @Override
        public void clearIconCache() {
            this.pathIconCache.clear();
        }

        public Icon getDefaultIcon(File f) {
            JFileChooser fileChooser = SubstanceFileChooserUI.this.getFileChooser();
            Icon icon = fileChooser.getFileSystemView().getSystemIcon(f);
            if (icon instanceof NeonIconUIResource) {
                SubstanceIconPack iconPack = SubstanceCortex.GlobalScope.getIconPack();
                SubstanceColorScheme colorScheme = SubstanceCoreUtilities.getSkin(fileChooser).getEnabledColorScheme(SubstanceSlices.DecorationAreaType.NONE);
                icon = f.isDirectory() ? iconPack.getFileChooserDirectoryIcon(14, colorScheme) : iconPack.getFileChooserFileIcon(14, colorScheme);
            }
            float labelAlpha = SubstanceColorSchemeUtilities.getAlpha(fileChooser, ComponentState.ENABLED);
            Color textColor = SubstanceTextUtilities.getForegroundColor((JComponent)fileChooser, "", ComponentState.ENABLED, labelAlpha);
            icon = SubstanceCoreUtilities.getFilteredIcon(fileChooser, icon, ComponentState.ENABLED, textColor);
            return icon;
        }
    }
}

