/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.ButtonVisualStateTracker;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostingListener;

public class SubstanceToggleButtonUI
extends BasicToggleButtonUI
implements TransitionAwareUI {
    private ButtonBackgroundDelegate delegate;
    private GlowingIcon glowingIcon;
    private PropertyChangeListener substancePropertyListener;
    private ButtonVisualStateTracker substanceVisualStateTracker;
    private GhostingListener ghostModelChangeListener;
    private JToggleButton toggleButton;
    private Color textColor;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceToggleButtonUI((JToggleButton)comp);
    }

    private SubstanceToggleButtonUI(JToggleButton toggleButton) {
        this.toggleButton = toggleButton;
        this.delegate = new ButtonBackgroundDelegate();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (b.getClientProperty("substancelaf.internal.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.internal.buttonborderoriginal", b.getBorder());
        }
        if (b.getClientProperty("substancelaf.internal.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.internal.buttonborderoriginal", b.getBorder());
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty("substancelaf.internal.buttonbordercomputed") == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty("substancelaf.internal.controlopacityoriginal", b.isOpaque());
        b.setOpaque(false);
        b.setRolloverEnabled(true);
        LookAndFeel.installProperty(b, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(b)));
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty("substancelaf.internal.buttonborderoriginal"));
        b.setOpaque((Boolean)b.getClientProperty("substancelaf.internal.controlopacityoriginal"));
        b.putClientProperty("substancelaf.internal.controlopacityoriginal", null);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.substanceVisualStateTracker = new ButtonVisualStateTracker();
        this.substanceVisualStateTracker.installListeners(b, true);
        this.trackGlowingIcon();
        this.substancePropertyListener = propertyChangeEvent -> {
            if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                this.trackGlowingIcon();
            }
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                if (this.ghostModelChangeListener != null) {
                    this.ghostModelChangeListener.unregisterListeners();
                }
                this.ghostModelChangeListener = new GhostingListener(b, b.getModel());
                this.ghostModelChangeListener.registerListeners();
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        this.ghostModelChangeListener = new GhostingListener(b, b.getModel());
        this.ghostModelChangeListener.registerListeners();
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        this.substanceVisualStateTracker.uninstallListeners(b);
        this.substanceVisualStateTracker = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.ghostModelChangeListener.unregisterListeners();
        this.ghostModelChangeListener = null;
        super.uninstallListeners(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        this.viewRect.x = i.left;
        this.viewRect.y = i.top;
        this.viewRect.width = b.getWidth() - (i.right + this.viewRect.x);
        this.viewRect.height = b.getHeight() - (i.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font f = c.getFont();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        View v = (View)c.getClientProperty("html");
        g2d.setFont(f);
        this.delegate.updateBackground(g2d, b);
        if (v != null) {
            v.paint(g2d, this.textRect);
        } else {
            this.textColor = this.paintButtonText(g2d, b, this.textRect, text);
        }
        if (b.getIcon() != null) {
            this.paintIcon((Graphics)g2d, b, this.iconRect);
        }
        if (b.isFocusPainted()) {
            SubstanceCoreUtilities.paintFocus(g, b, b, this, null, this.textRect, 1.0f, SubstanceSizeUtils.getFocusRingPadding(b, SubstanceSizeUtils.getComponentFontSize(b)));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        Dimension superPref = SubstanceMetricsUtilities.getPreferredButtonSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        return shaper.getPreferredSize(button, superPref);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JToggleButton)c, x, y);
    }

    @Override
    protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        b.putClientProperty("icon.bounds", new Rectangle(iconRect));
        Graphics2D graphics = (Graphics2D)g.create();
        GhostPaintingUtils.paintGhostIcon(graphics, b, iconRect);
        Icon originalIcon = SubstanceCoreUtilities.getOriginalIcon(b, b.getIcon());
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)b, g));
        graphics.translate(iconRect.x, iconRect.y);
        StateTransitionTracker stateTracker = this.substanceVisualStateTracker.getStateTransitionTracker();
        if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.ICON_GLOW, b) && stateTracker.getIconGlowTracker().isPlaying()) {
            this.glowingIcon.paintIcon(b, graphics, 0, 0);
        } else {
            StateTransitionTracker.ModelStateInfo stateInfo = stateTracker.getModelStateInfo();
            ComponentState currentState = stateInfo.getCurrModelState();
            if (currentState.isDisabled()) {
                Icon disabledIcon = SubstanceCoreUtilities.getFilteredIcon(b, originalIcon, currentState, this.textColor);
                disabledIcon.paintIcon(b, graphics, 0, 0);
            } else {
                Icon enabledIcon = SubstanceCoreUtilities.getFilteredIcon(b, originalIcon, ComponentState.ENABLED, this.textColor);
                enabledIcon.paintIcon(b, graphics, 0, 0);
                if (stateTracker.getActiveStrength() > 0.0f) {
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : stateInfo.getStateContributionMap().entrySet()) {
                        Icon activeIcon;
                        float contribution;
                        if (entry.getKey() == ComponentState.ENABLED || !((contribution = entry.getValue().getContribution()) > 0.0f) || (activeIcon = SubstanceCoreUtilities.getFilteredIcon(b, originalIcon, entry.getKey(), this.textColor)) == enabledIcon) continue;
                        graphics.setComposite(WidgetUtilities.getAlphaComposite(b, contribution, g));
                        activeIcon.paintIcon(b, graphics, 0, 0);
                    }
                }
            }
        }
        graphics.dispose();
    }

    private Color paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        return SubstanceTextUtilities.paintText(g, button, textRect, text, button.getDisplayedMnemonicIndex());
    }

    private void trackGlowingIcon() {
        Icon currIcon = this.toggleButton.getIcon();
        if (currIcon instanceof GlowingIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(currIcon, this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return this.contains(this.toggleButton, me.getX(), me.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getStateTransitionTracker();
    }
}

