/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.NeonIcon;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.ImageHashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

@TransitionAware
public class HighlightableTransitionAwareIcon
implements Icon {
    private static LazyResettableHashMap<NeonIcon> iconMap = new LazyResettableHashMap("HighlightableTransitionAwareIcon");
    private int iconWidth;
    private int iconHeight;
    private TransitionAwareIcon.Delegate delegate;
    private JComponent component;
    private SubstanceSlices.ComponentStateFacet facetForHighlights;
    private TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate;
    private String uniqueIconTypeId;

    public HighlightableTransitionAwareIcon(JComponent component, TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, TransitionAwareIcon.Delegate delegate, SubstanceSlices.ComponentStateFacet facetForHighlights, String uniqueIconTypeId) {
        this.component = component;
        this.facetForHighlights = facetForHighlights;
        this.transitionAwareUIDelegate = transitionAwareUIDelegate;
        this.delegate = delegate;
        this.uniqueIconTypeId = uniqueIconTypeId;
        NeonIcon enabledIcon = this.delegate.getColorSchemeIcon(SubstanceColorSchemeUtilities.getColorScheme(component, ComponentState.ENABLED));
        this.iconWidth = enabledIcon.getIconWidth();
        this.iconHeight = enabledIcon.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconToPaint().paintIcon(c, g, x, y);
    }

    private NeonIcon getIconToPaint() {
        double scale = NeonCortex.getScaleFactor((Component)this.component);
        StateTransitionTracker stateTransitionTracker = this.transitionAwareUIDelegate.getTransitionAwareUI().getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        SubstanceSlices.ColorSchemeAssociationKind baseAssociationKind = currState.isFacetActive(this.facetForHighlights) ? SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT : SubstanceSlices.ColorSchemeAssociationKind.MARK;
        SubstanceColorScheme baseScheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, baseAssociationKind, currState);
        float baseAlpha = SubstanceColorSchemeUtilities.getAlpha(this.component, currState);
        ImageHashMapKey keyBase = SubstanceCoreUtilities.getScaleAwareHashKey(scale, this.component.getClass().getName(), this.uniqueIconTypeId, SubstanceSizeUtils.getComponentFontSize(this.component), baseScheme.getDisplayName(), Float.valueOf(baseAlpha));
        NeonIcon layerBase = iconMap.get(keyBase);
        if (layerBase == null) {
            NeonIcon baseFullOpacity = this.delegate.getColorSchemeIcon(baseScheme);
            if (baseAlpha == 1.0f) {
                layerBase = baseFullOpacity;
                iconMap.put(keyBase, layerBase);
            } else {
                BufferedImage baseImage = SubstanceCoreUtilities.getBlankImage(scale, baseFullOpacity.getIconWidth(), baseFullOpacity.getIconHeight());
                Graphics2D g2base = baseImage.createGraphics();
                g2base.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
                baseFullOpacity.paintIcon((Component)this.component, (Graphics)g2base, 0, 0);
                g2base.dispose();
                layerBase = new ScaleAwareImageWrapperIcon(baseImage, scale);
                iconMap.put(keyBase, layerBase);
            }
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(scale, layerBase.getIconWidth(), layerBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        layerBase.paintIcon((Component)this.component, (Graphics)g2d, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            SubstanceSlices.ColorSchemeAssociationKind associationKind = activeState.isFacetActive(this.facetForHighlights) ? SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT : SubstanceSlices.ColorSchemeAssociationKind.MARK;
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, associationKind, activeState);
            float alpha = SubstanceColorSchemeUtilities.getAlpha(this.component, activeState);
            ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, this.component.getClass().getName(), this.uniqueIconTypeId, SubstanceSizeUtils.getComponentFontSize(this.component), scheme.getDisplayName(), Float.valueOf(alpha));
            NeonIcon layer = iconMap.get(key);
            if (layer == null) {
                NeonIcon fullOpacity = this.delegate.getColorSchemeIcon(scheme);
                if (alpha == 1.0f) {
                    layer = fullOpacity;
                    iconMap.put(key, layer);
                } else {
                    BufferedImage image = SubstanceCoreUtilities.getBlankImage(scale, fullOpacity.getIconWidth(), fullOpacity.getIconHeight());
                    Graphics2D g2layer = image.createGraphics();
                    g2layer.setComposite(AlphaComposite.SrcOver.derive(alpha));
                    fullOpacity.paintIcon((Component)this.component, (Graphics)g2layer, 0, 0);
                    g2layer.dispose();
                    layer = new ScaleAwareImageWrapperIcon(image, scale);
                    iconMap.put(key, layer);
                }
            }
            layer.paintIcon((Component)this.component, (Graphics)g2d, 0, 0);
        }
        g2d.dispose();
        return new ScaleAwareImageWrapperIcon(result, scale);
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }
}

