/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.extras.api.colorschemepack;

import java.awt.Color;
import org.pushingpixels.radiance.theming.api.colorscheme.BaseColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;

public class MixColorScheme
extends BaseColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private RadianceColorScheme[] origSchemes;

    public MixColorScheme(String displayName, RadianceColorScheme ... origSchemes) {
        super(displayName, origSchemes[0].isDark());
        if (origSchemes == null || origSchemes.length < 2) {
            throw new IllegalArgumentException("At least two schemes needed for a mix scheme");
        }
        this.origSchemes = origSchemes;
        this.foregroundColor = this.origSchemes[0].getForegroundColor();
        this.mainUltraDarkColor = this.origSchemes[0].getUltraDarkColor();
        this.mainDarkColor = this.origSchemes[0].getDarkColor();
        this.mainMidColor = this.origSchemes[0].getMidColor();
        this.mainLightColor = this.origSchemes[0].getLightColor();
        this.mainExtraLightColor = this.origSchemes[0].getExtraLightColor();
        this.mainUltraLightColor = this.origSchemes[0].getUltraLightColor();
        StringBuffer idBuf = new StringBuffer();
        idBuf.append("Mixed ");
        String delim = "";
        for (RadianceColorScheme origScheme : origSchemes) {
            idBuf.append(delim);
            idBuf.append(origScheme.getDisplayName());
            delim = " & ";
        }
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public RadianceColorScheme[] getOrigSchemes() {
        return this.origSchemes;
    }

    public RadianceColorScheme tint(double tintFactor) {
        RadianceColorScheme[] tinted = new RadianceColorScheme[this.origSchemes.length];
        for (int i = 0; i < this.origSchemes.length; ++i) {
            tinted[i] = this.origSchemes[i].tint(tintFactor);
        }
        return new MixColorScheme("Tinted " + this.displayName + " " + tintFactor, tinted);
    }

    public RadianceColorScheme tone(double toneFactor) {
        RadianceColorScheme[] toned = new RadianceColorScheme[this.origSchemes.length];
        for (int i = 0; i < this.origSchemes.length; ++i) {
            toned[i] = this.origSchemes[i].tone(toneFactor);
        }
        return new MixColorScheme("Toned " + this.displayName + " " + toneFactor, toned);
    }

    public RadianceColorScheme shade(double shadeFactor) {
        RadianceColorScheme[] shaded = new RadianceColorScheme[this.origSchemes.length];
        for (int i = 0; i < this.origSchemes.length; ++i) {
            shaded[i] = this.origSchemes[i].shade(shadeFactor);
        }
        return new MixColorScheme("Shaded " + this.displayName + " " + shadeFactor, shaded);
    }

    public RadianceColorScheme saturate(double saturateFactor) {
        RadianceColorScheme[] saturated = new RadianceColorScheme[this.origSchemes.length];
        for (int i = 0; i < this.origSchemes.length; ++i) {
            saturated[i] = this.origSchemes[i].saturate(saturateFactor);
        }
        return new MixColorScheme("Saturated " + this.displayName + " " + saturateFactor, saturated);
    }

    public RadianceColorScheme hueShift(double hueShiftFactor) {
        RadianceColorScheme[] hieShifted = new RadianceColorScheme[this.origSchemes.length];
        for (int i = 0; i < this.origSchemes.length; ++i) {
            hieShifted[i] = this.origSchemes[i].hueShift(hueShiftFactor);
        }
        return new MixColorScheme("Hue-shifted " + this.displayName + " " + hueShiftFactor, hieShifted);
    }

    public RadianceColorScheme invert() {
        RadianceColorScheme[] inverted = new RadianceColorScheme[this.origSchemes.length];
        for (int i = 0; i < this.origSchemes.length; ++i) {
            inverted[i] = this.origSchemes[i].invert();
        }
        return new MixColorScheme("Inverted " + this.displayName, inverted);
    }

    public RadianceColorScheme negate() {
        RadianceColorScheme[] negated = new RadianceColorScheme[this.origSchemes.length];
        for (int i = 0; i < this.origSchemes.length; ++i) {
            negated[i] = this.origSchemes[i].negate();
        }
        return new MixColorScheme("Negated " + this.displayName, negated);
    }

    public RadianceColorScheme blendWith(RadianceColorScheme otherScheme, double likenessToThisScheme) {
        RadianceColorScheme[] blended = new RadianceColorScheme[this.origSchemes.length];
        for (int i = 0; i < this.origSchemes.length; ++i) {
            blended[i] = this.origSchemes[i].blendWith(otherScheme, likenessToThisScheme);
        }
        return new MixColorScheme("Blended " + this.displayName + " and " + otherScheme.getDisplayName() + " " + likenessToThisScheme, blended);
    }
}

