/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.extras.api.painterpack.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Shape;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.decoration.RadianceDecorationPainter;

public class Glass3DDecorationPainter
implements RadianceDecorationPainter {
    private static final String DISPLAY_NAME = "Glass 3D";

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, int width, int height, RadianceSkin skin) {
        RadianceColorScheme colorScheme = skin.getBackgroundColorScheme(decorationAreaType);
        LinearGradientPaint paint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{colorScheme.getUltraLightColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(paint);
        graphics.fillRect(0, 0, width, height);
    }

    public void paintDecorationArea(Graphics2D graphics, Component comp, RadianceThemingSlices.DecorationAreaType decorationAreaType, Shape contour, RadianceColorScheme colorScheme) {
        LinearGradientPaint paint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, comp.getHeight(), new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{colorScheme.getUltraLightColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(paint);
        graphics.fill(contour);
    }
}

