/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.extras.internal.contrib.blogofbug.swing.borders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.border.AbstractBorder;
import org.pushingpixels.radiance.theming.extras.internal.contrib.blogofbug.swing.borders.AbstractImageBorder;

public class ImageBorder
extends AbstractBorder {
    protected AbstractImageBorder borderRenderer;
    boolean paintBorder = true;

    public ImageBorder(BufferedImage borderImage, Insets imageInsets) {
        this.borderRenderer = new AbstractImageBorder(borderImage, imageInsets);
    }

    public ImageBorder(URL imageURL, Insets imageInsets) {
        this.borderRenderer = new AbstractImageBorder(imageURL, imageInsets);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!this.paintBorder) {
            return;
        }
        this.borderRenderer.paintBorder(c.getWidth(), c.getHeight(), g, x, y, width, height);
    }

    public void setPaintBorder(boolean paintBorder) {
        this.paintBorder = paintBorder;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.borderRenderer.getImageInsets();
    }

    @Override
    public Insets getBorderInsets(Component c, Insets i) {
        Insets imageInsets = this.borderRenderer.getImageInsets();
        i.top = imageInsets.top;
        i.bottom = imageInsets.bottom;
        i.left = imageInsets.left;
        i.right = imageInsets.right;
        return i;
    }

    public void paintCenter(Graphics2D g2, Component c) {
        if (this.paintBorder) {
            this.borderRenderer.paintCenter(g2, c.getWidth(), c.getHeight());
        }
    }
}

